/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InternalConfigOptionsTest
extends TableTestBase {
    private TableEnvironment tEnv;
    private PlannerBase planner;
    @Parameterized.Parameter
    public String plannerMode;

    @Parameterized.Parameters(name="plannerMode = {0}")
    public static Collection<String> parameters() {
        return Arrays.asList("STREAMING", "BATCH");
    }

    @Before
    public void setUp() {
        if (this.plannerMode.equals("STREAMING")) {
            StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
            this.tEnv = util.getTableEnv();
            this.planner = util.getPlanner();
        } else {
            BatchTableTestUtil util = this.batchTestUtil(TableConfig.getDefault());
            this.tEnv = util.getTableEnv();
            this.planner = util.getPlanner();
        }
    }

    @Test
    public void testTranslateExecNodeGraphWithInternalTemporalConf() {
        Table table = this.tEnv.sqlQuery("SELECT LOCALTIME, LOCALTIMESTAMP, CURRENT_TIME, CURRENT_TIMESTAMP");
        RelNode relNode = this.planner.optimize(TableTestUtil.toRelNode(table));
        ExecNodeGraph execNodeGraph = this.planner.translateToExecNodeGraph(JavaScalaConversionUtil.toScala(Collections.singletonList(relNode)), false);
        List transformation = this.planner.translateToPlan(execNodeGraph);
        Assert.assertEquals((long)1L, (long)transformation.size());
    }
}

