/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.delegation.ParserImpl;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.utils.CatalogManagerMocks;

public class PlannerMocks {
    private final FlinkPlannerImpl planner;
    private final ParserImpl parser;
    private final CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
    private final TableConfig tableConfig;
    private final PlannerContext plannerContext;

    private PlannerMocks(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
        ModuleManager moduleManager = new ModuleManager();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, this.catalogManager, moduleManager);
        this.plannerContext = new PlannerContext(false, tableConfig, moduleManager, functionCatalog, this.catalogManager, CalciteSchemaBuilder.asRootSchema((org.apache.calcite.schema.Schema)new CatalogManagerCalciteSchema(this.catalogManager, true)), new ArrayList());
        this.planner = this.plannerContext.createFlinkPlanner(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase());
        this.parser = new ParserImpl(this.catalogManager, () -> this.planner, () -> ((FlinkPlannerImpl)this.planner).parser(), this.plannerContext.getSqlExprToRexConverterFactory());
        this.catalogManager.initSchemaResolver(true, ExpressionResolver.resolverFor((TableConfig)tableConfig, name -> {
            throw new UnsupportedOperationException();
        }, (FunctionLookup)functionCatalog.asLookup(arg_0 -> ((ParserImpl)this.parser).parseIdentifier(arg_0)), (DataTypeFactory)this.catalogManager.getDataTypeFactory(), (arg_0, arg_1, arg_2) -> ((ParserImpl)this.parser).parseSqlExpression(arg_0, arg_1, arg_2), (QueryOperation[])new QueryOperation[0]));
    }

    public FlinkPlannerImpl getPlanner() {
        return this.planner;
    }

    public ParserImpl getParser() {
        return this.parser;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public PlannerMocks registerTemporaryTable(String tableName, Schema tableSchema) {
        CatalogTable table = CatalogTable.of((Schema)tableSchema, null, Collections.emptyList(), Collections.emptyMap());
        this.getCatalogManager().createTemporaryTable((CatalogBaseTable)table, ObjectIdentifier.of((String)this.getCatalogManager().getCurrentCatalog(), (String)this.getCatalogManager().getCurrentDatabase(), (String)tableName), false);
        return this;
    }

    public static PlannerMocks create() {
        return new PlannerMocks(new TableConfig());
    }

    public static PlannerMocks create(Configuration configuration) {
        TableConfig tableConfig = new TableConfig();
        tableConfig.addConfiguration(configuration);
        return new PlannerMocks(tableConfig);
    }
}

