/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.flink.util.FileUtils;

public class TestUserClassLoaderJar {
    public static File createJarFile(File tmpDir, String jarName, String className, String javaCode) throws IOException {
        File javaFile = Paths.get(tmpDir.toString(), className + ".java").toFile();
        javaFile.createNewFile();
        FileUtils.writeFileUtf8((File)javaFile, (String)javaCode);
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> compilationUnit = fileManager.getJavaFileObjectsFromFiles(Collections.singletonList(javaFile));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, Collections.emptyList(), null, compilationUnit);
        task.call();
        File classFile = Paths.get(tmpDir.toString(), className + ".class").toFile();
        File jarFile = Paths.get(tmpDir.toString(), jarName).toFile();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(jarFile));
        JarEntry jarEntry = new JarEntry(className + ".class");
        jos.putNextEntry(jarEntry);
        byte[] classBytes = FileUtils.readAllBytes((Path)classFile.toPath());
        jos.write(classBytes);
        jos.closeEntry();
        jos.close();
        return jarFile;
    }
}

