/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonAggregateFunctionInfo;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.dataview.DataViewSpec;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamExecPythonGroupAggregate
extends StreamExecAggregateBase {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecPythonGroupAggregate.class);
    private static final String PYTHON_STREAM_AGGREAGTE_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.PythonStreamGroupAggregateOperator";
    private final int[] grouping;
    private final AggregateCall[] aggCalls;
    private final boolean[] aggCallNeedRetractions;
    private final boolean generateUpdateBefore;
    private final boolean needRetraction;

    public StreamExecPythonGroupAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, boolean[] aggCallNeedRetractions, boolean generateUpdateBefore, boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecPythonGroupAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecPythonGroupAggregate.class, tableConfig), grouping, aggCalls, aggCallNeedRetractions, generateUpdateBefore, needRetraction, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecPythonGroupAggregate(int id, ExecNodeContext context, ReadableConfig persistedConfig, int[] grouping, AggregateCall[] aggCalls, boolean[] aggCallNeedRetractions, boolean generateUpdateBefore, boolean needRetraction, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.aggCallNeedRetractions = (boolean[])Preconditions.checkNotNull((Object)aggCallNeedRetractions);
        Preconditions.checkArgument((aggCalls.length == aggCallNeedRetractions.length ? 1 : 0) != 0);
        this.generateUpdateBefore = generateUpdateBefore;
        this.needRetraction = needRetraction;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        if (this.grouping.length > 0 && config.getStateRetentionTime() < 0L) {
            LOG.warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.aggCallNeedRetractions, this.needRetraction, true, true);
        int inputCountIndex = aggInfoList.getIndexOfCountStar();
        boolean countStarInserted = aggInfoList.countStarInserted();
        Tuple2<PythonAggregateFunctionInfo[], DataViewSpec[][]> aggInfosAndDataViewSpecs = CommonPythonUtil.extractPythonAggregateFunctionInfos(aggInfoList, this.aggCalls);
        PythonAggregateFunctionInfo[] pythonFunctionInfos = (PythonAggregateFunctionInfo[])aggInfosAndDataViewSpecs.f0;
        DataViewSpec[][] dataViewSpecs = (DataViewSpec[][])aggInfosAndDataViewSpecs.f1;
        Configuration pythonConfig = CommonPythonUtil.extractPythonConfiguration(planner.getExecEnv(), config);
        OneInputStreamOperator<RowData, RowData> operator = this.getPythonAggregateFunctionOperator(pythonConfig, inputRowType, InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType(), pythonFunctionInfos, dataViewSpecs, config.getStateRetentionTime(), TableConfigUtils.getMaxIdleStateRetentionTime(config), inputCountIndex, countStarInserted);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(pythonConfig)) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(this.grouping, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private OneInputStreamOperator<RowData, RowData> getPythonAggregateFunctionOperator(Configuration config, RowType inputType, RowType outputType, PythonAggregateFunctionInfo[] aggregateFunctions, DataViewSpec[][] dataViewSpecs, long minIdleStateRetentionTime, long maxIdleStateRetentionTime, int indexOfCountStar, boolean countStarInserted) {
        Class<?> clazz = CommonPythonUtil.loadClass(PYTHON_STREAM_AGGREAGTE_OPERATOR_NAME);
        try {
            Constructor<?> ctor = clazz.getConstructor(Configuration.class, RowType.class, RowType.class, PythonAggregateFunctionInfo[].class, DataViewSpec[][].class, int[].class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE);
            return (OneInputStreamOperator)ctor.newInstance(new Object[]{config, inputType, outputType, aggregateFunctions, dataViewSpecs, this.grouping, indexOfCountStar, countStarInserted, this.generateUpdateBefore, minIdleStateRetentionTime, maxIdleStateRetentionTime});
        }
        catch (Exception e) {
            throw new TableException("Python Stream Aggregate Function Operator constructed failed.", (Throwable)e);
        }
    }
}

