/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.io.Serializable;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.calcite.CalciteConfigBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001\u001f\tA2)\u00197dSR,7i\u001c8gS\u001e\u0014U/\u001b7eKJ$Vm\u001d;\u000b\u0005\r!\u0011aB2bY\u000eLG/\u001a\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!)A\u0004\u0001C\u0001;\u0005YA/Z:u!J|wM]1n)\u0005q\u0002CA\t \u0013\t\u0001#C\u0001\u0003V]&$\bFA\u000e#!\t\u0019c%D\u0001%\u0015\t)C\"A\u0003kk:LG/\u0003\u0002(I\t!A+Z:u\u0011\u0015I\u0003\u0001\"\u0001\u001e\u0003a!Xm\u001d;EK\u001a\fW\u000f\u001c;Pa\u0016\u0014\u0018\r^8s)\u0006\u0014G.\u001a\u0015\u0003Q\tBQ\u0001\f\u0001\u0005\u0002u\t\u0001\u0004^3tiJ+\u0007\u000f\\1dK>\u0003XM]1u_J$\u0016M\u00197fQ\tY#\u0005C\u00030\u0001\u0011\u0005Q$A\u000euKN$(+\u001a9mC\u000e,\u0017\t\u001a3Pa\u0016\u0014\u0018\r^8s)\u0006\u0014G.\u001a\u0015\u0003]\tBQA\r\u0001\u0005\u0002u\tA\u0003^3ti\u0006#Gm\u00149fe\u0006$xN\u001d+bE2,\u0007FA\u0019#\u0011\u0015)\u0004\u0001\"\u0001\u001e\u0003]!Xm\u001d;BI\u0012\fE\rZ(qKJ\fGo\u001c:UC\ndW\r\u000b\u00025E!)\u0001\b\u0001C\u0001;\u0005\u0011C/Z:u%\u0016\u0004H.Y2f'FdGk\u001c*fY\u000e{gN^3si\u0016\u00148i\u001c8gS\u001eD#a\u000e\u0012\t\u000bm\u0002A\u0011A\u000f\u0002IQ,7\u000f^\"sK\u0006$XMQ;jY\u0012,'OQ1tK\u0012|e.\u00118uQ\u0016\u00148i\u001c8gS\u001eD#A\u000f\u0012")
public class CalciteConfigBuilderTest {
    @Test
    public void testProgram() {
        CalciteConfig cc = new CalciteConfigBuilder().build();
        Assert.assertTrue((boolean)cc.getStreamProgram().isEmpty());
        CalciteConfigBuilder builder = new CalciteConfigBuilder();
        FlinkChainedProgram streamPrograms = FlinkStreamProgram$.MODULE$.buildProgram((ReadableConfig)TableConfig.getDefault());
        streamPrograms.remove(FlinkStreamProgram$.MODULE$.PHYSICAL());
        builder.replaceStreamProgram(streamPrograms);
        CalciteConfig config = builder.build();
        Assert.assertTrue((boolean)config.getStreamProgram().isDefined());
        FlinkChainedProgram flinkChainedProgram = streamPrograms;
        Object object = config.getStreamProgram().get();
        Assert.assertTrue((!(flinkChainedProgram != null ? !flinkChainedProgram.equals(object) : object != null) ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultOperatorTable() {
        CalciteConfig cc = new CalciteConfigBuilder().build();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertFalse((boolean)cc.getSqlOperatorTable().isDefined());
    }

    @Test
    public void testReplaceOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlOperatorTable((SqlOperatorTable)oracleTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)oracleOps.size(), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplaceAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        SqlStdOperatorTable stdTable = new SqlStdOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlOperatorTable((SqlOperatorTable)oracleTable).addSqlOperatorTable((SqlOperatorTable)stdTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Buffer stdOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(stdTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)(oracleOps.size() + stdOps.size()), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
        stdOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testReplaceAddOperatorTable$2(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().addSqlOperatorTable((SqlOperatorTable)oracleTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)oracleOps.size(), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddAddOperatorTable() {
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        SqlStdOperatorTable stdTable = new SqlStdOperatorTable();
        CalciteConfig cc = new CalciteConfigBuilder().addSqlOperatorTable((SqlOperatorTable)oracleTable).addSqlOperatorTable((SqlOperatorTable)stdTable).build();
        Buffer oracleOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(oracleTable.getOperatorList()).asScala();
        Buffer stdOps = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(stdTable.getOperatorList()).asScala();
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)cc.replacesSqlOperatorTable()));
        Assert.assertTrue((boolean)cc.getSqlOperatorTable().isDefined());
        Set ops = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SqlOperatorTable)cc.getSqlOperatorTable().get()).getOperatorList()).asScala()).toSet();
        Assert.assertEquals((long)(oracleOps.size() + stdOps.size()), (long)ops.size());
        oracleOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddAddOperatorTable$1(ops, o);
            return BoxedUnit.UNIT;
        });
        stdOps.foreach((Function1 & Serializable & scala.Serializable)o -> {
            CalciteConfigBuilderTest.$anonfun$testAddAddOperatorTable$2(ops, o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplaceSqlToRelConverterConfig() {
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(false).withExpand(false);
        CalciteConfig cc = new CalciteConfigBuilder().replaceSqlToRelConverterConfig(config).build();
        Assert.assertTrue((boolean)cc.getSqlToRelConverterConfig().isDefined());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)((SqlToRelConverter.Config)cc.getSqlToRelConverterConfig().get()).isExpand()));
    }

    @Test
    public void testCreateBuilderBasedOnAntherConfig() {
        CalciteConfigBuilder builder = CalciteConfig$.MODULE$.createBuilder(CalciteConfig$.MODULE$.DEFAULT());
        CalciteConfig config = builder.build();
        Assert.assertTrue((boolean)config.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config.getStreamProgram().isEmpty());
        Assert.assertTrue((boolean)config.getSqlOperatorTable().isEmpty());
        Assert.assertFalse((boolean)config.replacesSqlOperatorTable());
        Assert.assertTrue((boolean)config.getSqlParserConfig().isEmpty());
        Assert.assertTrue((boolean)config.getSqlToRelConverterConfig().isEmpty());
        FlinkChainedProgram streamPrograms = FlinkStreamProgram$.MODULE$.buildProgram((ReadableConfig)TableConfig.getDefault());
        streamPrograms.remove(FlinkStreamProgram$.MODULE$.PHYSICAL());
        builder.replaceStreamProgram(streamPrograms);
        CalciteConfig baseConfig1 = builder.build();
        CalciteConfigBuilder builder1 = CalciteConfig$.MODULE$.createBuilder(baseConfig1);
        CalciteConfig config1 = builder1.build();
        FlinkChainedProgram flinkChainedProgram = streamPrograms;
        Object object = config1.getStreamProgram().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(flinkChainedProgram != null ? !flinkChainedProgram.equals(object) : object != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config1.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config1.getSqlOperatorTable().isEmpty());
        Assert.assertFalse((boolean)config1.replacesSqlOperatorTable());
        Assert.assertTrue((boolean)config1.getSqlParserConfig().isEmpty());
        Assert.assertTrue((boolean)config1.getSqlToRelConverterConfig().isEmpty());
        SqlToRelConverter.Config sqlToRelConvertConfig = SqlToRelConverter.config().withTrimUnusedFields(false).withExpand(false);
        builder.replaceSqlToRelConverterConfig(sqlToRelConvertConfig);
        CalciteConfig baseConfig2 = builder.build();
        CalciteConfigBuilder builder2 = CalciteConfig$.MODULE$.createBuilder(baseConfig2);
        CalciteConfig config2 = builder2.build();
        FlinkChainedProgram flinkChainedProgram2 = streamPrograms;
        Object object2 = config2.getStreamProgram().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(flinkChainedProgram2 != null ? !flinkChainedProgram2.equals(object2) : object2 != null) ? 1 : 0) != 0);
        SqlToRelConverter.Config config3 = sqlToRelConvertConfig;
        Object object3 = config2.getSqlToRelConverterConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config3 != null ? !config3.equals(object3) : object3 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config2.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config2.getSqlOperatorTable().isEmpty());
        Assert.assertFalse((boolean)config2.replacesSqlOperatorTable());
        Assert.assertTrue((boolean)config2.getSqlParserConfig().isEmpty());
        SqlParser.Config sqlParserConfig = SqlParser.configBuilder().setLex(Lex.ORACLE).build();
        builder.replaceSqlParserConfig(sqlParserConfig);
        CalciteConfig baseConfig3 = builder.build();
        CalciteConfigBuilder builder3 = CalciteConfig$.MODULE$.createBuilder(baseConfig3);
        CalciteConfig config32 = builder3.build();
        FlinkChainedProgram flinkChainedProgram3 = streamPrograms;
        Object object4 = config32.getStreamProgram().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(flinkChainedProgram3 != null ? !flinkChainedProgram3.equals(object4) : object4 != null) ? 1 : 0) != 0);
        SqlToRelConverter.Config config4 = sqlToRelConvertConfig;
        Object object5 = config32.getSqlToRelConverterConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config4 != null ? !config4.equals(object5) : object5 != null) ? 1 : 0) != 0);
        SqlParser.Config config5 = sqlParserConfig;
        Object object6 = config32.getSqlParserConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config5 != null ? !config5.equals(object6) : object6 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config32.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config32.getSqlOperatorTable().isEmpty());
        Assert.assertFalse((boolean)config32.replacesSqlOperatorTable());
        OracleSqlOperatorTable oracleTable = new OracleSqlOperatorTable();
        builder.addSqlOperatorTable((SqlOperatorTable)oracleTable);
        CalciteConfig baseConfig4 = builder.build();
        CalciteConfigBuilder builder4 = CalciteConfig$.MODULE$.createBuilder(baseConfig4);
        CalciteConfig config42 = builder4.build();
        FlinkChainedProgram flinkChainedProgram4 = streamPrograms;
        Object object7 = config42.getStreamProgram().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(flinkChainedProgram4 != null ? !flinkChainedProgram4.equals(object7) : object7 != null) ? 1 : 0) != 0);
        SqlToRelConverter.Config config6 = sqlToRelConvertConfig;
        Object object8 = config42.getSqlToRelConverterConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config6 != null ? !config6.equals(object8) : object8 != null) ? 1 : 0) != 0);
        SqlParser.Config config7 = sqlParserConfig;
        Object object9 = config42.getSqlParserConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config7 != null ? !config7.equals(object9) : object9 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config42.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config42.getSqlOperatorTable().isDefined());
        OracleSqlOperatorTable oracleSqlOperatorTable = oracleTable;
        Object object10 = config42.getSqlOperatorTable().get();
        Assert.assertTrue((!(oracleSqlOperatorTable != null ? !oracleSqlOperatorTable.equals(object10) : object10 != null) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)config42.replacesSqlOperatorTable());
        SqlStdOperatorTable stdTable = new SqlStdOperatorTable();
        builder.replaceSqlOperatorTable((SqlOperatorTable)stdTable);
        CalciteConfig baseConfig5 = builder.build();
        CalciteConfigBuilder builder5 = CalciteConfig$.MODULE$.createBuilder(baseConfig5);
        CalciteConfig config52 = builder5.build();
        FlinkChainedProgram flinkChainedProgram5 = streamPrograms;
        Object object11 = config52.getStreamProgram().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(flinkChainedProgram5 != null ? !flinkChainedProgram5.equals(object11) : object11 != null) ? 1 : 0) != 0);
        SqlToRelConverter.Config config8 = sqlToRelConvertConfig;
        Object object12 = config52.getSqlToRelConverterConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config8 != null ? !config8.equals(object12) : object12 != null) ? 1 : 0) != 0);
        SqlParser.Config config9 = sqlParserConfig;
        Object object13 = config52.getSqlParserConfig().orNull(Predef$.MODULE$.$conforms());
        Assert.assertTrue((!(config9 != null ? !config9.equals(object13) : object13 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config52.getBatchProgram().isEmpty());
        Assert.assertTrue((boolean)config52.getSqlOperatorTable().isDefined());
        SqlStdOperatorTable sqlStdOperatorTable = stdTable;
        Object object14 = config52.getSqlOperatorTable().get();
        Assert.assertTrue((!(sqlStdOperatorTable != null ? !sqlStdOperatorTable.equals(object14) : object14 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config52.replacesSqlOperatorTable());
    }

    public static final /* synthetic */ void $anonfun$testReplaceOperatorTable$1(Set ops$1, SqlOperator o) {
        Assert.assertTrue((boolean)ops$1.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testReplaceAddOperatorTable$1(Set ops$2, SqlOperator o) {
        Assert.assertTrue((boolean)ops$2.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testReplaceAddOperatorTable$2(Set ops$2, SqlOperator o) {
        Assert.assertTrue((boolean)ops$2.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddOperatorTable$1(Set ops$3, SqlOperator o) {
        Assert.assertTrue((boolean)ops$3.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddAddOperatorTable$1(Set ops$4, SqlOperator o) {
        Assert.assertTrue((boolean)ops$4.contains((Object)o));
    }

    public static final /* synthetic */ void $anonfun$testAddAddOperatorTable$2(Set ops$4, SqlOperator o) {
        Assert.assertTrue((boolean)ops$4.contains((Object)o));
    }
}

