/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.types.AbstractDataType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class FlinkCalciteSqlValidatorTest {
    private final PlannerMocks plannerMocks = PlannerMocks.create().registerTemporaryTable("t1", Schema.newBuilder().column("a", (AbstractDataType)DataTypes.INT()).build());

    @Test
    public void testUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }

    @Test
    public void testExplainUpsertInto() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.plannerMocks.getParser().parse("EXPLAIN UPSERT INTO t1 VALUES(1)")).isInstanceOf(ValidationException.class)).hasMessageContaining("UPSERT INTO statement is not supported. Please use INSERT INTO instead.");
    }
}

