/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.metadata.MockMetaTable;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimator;
import org.apache.flink.table.planner.plan.metadata.SelectivityEstimatorTest$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B\u0001\u0003\u0001E\u0011\u0001dU3mK\u000e$\u0018N^5us\u0016\u001bH/[7bi>\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005nKR\fG-\u0019;b\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001aDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0005?\u0005i\u0011\r\u001c7GS\u0016dGMT1nKN,\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r\"\u0012AC2pY2,7\r^5p]&\u0011QE\t\u0002\u0004'\u0016\f\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\t\r=\u0002\u0001\u0015!\u0003!\u00039\tG\u000e\u001c$jK2$g*Y7fg\u0002Bq!\r\u0001C\u0002\u0013%!'A\u0007bY24\u0015.\u001a7e)f\u0004Xm]\u000b\u0002gA\u0019\u0011\u0005\n\u001b\u0011\u0005UbT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u0002;za\u0016T!!\u000f\u001e\u0002\u0007M\fHN\u0003\u0002<\u0019\u000591-\u00197dSR,\u0017BA\u001f7\u0005-\u0019\u0016\u000f\u001c+za\u0016t\u0015-\\3\t\r}\u0002\u0001\u0015!\u00034\u00039\tG\u000e\u001c$jK2$G+\u001f9fg\u0002B!\"\u0011\u0001\u0011\u0002\u0003\r\t\u0015!\u0003C\u0003\rAH%\r\t\u000b'\r+U)R#F\u000b\u0016+\u0015B\u0001#\u0015\u0005\u0019!V\u000f\u001d7fqA\u00111CR\u0005\u0003\u000fR\u00111!\u00138u\u0011\u001dI\u0005A1A\u0005\u0002)\u000b\u0001B\\1nK~KG\r_\u000b\u0002\u000b\"1A\n\u0001Q\u0001\n\u0015\u000b\u0011B\\1nK~KG\r\u001f\u0011\t\u000f9\u0003!\u0019!C\u0001\u0015\u0006Q\u0011-\\8v]R|\u0016\u000e\u001a=\t\rA\u0003\u0001\u0015!\u0003F\u0003-\tWn\\;oi~KG\r\u001f\u0011\t\u000fI\u0003!\u0019!C\u0001\u0015\u0006I\u0001O]5dK~KG\r\u001f\u0005\u0007)\u0002\u0001\u000b\u0011B#\u0002\u0015A\u0014\u0018nY3`S\u0012D\b\u0005C\u0004W\u0001\t\u0007I\u0011\u0001&\u0002\u0011\u0019d\u0017mZ0jIbDa\u0001\u0017\u0001!\u0002\u0013)\u0015!\u00034mC\u001e|\u0016\u000e\u001a=!\u0011\u001dQ\u0006A1A\u0005\u0002)\u000bQ\u0002]1si&$\u0018n\u001c8`S\u0012D\bB\u0002/\u0001A\u0003%Q)\u0001\bqCJ$\u0018\u000e^5p]~KG\r\u001f\u0011\t\u000fy\u0003!\u0019!C\u0001\u0015\u0006AA-\u0019;f?&$\u0007\u0010\u0003\u0004a\u0001\u0001\u0006I!R\u0001\nI\u0006$XmX5eq\u0002BqA\u0019\u0001C\u0002\u0013\u0005!*\u0001\u0005uS6,w,\u001b3y\u0011\u0019!\u0007\u0001)A\u0005\u000b\u0006IA/[7f?&$\u0007\u0010\t\u0005\bM\u0002\u0011\r\u0011\"\u0001K\u00035!\u0018.\\3ti\u0006l\u0007oX5eq\"1\u0001\u000e\u0001Q\u0001\n\u0015\u000ba\u0002^5nKN$\u0018-\u001c9`S\u0012D\b\u0005C\u0004k\u0001\t\u0007I\u0011A6\u0002\u0017QL\b/\u001a$bGR|'/_\u000b\u0002YB\u0011Qn\\\u0007\u0002]*\u00111HB\u0005\u0003a:\u0014\u0001C\u00127j].$\u0016\u0010]3GC\u000e$xN]=\t\rI\u0004\u0001\u0015!\u0003m\u00031!\u0018\u0010]3GC\u000e$xN]=!\u0011\u001d!\b\u00011A\u0005\u0002U\f!B]3y\u0005VLG\u000eZ3s+\u00051\bCA7x\u0013\tAhNA\bGY&t7NU3y\u0005VLG\u000eZ3s\u0011\u001dQ\b\u00011A\u0005\u0002m\faB]3y\u0005VLG\u000eZ3s?\u0012*\u0017\u000f\u0006\u0002}\u007fB\u00111#`\u0005\u0003}R\u0011A!\u00168ji\"9\u0011)_A\u0001\u0002\u00041\bbBA\u0002\u0001\u0001\u0006KA^\u0001\fe\u0016D()^5mI\u0016\u0014\b\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001\u0002\n\u0005Y!/\u001a7ECR\fG+\u001f9f+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005UQBAA\b\u0015\r9\u0014\u0011\u0003\u0006\u0004\u0003'Q\u0014a\u0001:fY&!\u0011qCA\b\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u0017\tAB]3m\t\u0006$\u0018\rV=qK\u0002B\u0011\"a\b\u0001\u0005\u0004%\t!!\t\u0002\u00055\fXCAA\u0012!\ra\u0012QE\u0005\u0004\u0003O\u0011!!\u0006$mS:\\'+\u001a7NKR\fG-\u0019;b#V,'/\u001f\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002$\u0005\u0019Q.\u001d\u0011\t\u0017\u0005=\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011G\u0001\u0005g\u000e\fg.\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9D\u0003\u0003\u0002:\u0005E\u0011\u0001B2pe\u0016LA!!\u0010\u00028\tIA+\u00192mKN\u001b\u0017M\u001c\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0003\t\u0019%\u0001\u0005tG\u0006tw\fJ3r)\ra\u0018Q\t\u0005\n\u0003\u0006}\u0012\u0011!a\u0001\u0003gA1\"!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024\u0005)1oY1oA!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013!B:fiV\u0004H#\u0001?)\t\u0005-\u00131\u000b\t\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\b\u0002\u000b),h.\u001b;\n\t\u0005u\u0013q\u000b\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\u0005AQn\\2l'\u000e\fg\u000e\u0006\u0003\u00024\u0005\u0015\u0004BCA4\u0003?\u0002\n\u00111\u0001\u0002j\u0005I1\u000f^1uSN$\u0018n\u0019\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011q\u000e\u0003\u0002\u000bM$\u0018\r^:\n\t\u0005M\u0014Q\u000e\u0002\u000f\r2Lgn[*uCRL7\u000f^5d\u0011\u001d\t9\b\u0001C\u0005\u0003s\nAc\u0019:fCR,g*^7fe&\u001cG*\u001b;fe\u0006dG\u0003BA>\u0003\u000f\u0003B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003S\u0014a\u0001:fq&!\u0011QQA@\u0005)\u0011V\r\u001f'ji\u0016\u0014\u0018\r\u001c\u0005\t\u0003\u0013\u000b)\b1\u0001\u0002\f\u0006\u0019a.^7\u0011\u0007M\ti)C\u0002\u0002\u0010R\u0011A\u0001T8oO\"9\u0011q\u000f\u0001\u0005\n\u0005ME\u0003BA>\u0003+C\u0001\"!#\u0002\u0012\u0002\u0007\u0011q\u0013\t\u0004'\u0005e\u0015bAAN)\t1Ai\\;cY\u0016Dq!a(\u0001\t\u0013\t\t+\u0001\u000bde\u0016\fG/\u001a\"p_2,\u0017M\u001c'ji\u0016\u0014\u0018\r\u001c\u000b\u0005\u0003w\n\u0019\u000b\u0003\u0005\u0002&\u0006u\u0005\u0019AAT\u0003\u0005\u0011\u0007cA\n\u0002*&\u0019\u00111\u0016\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0016aE2sK\u0006$Xm\u0015;sS:<G*\u001b;fe\u0006dG\u0003BA>\u0003gC\u0001\"!.\u0002.\u0002\u0007\u0011qW\u0001\u0004gR\u0014\b\u0003BA]\u0003\u000ftA!a/\u0002DB\u0019\u0011Q\u0018\u000b\u000e\u0005\u0005}&bAAa!\u00051AH]8pizJ1!!2\u0015\u0003\u0019\u0001&/\u001a3fM&\u0019Q&!3\u000b\u0007\u0005\u0015G\u0003C\u0004\u0002N\u0002!I!a4\u0002#\r\u0014X-\u0019;f\t\u0006$X\rT5uKJ\fG\u000e\u0006\u0003\u0002|\u0005E\u0007\u0002CA[\u0003\u0017\u0004\r!a.\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006\t2M]3bi\u0016$\u0016.\\3MSR,'/\u00197\u0015\t\u0005m\u0014\u0011\u001c\u0005\t\u0003k\u000b\u0019\u000e1\u0001\u00028\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0017AF2sK\u0006$X\rV5nKN#\u0018-\u001c9MSR,'/\u00197\u0015\t\u0005m\u0014\u0011\u001d\u0005\t\u0003G\fY\u000e1\u0001\u0002\f\u00061Q.\u001b7mSNDq!a:\u0001\t\u0013\tI/\u0001\bde\u0016\fG/Z%oaV$(+\u001a4\u0015\t\u0005-\u0018\u0011\u001f\t\u0005\u0003{\ni/\u0003\u0003\u0002p\u0006}$a\u0003*fq&s\u0007/\u001e;SK\u001aDq!a=\u0002f\u0002\u0007Q)A\u0003j]\u0012,\u0007\u0010C\u0004\u0002x\u0002!I!!?\u0002;\r\u0014X-\u0019;f\u0013:\u0004X\u000f\u001e*fM^KG\u000f\u001b(vY2\f'-\u001b7jif$b!a;\u0002|\u0006u\bbBAz\u0003k\u0004\r!\u0012\u0005\t\u0003\u007f\f)\u00101\u0001\u0002(\u0006Q\u0011n\u001d(vY2\f'\r\\3\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006\u0005Q1M]3bi\u0016\u001c\u0015\r\u001c7\u0015\r\t\u001d!Q\u0002B\r!\u0011\tiH!\u0003\n\t\t-\u0011q\u0010\u0002\b%\u0016Dhj\u001c3f\u0011!\u0011yA!\u0001A\u0002\tE\u0011\u0001C8qKJ\fGo\u001c:\u0011\t\tM!QC\u0007\u0002q%\u0019!q\u0003\u001d\u0003\u0017M\u000bHn\u00149fe\u0006$xN\u001d\u0005\t\u00057\u0011\t\u00011\u0001\u0003\u001e\u0005)Q\r\u001f9sgB)1Ca\b\u0003\b%\u0019!\u0011\u0005\u000b\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0004\u0003&\u0001!IAa\n\u0002\u0015\r\u0014X-\u0019;f\u0007\u0006\u001cH\u000f\u0006\u0003\u0003\b\t%\u0002\u0002\u0003B\u0016\u0005G\u0001\rAa\u0002\u0002\t\u0015D\bO\u001d\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0003E\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u000b\u000f\u0005g\u0011yDa\u001b\u0003p\tm$q\u0011BV!\u0011\u0011)Da\u000f\u000e\u0005\t]\"\u0002BA8\u0005sQ!!\u0002\u0005\n\t\tu\"q\u0007\u0002\f\u0007>dW/\u001c8Ti\u0006$8\u000f\u0003\u0006\u0003B\t5\u0002\u0013!a\u0001\u0005\u0007\n1A\u001c3w!\u0015\u0019\"Q\tB%\u0013\r\u00119\u0005\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\t-#Q\r\b\u0005\u0005\u001b\u0012\tG\u0004\u0003\u0003P\t}c\u0002\u0002B)\u0005;rAAa\u0015\u0003\\9!!Q\u000bB-\u001d\u0011\tiLa\u0016\n\u0003=I!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0003d\u0019\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003h\t%$!\u0002&M_:<'b\u0001B2\r!Q!Q\u000eB\u0017!\u0003\u0005\rAa\u0011\u0002\u00139,H\u000e\\\"pk:$\bB\u0003B9\u0005[\u0001\n\u00111\u0001\u0003t\u00051\u0011M^4MK:\u0004Ra\u0005B#\u0005k\u0002BAa\u0013\u0003x%!!\u0011\u0010B5\u0005\u001dQEi\\;cY\u0016D!B! \u0003.A\u0005\t\u0019\u0001B@\u0003\u0019i\u0017\r\u001f'f]B)1C!\u0012\u0003\u0002B\u0019qEa!\n\u0007\t\u0015\u0005FA\u0004J]R,w-\u001a:\t\u0015\t%%Q\u0006I\u0001\u0002\u0004\u0011Y)A\u0002nS:\u0004Ra\u0005B#\u0005\u001b\u0003DAa$\u0003\u001aB)qE!%\u0003\u0016&\u0019!1\u0013\u0015\u0003\u0015\r{W\u000e]1sC\ndW\r\u0005\u0003\u0003\u0018\neE\u0002\u0001\u0003\r\u00057\u00139)!A\u0001\u0002\u000b\u0005!Q\u0014\u0002\u0004?\u0012\n\u0014\u0003\u0002BP\u0005K\u00032a\u0005BQ\u0013\r\u0011\u0019\u000b\u0006\u0002\b\u001d>$\b.\u001b8h!\r\u0019\"qU\u0005\u0004\u0005S#\"aA!os\"Q!Q\u0016B\u0017!\u0003\u0005\rAa,\u0002\u00075\f\u0007\u0010E\u0003\u0014\u0005\u000b\u0012\t\f\r\u0003\u00034\n]\u0006#B\u0014\u0003\u0012\nU\u0006\u0003\u0002BL\u0005o#AB!/\u0003,\u0006\u0005\t\u0011!B\u0001\u0005;\u00131a\u0018\u00133\u0011\u001d\u0011i\f\u0001C\u0005\u0005\u007f\u000bAc\u0019:fCR,g\t\\5oWN#\u0018\r^5ti&\u001cGCBA5\u0005\u0003\u0014)\r\u0003\u0006\u0003D\nm\u0006\u0013!a\u0001\u0005\u0007\n\u0001B]8x\u0007>,h\u000e\u001e\u0005\u000b\u0005\u000f\u0014Y\f%AA\u0002\t%\u0017\u0001C2pYN#\u0018\r^:\u0011\u000bM\u0011)Ea3\u0011\u0011\u0005e&QZA\\\u0005gIAAa4\u0002J\n\u0019Q*\u00199\t\u000f\tM\u0007\u0001\"\u0001\u0002P\u0005\u0011C/Z:u\u000bF,\u0018\r\\:XSRDG*\u001b;fe\u0006dwJ\u001a(v[\u0016\u0014\u0018n\u0019+za\u0016DCA!5\u0003XB!\u0011Q\u000bBm\u0013\u0011\u0011Y.a\u0016\u0003\tQ+7\u000f\u001e\u0005\b\u0005?\u0004A\u0011AA(\u0003\u0005\"Xm\u001d;FcV\fGn],ji\"d\u0015\u000e^3sC2|em\u0015;sS:<G+\u001f9fQ\u0011\u0011iNa6\t\u000f\t\u0015\b\u0001\"\u0001\u0002P\u0005\u0011C/Z:u\u000bF,\u0018\r\\:XSRDG*\u001b;fe\u0006dwJ\u001a\"p_2,\u0017M\u001c+za\u0016DCAa9\u0003X\"9!1\u001e\u0001\u0005\u0002\u0005=\u0013a\b;fgR,\u0015/^1mg^KG\u000f\u001b'ji\u0016\u0014\u0018\r\\(g\t\u0006$X\rV=qK\"\"!\u0011\u001eBl\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003\u001f\nq\u0004^3ti\u0016\u000bX/\u00197t/&$\b\u000eT5uKJ\fGn\u00144US6,G+\u001f9fQ\u0011\u0011yOa6\t\u000f\t]\b\u0001\"\u0001\u0002P\u0005!C/Z:u\u000bF,\u0018\r\\:XSRDG*\u001b;fe\u0006dwJ\u001a+j[\u0016\u001cH/Y7q)f\u0004X\r\u000b\u0003\u0003v\n]\u0007b\u0002B\u007f\u0001\u0011\u0005\u0011qJ\u0001\u0019i\u0016\u001cH/R9vC2\u001cx+\u001b;i_V$H*\u001b;fe\u0006d\u0007\u0006\u0002B~\u0005/Dqaa\u0001\u0001\t\u0003\ty%\u0001\ruKN$hj\u001c;FcV\fGn],ji\"d\u0015\u000e^3sC2DCa!\u0001\u0003X\"91\u0011\u0002\u0001\u0005\u0002\u0005=\u0013!\n;fgR\u001cu.\u001c9be&\u001cxN\\,ji\"d\u0015\u000e^3sC2|em\u0015;sS:<G+\u001f9fQ\u0011\u00199Aa6\t\u000f\r=\u0001\u0001\"\u0001\u0002P\u0005QB/Z:u\u000fJ,\u0017\r^3s)\"\fgnV5uQ2KG/\u001a:bY\"\"1Q\u0002Bl\u0011\u001d\u0019)\u0002\u0001C\u0001\u0003\u001f\nQ\u0004^3ti\u001e\u0013X-\u0019;feRC\u0017M\\,ji\"|W\u000f\u001e'ji\u0016\u0014\u0018\r\u001c\u0015\u0005\u0007'\u00119\u000eC\u0004\u0004\u001c\u0001!\t!a\u0014\u0002IQ,7\u000f^$sK\u0006$XM\u001d+iC:|%/R9vC2\u001cHk\\,ji\"d\u0015\u000e^3sC2DCa!\u0007\u0003X\"91\u0011\u0005\u0001\u0005\u0002\u0005=\u0013a\n;fgR<%/Z1uKJ$\u0006.\u00198Pe\u0016\u000bX/\u00197t)><\u0016\u000e\u001e5pkRd\u0015\u000e^3sC2DCaa\b\u0003X\"91q\u0005\u0001\u0005\u0002\u0005=\u0013a\u0006;fgRdUm]:UQ\u0006tw+\u001b;i\u0019&$XM]1mQ\u0011\u0019)Ca6\t\u000f\r5\u0002\u0001\"\u0001\u0002P\u0005QB/Z:u\u0019\u0016\u001c8\u000f\u00165b]^KG\u000f[8vi2KG/\u001a:bY\"\"11\u0006Bl\u0011\u001d\u0019\u0019\u0004\u0001C\u0001\u0003\u001f\n\u0011\u0005^3ti2+7o\u001d+iC:|%/R9vC2\u001cHk\\,ji\"d\u0015\u000e^3sC2DCa!\r\u0003X\"91\u0011\b\u0001\u0005\u0002\u0005=\u0013\u0001\n;fgRdUm]:UQ\u0006twJ]#rk\u0006d7\u000fV8XSRDw.\u001e;MSR,'/\u00197)\t\r]\"q\u001b\u0005\b\u0007\u007f\u0001A\u0011AA(\u0003!!Xm\u001d;MS.,\u0007\u0006BB\u001f\u0005/Dqa!\u0012\u0001\t\u0003\ty%\u0001\u0006uKN$\u0018j\u001d(vY2DCaa\u0011\u0003X\"911\n\u0001\u0005\u0002\u0005=\u0013!\u0004;fgRL5OT8u\u001dVdG\u000e\u000b\u0003\u0004J\t]\u0007bBB)\u0001\u0011\u0005\u0011qJ\u0001\u0007i\u0016\u001cH/\u00138)\t\r=#q\u001b\u0005\b\u0007/\u0002A\u0011AA(\u0003\u001d!Xm\u001d;B]\u0012DCa!\u0016\u0003X\"91Q\f\u0001\u0005\u0002\u0005=\u0013A\u0002;fgR|%\u000f\u000b\u0003\u0004\\\t]\u0007bBB2\u0001\u0011\u0005\u0011qJ\u0001\bi\u0016\u001cHOT8uQ\u0011\u0019\tGa6\t\u000f\r%\u0004\u0001\"\u0001\u0002P\u0005aA/Z:u\u0003:$wJ\u001d(pi\"\"1q\rBl\u0011\u001d\u0019y\u0007\u0001C\u0001\u0003\u001f\nA\u0003^3tiB\u0013X\rZ5dCR,w+\u001b;i+\u00124\u0007\u0006BB7\u0005/Dqa!\u001e\u0001\t\u0003\ty%A\u0012uKN$8+\u001a7fGRLg/\u001b;z/&$\bnU1nKJ+\u00070\u00138qkR\u0014VMZ:)\t\rM$q\u001b\u0005\b\u0007w\u0002A\u0011AA(\u0003A\"Xm\u001d;TK2,7\r^5wSRLx+\u001b;i'\u0006lWMU3y\u0013:\u0004X\u000f\u001e*fMN\fe\u000eZ*ue&tw\rV=qK\"\"1\u0011\u0010Bl\u0011%\u0019\t\tAI\u0001\n\u0013\u0019\u0019)\u0001\nn_\u000e\\7kY1oI\u0011,g-Y;mi\u0012\nTCABCU\u0011\tIga\",\u0005\r%\u0005\u0003BBF\u0007+k!a!$\u000b\t\r=5\u0011S\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa%\u0015\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007/\u001biIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba'\u0001#\u0003%Ia!(\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019yJ\u000b\u0003\u0003D\r\u001d\u0005\"CBR\u0001E\u0005I\u0011BBO\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I1q\u0015\u0001\u0012\u0002\u0013%1\u0011V\u0001\u001cGJ,\u0017\r^3D_2,XN\\*uCR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r-&\u0006\u0002B:\u0007\u000fC\u0011ba,\u0001#\u0003%Ia!-\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019L\u000b\u0003\u0003\u0000\r\u001d\u0005\"CB\\\u0001E\u0005I\u0011BB]\u0003m\u0019'/Z1uK\u000e{G.^7o'R\fGo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\u0018\u0016\u0005\u0007{\u001b9\tE\u0003\u0014\u0005\u000b\u001ay\f\r\u0003\u0004B\u000e\u0015\u0007#B\u0014\u0003\u0012\u000e\r\u0007\u0003\u0002BL\u0007\u000b$ABa'\u00046\u0006\u0005\t\u0011!B\u0001\u0005;C\u0011b!3\u0001#\u0003%Iaa3\u00027\r\u0014X-\u0019;f\u0007>dW/\u001c8Ti\u0006$8\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019iM\u000b\u0003\u0004P\u000e\u001d\u0005#B\n\u0003F\rE\u0007\u0007BBj\u0007/\u0004Ra\nBI\u0007+\u0004BAa&\u0004X\u0012a!\u0011XBd\u0003\u0003\u0005\tQ!\u0001\u0003\u001e\"I11\u001c\u0001\u0012\u0002\u0013%1QT\u0001\u001fGJ,\u0017\r^3GY&t7n\u0015;bi&\u001cH/[2%I\u00164\u0017-\u001e7uIEB\u0011ba8\u0001#\u0003%Ia!9\u0002=\r\u0014X-\u0019;f\r2Lgn[*uCRL7\u000f^5dI\u0011,g-Y;mi\u0012\u0012TCABrU\u0011\u0011Ima\"\b\u000f\r\u001d(\u0001#\u0001\u0004j\u0006A2+\u001a7fGRLg/\u001b;z\u000bN$\u0018.\\1u_J$Vm\u001d;\u0011\u0007q\u0019YO\u0002\u0004\u0002\u0005!\u00051Q^\n\u0004\u0007W\u0014\u0002bB\r\u0004l\u0012\u00051\u0011\u001f\u000b\u0003\u0007SD\u0001b!>\u0004l\u0012\u0005\u0011qJ\u0001\nE\u00164wN]3BY2DCaa=\u0004zB!\u0011QKB~\u0013\u0011\u0019i0a\u0016\u0003\u0017\t+gm\u001c:f\u00072\f7o\u001d")
public class SelectivityEstimatorTest {
    private final Seq<String> allFieldNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "amount", "price", "flag", "partition", "date_col", "time_col", "timestamp_col"}));
    private final Seq<SqlTypeName> allFieldTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.BOOLEAN, SqlTypeName.VARCHAR, SqlTypeName.DATE, SqlTypeName.TIME, SqlTypeName.TIMESTAMP}));
    private final /* synthetic */ Tuple8 x$1;
    private final int name_idx;
    private final int amount_idx;
    private final int price_idx;
    private final int flag_idx;
    private final int partition_idx;
    private final int date_idx;
    private final int time_idx;
    private final int timestamp_idx;
    private final FlinkTypeFactory typeFactory;
    private FlinkRexBuilder rexBuilder;
    private final RelDataType relDataType;
    private final FlinkRelMetadataQuery mq;
    private TableScan scan;

    @BeforeClass
    public static void beforeAll() {
        SelectivityEstimatorTest$.MODULE$.beforeAll();
    }

    private Seq<String> allFieldNames() {
        return this.allFieldNames;
    }

    private Seq<SqlTypeName> allFieldTypes() {
        return this.allFieldTypes;
    }

    public int name_idx() {
        return this.name_idx;
    }

    public int amount_idx() {
        return this.amount_idx;
    }

    public int price_idx() {
        return this.price_idx;
    }

    public int flag_idx() {
        return this.flag_idx;
    }

    public int partition_idx() {
        return this.partition_idx;
    }

    public int date_idx() {
        return this.date_idx;
    }

    public int time_idx() {
        return this.time_idx;
    }

    public int timestamp_idx() {
        return this.timestamp_idx;
    }

    public FlinkTypeFactory typeFactory() {
        return this.typeFactory;
    }

    public FlinkRexBuilder rexBuilder() {
        return this.rexBuilder;
    }

    public void rexBuilder_$eq(FlinkRexBuilder x$1) {
        this.rexBuilder = x$1;
    }

    public RelDataType relDataType() {
        return this.relDataType;
    }

    public FlinkRelMetadataQuery mq() {
        return this.mq;
    }

    public TableScan scan() {
        return this.scan;
    }

    public void scan_$eq(TableScan x$1) {
        this.scan = x$1;
    }

    @Before
    public void setup() {
        this.scan_$eq(this.mockScan(this.mockScan$default$1()));
    }

    private TableScan mockScan(FlinkStatistic statistic) {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)true, (boolean)false).plus();
        MockMetaTable table = new MockMetaTable(this.relDataType(), statistic);
        rootSchema.add("test", (Table)table);
        PlannerContext plannerContext = PlannerMocks.newBuilder().withRootSchema(CalciteSchema.from((SchemaPlus)rootSchema)).build().getPlannerContext();
        FlinkRelBuilder relBuilder = plannerContext.createRelBuilder();
        relBuilder.clear();
        return (TableScan)relBuilder.scan(Arrays.asList((Object[])new String[]{"test"})).build();
    }

    private FlinkStatistic mockScan$default$1() {
        return FlinkStatistic$.MODULE$.UNKNOWN();
    }

    private RexLiteral createNumericLiteral(long num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createNumericLiteral(double num) {
        return this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(num));
    }

    private RexLiteral createBooleanLiteral(boolean b) {
        return this.rexBuilder().makeLiteral(b);
    }

    private RexLiteral createStringLiteral(String str) {
        return this.rexBuilder().makeLiteral(str);
    }

    private RexLiteral createDateLiteral(String str) {
        return this.rexBuilder().makeDateLiteral(new DateString(str));
    }

    private RexLiteral createTimeLiteral(String str) {
        return this.rexBuilder().makeTimeLiteral(new TimeString(str), 0);
    }

    private RexLiteral createTimeStampLiteral(long millis) {
        return this.rexBuilder().makeTimestampLiteral(TimestampString.fromMillisSinceEpoch((long)millis), 0);
    }

    private RexInputRef createInputRef(int index) {
        return this.createInputRefWithNullability(index, false);
    }

    private RexInputRef createInputRefWithNullability(int index, boolean isNullable) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(index));
        RelDataType relDataTypeWithNullability = this.typeFactory().createTypeWithNullability(relDataType, isNullable);
        return this.rexBuilder().makeInputRef(relDataTypeWithNullability, index);
    }

    private RexNode createCall(SqlOperator operator, Seq<RexNode> exprs) {
        Preconditions.checkArgument((boolean)exprs.nonEmpty());
        return this.rexBuilder().makeCall(operator, (RexNode[])exprs.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    private RexNode createCast(RexNode expr) {
        RelDataType relDataType = this.typeFactory().createSqlType((SqlTypeName)this.allFieldTypes().apply(1));
        return this.rexBuilder().makeCast(relDataType, expr);
    }

    private ColumnStats createColumnStats(Option<Long> ndv, Option<Long> nullCount, Option<Double> avgLen, Option<Integer> maxLen, Option<Comparable<?>> min, Option<Comparable<?>> max) {
        return ColumnStats.Builder.builder().setNdv((Long)ndv.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setNullCount((Long)nullCount.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setAvgLen((Double)avgLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMaxLen((Integer)maxLen.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setMax((Comparable)max.orNull(Predef$.MODULE$.$conforms())).setMin((Comparable)min.orNull(Predef$.MODULE$.$conforms())).build();
    }

    private Option<Long> createColumnStats$default$1() {
        return None$.MODULE$;
    }

    private Option<Long> createColumnStats$default$2() {
        return None$.MODULE$;
    }

    private Option<Double> createColumnStats$default$3() {
        return None$.MODULE$;
    }

    private Option<Integer> createColumnStats$default$4() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$5() {
        return None$.MODULE$;
    }

    private Option<Comparable<?>> createColumnStats$default$6() {
        return None$.MODULE$;
    }

    private FlinkStatistic createFlinkStatistic(Option<Long> rowCount, Option<scala.collection.immutable.Map<String, ColumnStats>> colStats) {
        Predef$.MODULE$.require(rowCount.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "rowCount requires not null now");
        TableStats tableStats = colStats.isDefined() ? new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)colStats.get()).asJava()) : new TableStats(Predef$.MODULE$.Long2long((Long)rowCount.get()), null);
        return FlinkStatistic$.MODULE$.builder().tableStats(tableStats).build();
    }

    private Option<Long> createFlinkStatistic$default$1() {
        return None$.MODULE$;
    }

    private Option<scala.collection.immutable.Map<String, ColumnStats>> createFlinkStatistic$default$2() {
        return None$.MODULE$;
    }

    @Test
    public void testEqualsWithLiteralOfNumericType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assert.assertEquals((Object)estimator3.defaultEqualsSelectivity(), (Object)estimator3.evaluate(predicate1));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator4.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator5 = new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq());
        Assert.assertEquals((Object)estimator5.defaultEqualsSelectivity(), (Object)estimator5.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator5.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.00125)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("xyz")}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfBooleanType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(true)}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate2));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate3));
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate4));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flag"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(2L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(1.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(false)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.boolean2Boolean(true))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.flag_idx()), this.createBooleanLiteral(false)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.5)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testEqualsWithLiteralOfDateType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2017-10-11")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Date.valueOf("2017-10-01")), (Option<Comparable<?>>)new Some((Object)Date.valueOf("2018-10-01"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.date_idx()), this.createDateLiteral("2018-10-02")}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimeType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("11:00:00")}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Time.valueOf("10:00:00")), (Option<Comparable<?>>)new Some((Object)Time.valueOf("12:00:00"))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.time_idx()), this.createTimeLiteral("13:00:00")}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithLiteralOfTimestampType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(1000L)}));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp_col"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)None$.MODULE$, (Option<Integer>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)new Timestamp(0L)), (Option<Comparable<?>>)new Some((Object)new Timestamp(2000L))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0125)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.timestamp_idx()), this.createTimeStampLiteral(3000L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator.evaluate(predicate2));
    }

    @Test
    public void testEqualsWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)estimator1.defaultEqualsSelectivity(), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
    }

    @Test
    public void testNotEqualsWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get())))), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9875)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate2));
    }

    @Test
    public void testComparisonWithLiteralOfStringType() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        Assert.assertEquals((Object)estimator2.defaultComparisonSelectivity(), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testGreaterThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(5L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator3 = new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator3.evaluate(predicate2));
        Assert.assertEquals((Object)estimator3.defaultComparisonSelectivity(), (Object)estimator3.evaluate(predicate3));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator4 = new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator4.evaluate(predicate2));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator4.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator4.evaluate(predicate1));
    }

    @Test
    public void testGreaterThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(11)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate));
    }

    @Test
    public void testGreaterThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testGreaterThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(201L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.99)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(19)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLessThanOrEqualsToWithLiteral() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator1.defaultComparisonSelectivity(), (Object)estimator1.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(9L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)estimator2.evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(200L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator2.evaluate(predicate3));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.21052631578947367)), (Object)estimator2.evaluate(predicate1));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(10L)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.01)), (Object)estimator2.evaluate(predicate4));
        RexNode predicate5 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)estimator2.evaluate(predicate5));
    }

    @Test
    public void testLessThanOrEqualsToWithoutLiteral() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createInputRef(this.price_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(9))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(1)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(20)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(80))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate));
    }

    @Test
    public void testLike() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.LIKE, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("ross")}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator.defaultLikeSelectivity(), (Object)estimator.evaluate(predicate));
    }

    @Test
    public void testIsNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)estimator.defaultIsNullSelectivity(), (Object)estimator.evaluate(predicate));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate));
    }

    @Test
    public void testIsNotNull() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx())}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)estimator.evaluate(predicate));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRefWithNullability(this.name_idx(), true)}));
        Assert.assertEquals((Object)estimator.defaultIsNotNullSelectivity(), (Object)estimator.evaluate(predicate2));
        ColumnStats colStats = this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(10L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$);
        FlinkStatistic statistic1 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)colStats)}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.9)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic1), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testIn() {
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        RexNode predicate1 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.name_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createStringLiteral("abc"), this.createStringLiteral("def")}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)2))), (Object)estimator.evaluate(predicate1));
        RexNode predicate2 = this.rexBuilder().makeIn((RexNode)this.createInputRef(this.amount_idx()), Arrays.asList((Object[])new RexLiteral[]{this.createNumericLiteral(10.0), this.createNumericLiteral(20.0), this.createNumericLiteral(30.0), this.createNumericLiteral(40.0)}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic2 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic2), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic3 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(15)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0375)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic3), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic4 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(50)), (Option<Comparable<?>>)None$.MODULE$))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic4), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic5 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)estimator.defaultEqualsSelectivity().get()) * (double)4))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic5), this.mq()).evaluate(predicate2));
        FlinkStatistic statistic6 = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(40L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)None$.MODULE$, (Option<Comparable<?>>)None$.MODULE$))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.1)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic6), this.mq()).evaluate(predicate2));
    }

    @Test
    public void testAnd() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05263157894736842)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testOr() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(6.5)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * (double)2 - selectivity * selectivity))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        double leftSelectivity = 0.21052631578947367;
        double rightSelectivity = 0.25;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(leftSelectivity + rightSelectivity - leftSelectivity * rightSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)}))}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.025)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(70L)}))}));
        double inSelectivity = 0.025;
        double greaterThan70Selectivity = 0.6842105263157895;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity + greaterThan70Selectivity - inSelectivity * greaterThan70Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        double lessThan50Selectivity = 0.21052631578947367;
        double greaterThan80Selectivity = 0.631578947368421;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(lessThan50Selectivity + greaterThan80Selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(50L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(60L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createNumericLiteral(70L), this.createInputRef(this.amount_idx())})), this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(3L)}))}));
        double inSelectivity1 = 0.025;
        double lessThan70Selectivity = 0.6842105263157895;
        double priceSelectivity = 0.18666666666666665;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(inSelectivity1 + lessThan70Selectivity + priceSelectivity - inSelectivity1 * lessThan70Selectivity * priceSelectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get())))), (Object)estimator.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.7894736842105263)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate));
    }

    @Test
    public void testAndOrNot() {
        RexNode predicate = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(50L)})), this.createCall((SqlOperator)SqlStdOperatorTable.OR, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.EQUALS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.NOT, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)}))}))}))}));
        SelectivityEstimator estimator1 = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double accountSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double nameSelectivity1 = BoxesRunTime.unboxToDouble((Object)estimator1.defaultEqualsSelectivity().get());
        double notPriceSelectivity1 = 1.0 - BoxesRunTime.unboxToDouble((Object)estimator1.defaultComparisonSelectivity().get());
        double selectivity1 = accountSelectivity1 * (nameSelectivity1 + notPriceSelectivity1 - nameSelectivity1 * notPriceSelectivity1);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity1)), (Object)estimator1.evaluate(predicate));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        SelectivityEstimator estimator2 = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        double accountSelectivity2 = 0.21052631578947367;
        double nameSelectivity2 = BoxesRunTime.unboxToDouble((Object)estimator2.defaultEqualsSelectivity().get());
        double notPriceSelectivity2 = 0.5833333333333334;
        double selectivity2 = accountSelectivity2 * (nameSelectivity2 + notPriceSelectivity2 - nameSelectivity2 * notPriceSelectivity2);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)selectivity2)), (Object)estimator2.evaluate(predicate));
    }

    @Test
    public void testPredicateWithUdf() {
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(10)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(200))))}))));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq());
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.ABS, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx())})), this.createNumericLiteral(50L)}));
        Assert.assertEquals((Object)estimator.defaultComparisonSelectivity(), (Object)estimator.evaluate(predicate1));
    }

    @Test
    public void testSelectivityWithSameRexInputRefs() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)}))}));
        RexNode predicate2 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(5L)}))}));
        RexNode predicate3 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(45L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(40L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.price_idx()), this.createNumericLiteral(4.5)})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCast((RexNode)this.createInputRef(this.price_idx())), this.createNumericLiteral(5L)}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity * selectivity * selectivity))), (Object)estimator.evaluate(predicate2));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(100L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"amount"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(80L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(0)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(100)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"price"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(50L)), (Option<Long>)None$.MODULE$, (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(8.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(8)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(2)), (Option<Comparable<?>>)new Some((Object)Predef$.MODULE$.int2Integer(8))))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.05)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.004166666666666667)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate2));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(0.02916666666666667 * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate3));
        RexNode predicate4 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(120L)})), this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.amount_idx()), this.createNumericLiteral(80L)}))}));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)0.2)), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate4));
    }

    @Test
    public void testSelectivityWithSameRexInputRefsAndStringType() {
        RexNode predicate1 = this.createCall((SqlOperator)SqlStdOperatorTable.AND, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("abc")})), this.createCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.createInputRef(this.name_idx()), this.createStringLiteral("test")}))}));
        SelectivityEstimator estimator = new SelectivityEstimator((RelNode)this.scan(), this.mq());
        double selectivity = BoxesRunTime.unboxToDouble((Object)estimator.defaultComparisonSelectivity().get());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)estimator.evaluate(predicate1));
        FlinkStatistic statistic = this.createFlinkStatistic((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(1000L)), (Option<scala.collection.immutable.Map<String, ColumnStats>>)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.createColumnStats((Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(800L)), (Option<Long>)new Some((Object)Predef$.MODULE$.long2Long(0L)), (Option<Double>)new Some((Object)Predef$.MODULE$.double2Double(16.0)), (Option<Integer>)new Some((Object)Predef$.MODULE$.int2Integer(32)), (Option<Comparable<?>>)new Some((Object)"aaa"), (Option<Comparable<?>>)new Some((Object)"max")))}))));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToDouble((double)(selectivity * selectivity))), (Object)new SelectivityEstimator((RelNode)this.mockScan(statistic), this.mq()).evaluate(predicate1));
    }

    public SelectivityEstimatorTest() {
        Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7));
        if (tuple8 == null) {
            throw new MatchError((Object)tuple8);
        }
        int name_idx = BoxesRunTime.unboxToInt((Object)tuple8._1());
        int amount_idx = BoxesRunTime.unboxToInt((Object)tuple8._2());
        int price_idx = BoxesRunTime.unboxToInt((Object)tuple8._3());
        int flag_idx = BoxesRunTime.unboxToInt((Object)tuple8._4());
        int partition_idx = BoxesRunTime.unboxToInt((Object)tuple8._5());
        int date_idx = BoxesRunTime.unboxToInt((Object)tuple8._6());
        int time_idx = BoxesRunTime.unboxToInt((Object)tuple8._7());
        int timestamp_idx = BoxesRunTime.unboxToInt((Object)tuple8._8());
        Tuple8 tuple82 = new Tuple8((Object)BoxesRunTime.boxToInteger((int)name_idx), (Object)BoxesRunTime.boxToInteger((int)amount_idx), (Object)BoxesRunTime.boxToInteger((int)price_idx), (Object)BoxesRunTime.boxToInteger((int)flag_idx), (Object)BoxesRunTime.boxToInteger((int)partition_idx), (Object)BoxesRunTime.boxToInteger((int)date_idx), (Object)BoxesRunTime.boxToInteger((int)time_idx), (Object)BoxesRunTime.boxToInteger((int)timestamp_idx));
        this.x$1 = tuple82;
        this.name_idx = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.amount_idx = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.price_idx = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.flag_idx = BoxesRunTime.unboxToInt((Object)this.x$1._4());
        this.partition_idx = BoxesRunTime.unboxToInt((Object)this.x$1._5());
        this.date_idx = BoxesRunTime.unboxToInt((Object)this.x$1._6());
        this.time_idx = BoxesRunTime.unboxToInt((Object)this.x$1._7());
        this.timestamp_idx = BoxesRunTime.unboxToInt((Object)this.x$1._8());
        this.typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), FlinkTypeFactory$.MODULE$.$lessinit$greater$default$2());
        this.rexBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        this.relDataType = this.typeFactory().createStructType((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.allFieldTypes().map((Function1 & Serializable & scala.Serializable)typeName -> this.typeFactory().createSqlType(typeName), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.allFieldNames()).asJava());
        this.mq = FlinkRelMetadataQuery.instance();
    }
}

