/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeTestUtil;
import org.apache.flink.table.planner.plan.nodes.exec.spec.LookupJoinHintTestUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.runtime.operators.join.lookup.ResultRetryStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RetryLookupOptionsTest {
    @Test
    void testSerdeRetryLookupOptions() throws IOException {
        LookupJoinUtil.RetryLookupOptions retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.completeLookupHint);
        JsonSerdeTestUtil.testJsonRoundTrip(retryLookupOptions, LookupJoinUtil.RetryLookupOptions.class);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithAsync);
        JsonSerdeTestUtil.testJsonRoundTrip(retryLookupOptions, LookupJoinUtil.RetryLookupOptions.class);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithRetry);
        JsonSerdeTestUtil.testJsonRoundTrip(retryLookupOptions, LookupJoinUtil.RetryLookupOptions.class);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithTableOnly);
        JsonSerdeTestUtil.testJsonRoundTrip(retryLookupOptions, LookupJoinUtil.RetryLookupOptions.class);
    }

    @Test
    void testToRetryStrategy() {
        LookupJoinUtil.RetryLookupOptions retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.completeLookupHint);
        Assertions.assertTrue((retryLookupOptions.toRetryStrategy() != ResultRetryStrategy.NO_RETRY_STRATEGY ? 1 : 0) != 0);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithAsync);
        Assertions.assertTrue((retryLookupOptions == null ? 1 : 0) != 0);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithRetry);
        Assertions.assertTrue((retryLookupOptions.toRetryStrategy() != ResultRetryStrategy.NO_RETRY_STRATEGY ? 1 : 0) != 0);
        retryLookupOptions = LookupJoinUtil.RetryLookupOptions.fromJoinHint((RelHint)LookupJoinHintTestUtil.lookupHintWithTableOnly);
        Assertions.assertTrue((retryLookupOptions == null ? 1 : 0) != 0);
    }
}

