/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;

public class DeduplicationJsonPlanTest
extends TableTestBase {
    private StreamTableTestUtil util;
    private TableEnvironment tEnv;

    @Before
    public void setup() {
        this.util = this.streamTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
    }

    @Test
    public void testDeduplication() {
        String srcTableDdl = "CREATE TABLE srcValuesTable (\n  order_id bigint,\n  `user` varchar,\n  product varchar,\n  order_time timestamp(3),\n  proctime AS PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'false',  'disable-lookup' = 'true')";
        this.tEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE sink (\n  order_id bigint,\n  `user` varchar,\n  product varchar,\n  order_time timestamp(3)\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tEnv.executeSql(sinkTableDdl);
        this.util.verifyJsonPlan("insert into sink select order_id, user, product, order_time \nFROM (\n  SELECT *,\n    ROW_NUMBER() OVER (PARTITION BY product ORDER BY proctime ASC) AS row_num\n  FROM srcValuesTable)\nWHERE row_num = 1 \n");
    }
}

