/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.TimeZone;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.expressions.utils.Func1$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.planner.utils.IntSumAggFunction;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u0001E\u0011ACU3y\u001d>$W-\u0012=ue\u0006\u001cGo\u001c:UKN$(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!\u0001\u0003qY\u0006t'BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0010%\u0016Dhj\u001c3f)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001Aqa\u0007\u0001C\u0002\u0013\u0005A$A\u0006uC\ndWmQ8oM&<W#A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001B\u0011aA1qS&\u0011!e\b\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0004%\u0001\u0001\u0006I!H\u0001\ri\u0006\u0014G.Z\"p]\u001aLw\r\t\u0005\bM\u0001\u0011\r\u0011\"\u0001(\u0003=\u0011Xm]8ve\u000e,W*\u00198bO\u0016\u0014X#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-B\u0011\u0001\u0003:fg>,(oY3\n\u00055R#a\u0004*fg>,(oY3NC:\fw-\u001a:\t\r=\u0002\u0001\u0015!\u0003)\u0003A\u0011Xm]8ve\u000e,W*\u00198bO\u0016\u0014\b\u0005C\u00042\u0001\t\u0007I\u0011\u0001\u001a\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feV\t1\u0007\u0005\u00025o5\tQG\u0003\u00027\u0011\u000591-\u0019;bY><\u0017B\u0001\u001d6\u00059\u0019\u0015\r^1m_\u001el\u0015M\\1hKJDaA\u000f\u0001!\u0002\u0013\u0019\u0014aD2bi\u0006dwnZ'b]\u0006<WM\u001d\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005iQn\u001c3vY\u0016l\u0015M\\1hKJ,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\"\ta!\\8ek2,\u0017BA\"A\u00055iu\u000eZ;mK6\u000bg.Y4fe\"1Q\t\u0001Q\u0001\ny\na\"\\8ek2,W*\u00198bO\u0016\u0014\b\u0005C\u0004H\u0001\t\u0007I\u0011\u0002%\u0002\u001f\u0019,hn\u0019;j_:\u001c\u0015\r^1m_\u001e,\u0012!\u0013\t\u0003i)K!aS\u001b\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eDa!\u0014\u0001!\u0002\u0013I\u0015\u0001\u00054v]\u000e$\u0018n\u001c8DCR\fGn\\4!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003e!Xm\u001d;FqR\u0014\u0018m\u0019;SK\u001aLe\u000e];u\r&,G\u000eZ:\u0015\u0003E\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013A!\u00168ji\"\u0012a\n\u0017\t\u00033rk\u0011A\u0017\u0006\u00037:\tQA[;oSRL!!\u0018.\u0003\tQ+7\u000f\u001e\u0005\u0006?\u0002!\t\u0001U\u0001 i\u0016\u001cH/\u0012=ue\u0006\u001cGOU3g\u001d\u0016\u001cH/\u001a3J]B,HOR5fY\u0012\u001c\bF\u00010Y\u0011\u0015\u0011\u0007\u0001\"\u0001Q\u00031\"Xm\u001d;FqR\u0014\u0018m\u0019;SK\u001atUm\u001d;fI&s\u0007/\u001e;GS\u0016dGm],ji\"tuNT3ti&tw\r\u000b\u0002b1\")Q\r\u0001C\u0001!\u0006\u0019C/Z:u\u000bb$(/Y2u\t\u0016,\u0007OU3g\u001d\u0016\u001cH/\u001a3J]B,HOR5fY\u0012\u001c\bF\u00013Y\u0011\u0015A\u0007\u0001\"\u0001Q\u0003i!Xm\u001d;FqR\u0014\u0018m\u0019;TS6\u0004H.Z\"p]\u0012LG/[8oQ\t9\u0007\fC\u0003l\u0001\u0011\u0005\u0001+\u0001\u000euKN$X\t\u001f;sC\u000e$8+\u001b8hY\u0016\u001cuN\u001c3ji&|g\u000e\u000b\u0002k1\")a\u000e\u0001C\u0001!\u00069B/Z:u\u000bb$(/Y2u\u0007:47i\u001c8eSRLwN\u001c\u0015\u0003[bCQ!\u001d\u0001\u0005\u0002A\u000b\u0011\u0004^3ti\u0016CHO]1di\u0006sE)\u0012=qe\u0016\u001c8/[8og\"\u0012\u0001\u000f\u0017\u0005\u0006i\u0002!\t\u0001U\u0001\u001ei\u0016\u001cHOT;nKJL7\rT5uKJ\fGnQ8om\u0016\u00148/[8og\"\u00121\u000f\u0017\u0005\u0006o\u0002!\t\u0001U\u0001\u001bi\u0016\u001cH\u000fV5nK2KG/\u001a:bY\u000e{gN^3sg&|gn\u001d\u0015\u0003mbCQA\u001f\u0001\u0005\u0002A\u000bq\u0004^3ti\u0016CHO]1di\u0006\u0013\u0018\u000e\u001e5nKRL7mQ8oI&$\u0018n\u001c8tQ\tI\b\fC\u0003~\u0001\u0011\u0005\u0001+\u0001\u000fuKN$X\t\u001f;sC\u000e$\bk\\:uM&D8i\u001c8eSRLwN\\:)\u0005qD\u0006BBA\u0001\u0001\u0011\u0005\u0001+A\u0013uKN$X\t\u001f;sC\u000e$8i\u001c8eSRLwN\\,ji\"4UO\\2uS>t7)\u00197mg\"\u0012q\u0010\u0017\u0005\u0007\u0003\u000f\u0001A\u0011\u0001)\u0002'Q,7\u000f^#yiJ\f7\r^,ji\"\u001c\u0015m\u001d;)\u0007\u0005\u0015\u0001\f\u0003\u0004\u0002\u000e\u0001!\t\u0001U\u0001\u0014i\u0016\u001cH/\u0012=ue\u0006\u001cGoV5uQR\u0013\u0018.\u001c\u0015\u0004\u0003\u0017A\u0006BBA\n\u0001\u0011\u0005\u0001+\u0001\nuKN$X\t\u001f;sC\u000e$x+\u001b;i+\u00124\u0007fAA\t1\"1\u0011\u0011\u0004\u0001\u0005\u0002A\u000ba\u0004^3ti\u0016CHO]1diB\u000b'\u000f^5uS>t\u0007K]3eS\u000e\fG/Z:)\u0007\u0005]\u0001\f\u0003\u0004\u0002 \u0001!\t\u0001U\u0001#i\u0016\u001cH/\u0012=ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8Qe\u0016$\u0017nY1uKN$\u0015\r^3)\u0007\u0005u\u0001\f\u0003\u0004\u0002&\u0001!\t\u0001U\u0001,i\u0016\u001cH\u000fV5nK2KG/\u001a:bY^KG\u000f\u001b'pG\u0006dG+[7f5>tWmQ8om\u0016\u00148/[8og\"\u001a\u00111\u0005-\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005\tC/Z:u\u000bb$(/Y2u'&tw\r\\3Q_N$h-\u001b=D_:$\u0017\u000e^5p]R9\u0011+a\f\u0002D\u0005]\u0003\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u0015\u0019LW\r\u001c3J]\u0012,\u0007\u0010\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\tAA[1wC&!\u0011\u0011IA\u001c\u0005\u001dIe\u000e^3hKJD\u0001\"!\u0012\u0002*\u0001\u0007\u0011qI\u0001\u0003_B\u0004B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0002tc2T1!!\u0015\r\u0003\u001d\u0019\u0017\r\\2ji\u0016LA!!\u0016\u0002L\t\u00112+\u001d7Q_N$h-\u001b=Pa\u0016\u0014\u0018\r^8s\u0011!\tI&!\u000bA\u0002\u0005m\u0013\u0001B3yaJ\u0004B!!\u0018\u0002l9!\u0011qLA4!\r\t\tgU\u0007\u0003\u0003GR1!!\u001a\u0011\u0003\u0019a$o\\8u}%\u0019\u0011\u0011N*\u0002\rA\u0013X\rZ3g\u0013\u0011\ti'a\u001c\u0003\rM#(/\u001b8h\u0015\r\tIg\u0015\u0005\b\u0003g\u0002A\u0011BA;\u0003m\t7o]3si\u0016C\bO]3tg&|g.\u0011:sCf,\u0015/^1mgR)\u0011+a\u001e\u0002\u000e\"A\u0011\u0011PA9\u0001\u0004\tY(\u0001\u0005fqB,7\r^3e!\u0015\u0011\u0016QPAA\u0013\r\tyh\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011q\u0011\u0005\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003\u0017\u000b)I\u0001\u0006FqB\u0014Xm]:j_:D\u0001\"a$\u0002r\u0001\u0007\u00111P\u0001\u0007C\u000e$X/\u00197\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\u0006aR\r\u001f;sC\u000e$8i\u001c8kk:\u001cG/\u001b<f\u0007>tG-\u001b;j_:\u001cHCDAL\u0003W\u000bi+a.\u0002H\u0006E\u00171\u001b\t\b%\u0006e\u00151PAO\u0013\r\tYj\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000bI\u000bi(a(\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002P\u0005\u0019!/\u001a=\n\t\u0005%\u00161\u0015\u0002\b%\u0016Dhj\u001c3f\u0011!\tI&!%A\u0002\u0005}\u0005\u0002CAX\u0003#\u0003\r!!-\u0002\u001f5\f\u0007p\u00118g\u001d>$WmQ8v]R\u00042AUAZ\u0013\r\t)l\u0015\u0002\u0004\u0013:$\b\u0002CA]\u0003#\u0003\r!a/\u0002\u001f%t\u0007/\u001e;GS\u0016dGMT1nKN\u0004b!!0\u0002D\u0006mSBAA`\u0015\u0011\t\t-a\u000f\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\fyL\u0001\u0003MSN$\b\u0002CAe\u0003#\u0003\r!a3\u0002\u0015I,\u0007PQ;jY\u0012,'\u000f\u0005\u0003\u0002\"\u00065\u0017\u0002BAh\u0003G\u0013!BU3y\u0005VLG\u000eZ3s\u0011\u00191\u0014\u0011\u0013a\u0001\u0013\"Q\u0011Q[AI!\u0003\u0005\r!a6\u0002\u0005QT\b\u0003BA_\u00033LA!a7\u0002@\nAA+[7f5>tW\rC\u0005\u0002`\u0002\t\n\u0011\"\u0003\u0002b\u00061S\r\u001f;sC\u000e$8i\u001c8kk:\u001cG/\u001b<f\u0007>tG-\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\r(\u0006BAl\u0003K\\#!a:\u0011\t\u0005%\u00181_\u0007\u0003\u0003WTA!!<\u0002p\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c\u001c\u0016AC1o]>$\u0018\r^5p]&!\u0011Q_Av\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RexNodeExtractorTest
extends RexNodeTestBase {
    private final TableConfig tableConfig = TableConfig.getDefault();
    private final ResourceManager resourceManager = ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)this.tableConfig().getConfiguration());
    private final CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
    private final ModuleManager moduleManager = new ModuleManager();
    private final FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)this.tableConfig(), this.resourceManager(), this.catalogManager(), this.moduleManager());

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public ResourceManager resourceManager() {
        return this.resourceManager;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    public ModuleManager moduleManager() {
        return this.moduleManager;
    }

    private FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    @Test
    public void testExtractRefInputFields() {
        java.util.List exprs;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        Assert.assertArrayEquals((int[])usedFields, (int[])new int[]{2, 3, 1});
    }

    @Test
    public void testExtractRefNestedInputFields() {
        java.util.List rexProgram;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractRefNestedInputFieldsWithNoNesting() {
        java.util.List exprs;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = exprs = (java.util.List)tuple2._1();
        java.util.List exprs2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(exprs2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(exprs2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})})});
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractDeepRefNestedInputFields() {
        java.util.List rexProgram;
        Tuple2<java.util.List<RexNode>, RelDataType> tuple2 = this.buildExprsWithDeepNesting();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        java.util.List list = rexProgram = (java.util.List)tuple2._1();
        java.util.List rexProgram2 = list;
        int[] usedFields = RexNodeExtractor$.MODULE$.extractRefInputFields(rexProgram2);
        java.util.List[][] usedNestedFields = RexNodeExtractor$.MODULE$.extractRefNestedInputFields(rexProgram2, usedFields);
        java.util.List[][] expected = (java.util.List[][])((Object[])new java.util.List[][]{(java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"amount"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"*"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"with", "deeper", "entry"}), Arrays.asList((Object[])new String[]{"with", "deep", "entry"})}), (java.util.List[])((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"outer"}), Arrays.asList((Object[])new String[]{"inner", "deep_array"})})});
        Assert.assertThat((Object)usedFields, (Matcher)CoreMatchers.is((Object)new int[]{1, 0, 2, 3}));
        Assert.assertThat((Object)usedNestedFields, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void testExtractSimpleCondition() {
        FlinkRexBuilder builder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        RexNode expr = this.buildConditionExpr();
        Expression firstExp = package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(6));
        Expression secondExp = package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$))).$less(package$.MODULE$.int2Literal(100));
        Expression[] expected = (Expression[])((Object[])new Expression[]{firstExp, secondExp});
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(expr, -1, this.allFieldNames(), (RexBuilder)builder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractSingleCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(a, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractCnfCondition() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode e = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))).asJava());
        RexNode or = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)and, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)e, (List)Nil$.MODULE$)))).asJava());
        RexNode not = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)d, (List)Nil$.MODULE$)).asJava());
        RexNode complexNode = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)or, (List)new .colon.colon((Object)not, (List)Nil$.MODULE$))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexNode, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.int2Literal(100))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100)))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(200))), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100)))).$bar$bar(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(200))), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).unary_$bang()});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractANDExpressions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t3});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"price"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.int2Literal(100))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testNumericLiteralConversions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(3), 3);
        RexLiteral t3 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexLiteral t4 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(200.1));
        RexNode a = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t3});
        RexNode b = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t4});
        RexNode c = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t4});
        RexNode d = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)new .colon.colon((Object)c, (List)new .colon.colon((Object)d, (List)Nil$.MODULE$))))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount"), ApiExpressionUtils.unresolvedRef((String)"id")}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"id"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"price"), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToDouble((double)200.1))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testTimeLiteralConversions() {
        Expression[] converted;
        FlinkRexBuilder relBuilder;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"date_col", (List)new .colon.colon((Object)"time_col", (List)Nil$.MODULE$)))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.DATE, SqlTypeName.TIME}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 3);
        RexLiteral rexDate = this.rexBuilder().makeDateLiteral(new DateString("2017-09-12"));
        RexLiteral rexTime = this.rexBuilder().makeTimeLiteral(new TimeString("14:23:01"), 0);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexDate, (List)new .colon.colon((Object)rexTime, (List)Nil$.MODULE$)));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, fieldNames, (RexBuilder)(relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory())), this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] expressionArray = converted = (Expression[])tuple2._1();
        Expression[] converted2 = expressionArray;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01");
        LocalDate date = DateTimeTestUtil$.MODULE$.localDate("2017-09-12");
        LocalTime time = DateTimeTestUtil$.MODULE$.localTime("14:23:01");
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"date_col"), ApiExpressionUtils.valueLiteral((Object)date)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"time_col"), ApiExpressionUtils.valueLiteral((Object)time)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    @Test
    public void testExtractArithmeticConditions() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MINUS, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, new RexNode[]{t0, t1}), t2}), this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall(FlinkSqlOperatorTable.DIVIDE, new RexNode[]{t0, t1}), t2})}))).asJava();
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$bang$eq$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$greater(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$plus(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$minus(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$times(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100)), package$.MODULE$.WithOperations(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$div(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))).$eq$eq$eq(package$.MODULE$.int2Literal(100))});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractPostfixConditions() {
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NULL, "isNull(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_TRUE, "isTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_TRUE, "isNotTrue(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_FALSE, "isFalse(flag)");
        this.testExtractSinglePostfixCondition(Predef$.MODULE$.int2Integer(4), SqlStdOperatorTable.IS_NOT_FALSE, "isNotFalse(flag)");
    }

    @Test
    public void testExtractConditionWithFunctionCalls() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SUM, new RexNode[]{t0}), t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.FIRST_VALUE, new RexNode[]{t1}), t2});
        RexNode complexExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(complexExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)new AggregateFunctionDefinition("sum", (AggregateFunction)new IntSumAggFunction(), Types.INT, Types.INT), (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"amount")}), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToInteger((int)100))})});
        this.assertExpressionArrayEquals(expected, convertedExpressions2);
        Assert.assertEquals((long)1L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractWithCast() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexInputRef t1 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(1), 1);
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode cast = this.rexBuilder().makeCast(this.allFieldTypes().get(1), (RexNode)t0);
        RexNode condition1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{cast, t2});
        RexNode condition2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{t0, t1});
        RexNode condition3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{condition1, condition2});
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{condition1, condition2, condition3});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)3L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)"greaterThan(cast(amount, BIGINT), 100)", (Object)convertedExpressions2[0].toString());
        Assert.assertEquals((Object)"lessThanOrEqual(amount, id)", (Object)convertedExpressions2[1].toString());
        Assert.assertEquals((Object)"or(greaterThan(cast(amount, BIGINT), 100), lessThanOrEqual(amount, id))", (Object)convertedExpressions2[2].toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
        this.assertExpressionArrayEquals((Expression[])((Object[])new Expression[]{package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"amount"}))).$((Seq)Nil$.MODULE$)).$less$eq(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$))}), (Expression[])((Object[])new Expression[]{convertedExpressions2[1]}));
    }

    @Test
    public void testExtractWithTrim() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t1 = this.rexBuilder().makeLiteral("He");
        RexNode trimBoth = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.BOTH), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimLeading = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.LEADING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode trimTrailing = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.TRIM, new RexNode[]{this.rexBuilder().makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), this.rexBuilder().makeLiteral(" "), t0}), t1});
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)trimBoth, (List)new .colon.colon((Object)trimLeading, (List)new .colon.colon((Object)trimTrailing, (List)Nil$.MODULE$)))).asJava());
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)0L, (long)convertedExpressions2.length);
        Assert.assertEquals((long)3L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractWithUdf() {
        this.functionCatalog().registerTempSystemScalarFunction("myUdf", (ScalarFunction)Func1$.MODULE$);
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexNode t1 = this.rexBuilder().makeCall((SqlOperator)new ScalarSqlFunction(FunctionIdentifier.of((String)"MyUdf"), "myUdf", (ScalarFunction)Func1$.MODULE$, this.typeFactory(), ScalarSqlFunction$.MODULE$.$lessinit$greater$default$5()), new RexNode[]{t0});
        RexLiteral t2 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode condition = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t1, t2});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(condition, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)1L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)"greaterThan(MyUdf(amount), 100)", (Object)convertedExpressions2[0].toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    @Test
    public void testExtractPartitionPredicates() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 2);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(0), 0);
        RexLiteral t3 = this.rexBuilder().makeLiteral("test%");
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        Tuple2 tuple23 = tuple22;
        RexNode partitionPredicate12 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple23._2();
        Assert.assertEquals((Object)c3, (Object)partitionPredicate12);
        Assert.assertTrue((boolean)nonPartitionPredicate12.isAlwaysTrue());
        Tuple2 tuple24 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        RexNode partitionPredicate2 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        Tuple2 tuple26 = tuple25;
        RexNode partitionPredicate22 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple26._2();
        Assert.assertEquals((Object)c1, (Object)partitionPredicate22);
        Assert.assertEquals((Object)c2, (Object)nonPartitionPredicate22);
        Tuple2 tuple27 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"id"}));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        RexNode partitionPredicate3 = (RexNode)tuple27._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        Tuple2 tuple29 = tuple28;
        RexNode partitionPredicate32 = (RexNode)tuple29._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple29._2();
        Assert.assertTrue((boolean)partitionPredicate32.isAlwaysTrue());
        Assert.assertEquals((Object)c3, (Object)nonPartitionPredicate32);
        RexNode c4 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{c1, c2});
        Tuple2 tuple210 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount", "name"}));
        if (tuple210 == null) {
            throw new MatchError((Object)tuple210);
        }
        RexNode partitionPredicate4 = (RexNode)tuple210._1();
        RexNode nonPartitionPredicate4 = (RexNode)tuple210._2();
        Tuple2 tuple211 = new Tuple2((Object)partitionPredicate4, (Object)nonPartitionPredicate4);
        Tuple2 tuple212 = tuple211;
        RexNode partitionPredicate42 = (RexNode)tuple212._1();
        RexNode nonPartitionPredicate42 = (RexNode)tuple212._2();
        Assert.assertEquals((Object)c4, (Object)partitionPredicate42);
        Assert.assertTrue((boolean)nonPartitionPredicate42.isAlwaysTrue());
        Tuple2 tuple213 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c4, -1, (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.allFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.rexBuilder(), (String[])((Object[])new String[]{"amount"}));
        if (tuple213 == null) {
            throw new MatchError((Object)tuple213);
        }
        RexNode partitionPredicate5 = (RexNode)tuple213._1();
        RexNode nonPartitionPredicate5 = (RexNode)tuple213._2();
        Tuple2 tuple214 = new Tuple2((Object)partitionPredicate5, (Object)nonPartitionPredicate5);
        Tuple2 tuple215 = tuple214;
        RexNode partitionPredicate52 = (RexNode)tuple215._1();
        RexNode nonPartitionPredicate52 = (RexNode)tuple215._2();
        Assert.assertTrue((boolean)partitionPredicate52.isAlwaysTrue());
        Assert.assertEquals((Object)c4, (Object)nonPartitionPredicate52);
    }

    @Test
    public void testExtractPartitionPredicatesDate() {
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(2), 1);
        RexLiteral t1 = this.rexBuilder().makeExactLiteral(BigDecimal.valueOf(100L));
        RexNode c1 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t0, t1});
        RexInputRef t2 = this.rexBuilder().makeInputRef(this.typeFactory().createFieldTypeFromLogicalType(DataTypes.DATE().getLogicalType()), 0);
        RexLiteral t3 = this.rexBuilder().makeDateLiteral(DateString.fromDaysSinceEpoch((int)18000));
        RexNode c2 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{t2, t3});
        RexNode c3 = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{c1, c2});
        Tuple2 tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date"}));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexNode partitionPredicate1 = (RexNode)tuple2._1();
        RexNode nonPartitionPredicate1 = (RexNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicate1, (Object)nonPartitionPredicate1);
        Tuple2 tuple23 = tuple22;
        RexNode partitionPredicate12 = (RexNode)tuple23._1();
        RexNode nonPartitionPredicate12 = (RexNode)tuple23._2();
        Assert.assertEquals((Object)c2, (Object)partitionPredicate12);
        Assert.assertEquals((Object)c1, (Object)nonPartitionPredicate12);
        Tuple2 tuple24 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"date", "amount"}));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        RexNode partitionPredicate2 = (RexNode)tuple24._1();
        RexNode nonPartitionPredicate2 = (RexNode)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)partitionPredicate2, (Object)nonPartitionPredicate2);
        Tuple2 tuple26 = tuple25;
        RexNode partitionPredicate22 = (RexNode)tuple26._1();
        RexNode nonPartitionPredicate22 = (RexNode)tuple26._2();
        Assert.assertEquals((Object)c3, (Object)partitionPredicate22);
        Assert.assertTrue((boolean)nonPartitionPredicate22.isAlwaysTrue());
        Tuple2 tuple27 = RexNodeExtractor$.MODULE$.extractPartitionPredicates(c3, -1, (String[])((Object[])new String[]{"date", "amount", "id"}), this.rexBuilder(), (String[])((Object[])new String[]{"id", "amount"}));
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        RexNode partitionPredicate3 = (RexNode)tuple27._1();
        RexNode nonPartitionPredicate3 = (RexNode)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)partitionPredicate3, (Object)nonPartitionPredicate3);
        Tuple2 tuple29 = tuple28;
        RexNode partitionPredicate32 = (RexNode)tuple29._1();
        RexNode nonPartitionPredicate32 = (RexNode)tuple29._2();
        Assert.assertEquals((Object)c1, (Object)partitionPredicate32);
        Assert.assertEquals((Object)c2, (Object)nonPartitionPredicate32);
    }

    @Test
    public void testTimeLiteralWithLocalTimeZoneConversions() {
        Expression[] converted;
        java.util.List fieldNames = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"timestamp_col", (List)new .colon.colon((Object)"instant_col", (List)Nil$.MODULE$))).asJava();
        java.util.List<RelDataType> fieldTypes = this.makeTypes((Seq<SqlTypeName>)Predef$.MODULE$.wrapRefArray((Object[])new SqlTypeName[]{SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE}));
        TimestampString timestampString = new TimestampString("2017-09-10 14:23:01.123456");
        RexLiteral rexTimestamp = this.rexBuilder().makeTimestampLiteral(timestampString, 6);
        RexLiteral rexInstant = this.rexBuilder().makeTimestampWithLocalTimeZoneLiteral(timestampString, 6);
        .colon.colon allRexNodes = new .colon.colon((Object)rexTimestamp, (List)new .colon.colon((Object)rexInstant, (List)Nil$.MODULE$));
        java.util.List condition = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldTypes).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeInputRef((RelDataType)t._1(), t._2$mcI$sp()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)allRexNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)t -> this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)t._1(), (RexNode)t._2()}), Buffer$.MODULE$.canBuildFrom())).asJava();
        RexNode and = this.rexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, condition);
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        ZoneId shanghai = ZoneId.of("Asia/Shanghai");
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(and, -1, fieldNames, (RexBuilder)relBuilder, this.functionCatalog(), TimeZone.getTimeZone(shanghai));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] expressionArray = converted = (Expression[])tuple2._1();
        Expression[] converted2 = expressionArray;
        LocalDateTime datetime = DateTimeTestUtil$.MODULE$.localDateTime("2017-09-10 14:23:01.123456");
        Instant instant = datetime.toInstant(shanghai.getRules().getOffset(datetime));
        Expression[] expected = (Expression[])((Object[])new Expression[]{ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"timestamp_col"), ApiExpressionUtils.valueLiteral((Object)datetime)}), ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, (Expression[])new Expression[]{ApiExpressionUtils.unresolvedRef((String)"instant_col"), ApiExpressionUtils.valueLiteral((Object)instant)})});
        this.assertExpressionArrayEquals(expected, converted2);
    }

    private void testExtractSinglePostfixCondition(Integer fieldIndex, SqlPostfixOperator op, String expr) {
        this.rexBuilder_$eq((RexBuilder)new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory()));
        RexInputRef t0 = this.rexBuilder().makeInputRef(this.allFieldTypes().get(Predef$.MODULE$.Integer2int(fieldIndex)), Predef$.MODULE$.Integer2int(fieldIndex));
        RexNode conditionExpr = this.rexBuilder().makeCall((SqlOperator)op, new RexNode[]{t0});
        FlinkRexBuilder relBuilder = new FlinkRexBuilder((RelDataTypeFactory)this.typeFactory());
        Tuple2<Expression[], RexNode[]> tuple2 = this.extractConjunctiveConditions(conditionExpr, -1, this.allFieldNames(), (RexBuilder)relBuilder, this.functionCatalog(), this.extractConjunctiveConditions$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] convertedExpressions = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)convertedExpressions, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] convertedExpressions2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        Assert.assertEquals((long)1L, (long)convertedExpressions2.length);
        Assert.assertEquals((Object)expr, (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])convertedExpressions2)).head().toString());
        Assert.assertEquals((long)0L, (long)unconvertedRexNodes2.length);
    }

    private void assertExpressionArrayEquals(Expression[] expected, Expression[] actual) {
        Expression[] sortedExpected = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Expression[] sortedActual = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual)).sortBy((Function1 & Serializable & scala.Serializable)e -> e.toString(), (Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((long)sortedExpected.length, (long)sortedActual.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedExpected)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sortedActual), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RexNodeExtractorTest.$anonfun$assertExpressionArrayEquals$3(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexNode expr, int maxCnfNodeCount, java.util.List<String> inputFieldNames, RexBuilder rexBuilder, FunctionCatalog catalog, TimeZone tz) {
        return RexNodeExtractor$.MODULE$.extractConjunctiveConditions(expr, maxCnfNodeCount, inputFieldNames, rexBuilder, catalog, this.catalogManager(), tz);
    }

    private TimeZone extractConjunctiveConditions$default$6() {
        return TimeZone.getDefault();
    }

    public static final /* synthetic */ void $anonfun$assertExpressionArrayEquals$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression l = (Expression)tuple2._1();
        Expression r = (Expression)tuple2._2();
        Assert.assertEquals((Object)l.toString(), (Object)r.toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

