/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.jsonplan;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.JsonPlanTestBase;
import org.apache.flink.types.Row;
import org.junit.Test;

public class SortLimitJsonPlanITCase
extends JsonPlanTestBase {
    @Test
    public void testSortLimit() throws ExecutionException, InterruptedException, IOException {
        this.createTestValuesSourceTable("MyTable", (List<Row>)JavaScalaConversionUtil.toJava(TestData.data1()), "a int", "b varchar", "c int");
        this.createTestNonInsertOnlyValuesSinkTable("`result`", "a int", "b varchar", "c bigint");
        String sql = "insert into `result` select * from MyTable order by a limit 3";
        this.compileSqlAndExecutePlan(sql).await();
        List<String> expected = Arrays.asList("+I[1, a, 5]", "+I[2, a, 6]", "+I[3, b, 7]");
        this.assertResult(expected, TestValuesTableFactory.getResults("result"));
    }
}

