/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchAbstractTestBase;
import org.apache.flink.table.planner.runtime.utils.BatchTableEnvUtil$;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase$;
import org.apache.flink.table.planner.runtime.utils.RangeInputFormat;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestingTableEnvironment;
import org.apache.flink.table.planner.utils.TestingTableEnvironment$;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CollectionUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011Ef\u0001B\u0001\u0003\u0001E\u0011QBQ1uG\"$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t)\")\u0019;dQ\u0006\u00137\u000f\u001e:bGR$Vm\u001d;CCN,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0004\u001c\u0001\u0001\u0007I\u0011\u0003\u000f\u0002\u0011M,G\u000f^5oON,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A!\t1!\u00199j\u0013\t\u0011sDA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000fC\u0004%\u0001\u0001\u0007I\u0011C\u0013\u0002\u0019M,G\u000f^5oON|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0012\u0002\u0002\u0003\u0007Q$A\u0002yIEBaa\f\u0001!B\u0013i\u0012!C:fiRLgnZ:!\u0011\u001d\t\u0004\u00011A\u0005\u0012I\nq\u0002^3ti&tw\rV1cY\u0016,eN^\u000b\u0002gA\u0011AGN\u0007\u0002k)\u00111AB\u0005\u0003oU\u0012q\u0003V3ti&tw\rV1cY\u0016,eN^5s_:lWM\u001c;\t\u000fe\u0002\u0001\u0019!C\tu\u0005\u0019B/Z:uS:<G+\u00192mK\u0016sgo\u0018\u0013fcR\u0011ae\u000f\u0005\b[a\n\t\u00111\u00014\u0011\u0019i\u0004\u0001)Q\u0005g\u0005\u0001B/Z:uS:<G+\u00192mK\u0016sg\u000f\t\u0005\b\u007f\u0001\u0001\r\u0011\"\u0005A\u0003\u0011!XI\u001c<\u0016\u0003\u0005\u0003\"A\b\"\n\u0005\r{\"\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011\u001d)\u0005\u00011A\u0005\u0012\u0019\u000b\u0001\u0002^#om~#S-\u001d\u000b\u0003M\u001dCq!\f#\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004J\u0001\u0001\u0006K!Q\u0001\u0006i\u0016sg\u000f\t\u0005\b\u000f\u0001\u0001\r\u0011\"\u0005L+\u0005a\u0005CA'Q\u001b\u0005q%BA(\u0007\u0003)!W\r\\3hCRLwN\\\u0005\u0003#:\u00131\u0002\u00157b]:,'OQ1tK\"91\u000b\u0001a\u0001\n#!\u0016a\u00039mC:tWM]0%KF$\"AJ+\t\u000f5\u0012\u0016\u0011!a\u0001\u0019\"1q\u000b\u0001Q!\n1\u000b\u0001\u0002\u001d7b]:,'\u000f\t\u0005\b3\u0002\u0001\r\u0011\"\u0005[\u0003\r)gN^\u000b\u00027B\u0011ALY\u0007\u0002;*\u0011alX\u0001\fK:4\u0018N]8o[\u0016tGO\u0003\u0002!A*\u0011\u0011MC\u0001\ngR\u0014X-Y7j]\u001eL!aY/\u00035M#(/Z1n\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\u000f\u0015\u0004\u0001\u0019!C\tM\u00069QM\u001c<`I\u0015\fHC\u0001\u0014h\u0011\u001diC-!AA\u0002mCa!\u001b\u0001!B\u0013Y\u0016\u0001B3om\u0002Bqa\u001b\u0001A\u0002\u0013EA.A\u0006uC\ndWmQ8oM&<W#A7\u0011\u0005yq\u0017BA8 \u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000fE\u0004\u0001\u0019!C\te\u0006yA/\u00192mK\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0002'g\"9Q\u0006]A\u0001\u0002\u0004i\u0007BB;\u0001A\u0003&Q.\u0001\u0007uC\ndWmQ8oM&<\u0007\u0005C\u0004x\u0001\t\u0007I\u0011\u0001=\u0002!1Ke*R0D\u001f2{\u0006+\u0011+U\u000bJsU#A=\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0A\u0003sK\u001e,\u0007P\u0003\u0002\u007f\u007f\u0006!Q\u000f^5m\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003w\n9\u0001+\u0019;uKJt\u0007bBA\u0005\u0001\u0001\u0006I!_\u0001\u0012\u0019&sUiX\"P\u0019~\u0003\u0016\t\u0016+F%:\u0003\u0003\u0002CA\u0007\u0001\t\u0007I\u0011\u0001=\u0002-1Ke*R0D\u001f2{FkV%D\u000b~\u0003\u0016\t\u0016+F%:Cq!!\u0005\u0001A\u0003%\u00110A\fM\u0013:+ulQ(M?R;\u0016jQ#`!\u0006#F+\u0012*OA!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011A\u00022fM>\u0014X\rF\u0001'Q\u0011\t\u0019\"a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u000f\u0003\u0015QWO\\5u\u0013\u0011\t)#a\b\u0003\r\t+gm\u001c:fQ\u0019\t\u0019\"!\u000b\u0002HA)q%a\u000b\u00020%\u0019\u0011Q\u0006\u0015\u0003\rQD'o\\<t!\u0011\t\t$!\u0011\u000f\t\u0005M\u0012Q\b\b\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013bAA Q\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\"\u0003\u000b\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005}\u0002f\t\u0002\u00020!9\u00111\n\u0001\u0005\u0002\u0005]\u0011!B1gi\u0016\u0014\b\u0006BA%\u0003\u001f\u0002B!!\b\u0002R%!\u00111KA\u0010\u0005\u0015\te\r^3s\u0011\u001d\t9\u0006\u0001C\u0001\u00033\na\"\u001a=qY\u0006Lg\u000eT8hS\u000e\fG\u000e\u0006\u0003\u0002\\\u0005-\u0004\u0003BA/\u0003KrA!a\u0018\u0002bA\u0019\u0011Q\u0007\u0015\n\u0007\u0005\r\u0004&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\nIG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003GB\u0003bB\u0005\u0002V\u0001\u0007\u0011Q\u000e\t\u0004=\u0005=\u0014bAA9?\t)A+\u00192mK\"9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014aC2iK\u000e\\'+Z:vYR$rAJA=\u0003{\nI\n\u0003\u0005\u0002|\u0005M\u0004\u0019AA.\u0003!\u0019\u0018\u000f\\)vKJL\b\u0002CA@\u0003g\u0002\r!!!\u0002\u001d\u0015D\b/Z2uK\u0012\u0014Vm];miB1\u00111QAE\u0003\u001bk!!!\"\u000b\u0007\u0005\u001d\u0005&\u0001\u0006d_2dWm\u0019;j_:LA!a#\u0002\u0006\n\u00191+Z9\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%\u000b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9*!%\u0003\u0007I{w\u000f\u0003\u0006\u0002\u001c\u0006M\u0004\u0013!a\u0001\u0003;\u000b\u0001\"[:T_J$X\r\u001a\t\u0004O\u0005}\u0015bAAQQ\t9!i\\8mK\u0006t\u0007bBAS\u0001\u0011\u0005\u0011qU\u0001\u0011G\",7m\u001b+bE2,'+Z:vYR$rAJAU\u0003W\u000bi\u000bC\u0004\n\u0003G\u0003\r!!\u001c\t\u0011\u0005}\u00141\u0015a\u0001\u0003\u0003C!\"a'\u0002$B\u0005\t\u0019AAO\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b\u0011b\u00195fG.\u001c\u0016N_3\u0015\u000b\u0019\n),a.\t\u0011\u0005m\u0014q\u0016a\u0001\u00037B\u0001\"!/\u00020\u0002\u0007\u00111X\u0001\rKb\u0004Xm\u0019;fINK'0\u001a\t\u0004O\u0005u\u0016bAA`Q\t\u0019\u0011J\u001c;\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\u00069q-\u001a;QY\u0006tG\u0003BA.\u0003\u000fD\u0001\"!3\u0002B\u0002\u0007\u00111Z\u0001\be\u0016dgj\u001c3f!\u0011\ti-a6\u000e\u0005\u0005='\u0002BAi\u0003'\f1A]3m\u0015\r\t)\u000eD\u0001\bG\u0006d7-\u001b;f\u0013\u0011\tI.a4\u0003\u000fI+GNT8eK\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0017!B2iK\u000e\\G#\u0002\u0014\u0002b\u0006\r\b\u0002CA>\u00037\u0004\r!a\u0017\t\u0011\u0005\u0015\u00181\u001ca\u0001\u0003O\f\u0011b\u00195fG.4UO\\2\u0011\u000f\u001d\nI/!!\u0002n&\u0019\u00111\u001e\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#B\u0014\u0002p\u0006m\u0013bAAyQ\t1q\n\u001d;j_:Dq!!>\u0001\t\u0003\t90\u0001\u0006dQ\u0016\u001c7\u000eV1cY\u0016$RAJA}\u0003wDq!CAz\u0001\u0004\ti\u0007\u0003\u0005\u0002f\u0006M\b\u0019AAt\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003\t1b\u00195fG.4\u0015-\u001b7fIR)aEa\u0001\u0003\u0006!A\u00111PA\u007f\u0001\u0004\tY\u0006\u0003\u0005\u0003\b\u0005u\b\u0019AA.\u0003I)\u0007\u0010]3di\u0016$Wj]4QCR$XM\u001d8\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005\u00012\r[3dW\u0016k\u0007\u000f^=SKN,H\u000e\u001e\u000b\u0004M\t=\u0001\u0002CA>\u0005\u0013\u0001\r!a\u0017\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016\u0005Q\u0001/\u0019:tKF+XM]=\u0015\t\u00055$q\u0003\u0005\t\u0003w\u0012\t\u00021\u0001\u0002\\!9!1\u0004\u0001\u0005\u0002\tu\u0011\u0001D3yK\u000e,H/Z)vKJLH\u0003BAA\u0005?Aq!\u0003B\r\u0001\u0004\ti\u0007C\u0004\u0003\u001c\u0001!\tAa\t\u0015\t\u0005\u0005%Q\u0005\u0005\t\u0003w\u0012\t\u00031\u0001\u0002\\!9!\u0011\u0006\u0001\u0005\n\t-\u0012!\u00049sKB\f'/\u001a*fgVdG\u000f\u0006\u0004\u0003.\t=\"1\u0007\t\u0007\u0003\u0007\u000bI)a\u0017\t\u0011\tE\"q\u0005a\u0001\u0003\u0003\u000b1a]3r\u0011!\tYJa\nA\u0002\u0005u\u0005b\u0002B\u001c\u0001\u0011\u0005!\u0011H\u0001\nG\",7m[*b[\u0016$\u0002\"!<\u0003<\tu\"\u0011\t\u0005\t\u0003\u007f\u0012)\u00041\u0001\u0002\u0002\"A!q\bB\u001b\u0001\u0004\t\t)\u0001\u0004sKN,H\u000e\u001e\u0005\u000b\u00037\u0013)\u0004%AA\u0002\u0005u\u0005b\u0002B#\u0001\u0011%!qI\u0001\u000bG\",7m[#naRLH\u0003BAw\u0005\u0013B\u0001Ba\u0010\u0003D\u0001\u0007\u0011\u0011\u0011\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0003)\u0019\u0018\u000eZ3CsNKG-\u001a\u000b\u0007\u0005#\u0012iF!\u0019\u0011\r\u0005\r\u0015\u0011\u0012B*!\u0011\u0011)Fa\u0017\u000e\u0005\t]#b\u0001B-\u007f\u0006!A.\u00198h\u0013\u0011\t9Ga\u0016\t\u0011\t}#1\na\u0001\u0005[\tA\u0001\\3gi\"A!1\rB&\u0001\u0004\u0011i#A\u0003sS\u001eDG\u000fC\u0004\u0003h\u0001!\u0019A!\u001b\u0002%I,w-[:uKJ\u001cu\u000e\u001c7fGRLwN\u001c\u000b\nM\t-$q\u000eB=\u0005\u001fC\u0001B!\u001c\u0003f\u0001\u0007\u00111L\u0001\ni\u0006\u0014G.\u001a(b[\u0016D\u0001B!\u001d\u0003f\u0001\u0007!1O\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u00022\tU\u0014QR\u0005\u0005\u0005o\n)E\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011!\u0011YH!\u001aA\u0002\tu\u0014\u0001\u0003;za\u0016LeNZ8\u0011\r\t}$1RAG\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n\u0015\u0015\u0001\u0003;za\u0016LgNZ8\u000b\t\t\u001d%\u0011R\u0001\u0007G>lWn\u001c8\u000b\u0005\u0001R\u0011\u0002\u0002BG\u0005\u0003\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t\u0005#\u0013)\u00071\u0001\u0002\\\u00051a-[3mINDqA!&\u0001\t\u0003\u00119*\u0001\fsK\u001eL7\u000f^3s\u0015\u00064\u0018mQ8mY\u0016\u001cG/[8o+\u0011\u0011IJa*\u0015\u0013\u0019\u0012YJ!(\u0003:\nu\u0006\u0002\u0003B7\u0005'\u0003\r!a\u0017\t\u0011\tE$1\u0013a\u0001\u0005?\u0003bA!\u0016\u0003\"\n\r\u0016\u0002\u0002B<\u0005/\u0002BA!*\u0003(2\u0001A\u0001\u0003BU\u0005'\u0013\rAa+\u0003\u0003Q\u000bBA!,\u00034B\u0019qEa,\n\u0007\tE\u0006FA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\u0012),C\u0002\u00038\"\u00121!\u00118z\u0011!\u0011YHa%A\u0002\tm\u0006C\u0002B@\u0005\u0017\u0013\u0019\u000b\u0003\u0005\u0003\u0012\nM\u0005\u0019AA.\u0011\u001d\u00119\u0007\u0001C\u0001\u0005\u0003,BAa1\u0003NRYaE!2\u0003H\n='1\u001bBk\u0011!\u0011iGa0A\u0002\u0005m\u0003\u0002\u0003B9\u0005\u007f\u0003\rA!3\u0011\r\u0005E\"Q\u000fBf!\u0011\u0011)K!4\u0005\u0011\t%&q\u0018b\u0001\u0005WC\u0001Ba\u001f\u0003@\u0002\u0007!\u0011\u001b\t\u0007\u0005\u007f\u0012YIa3\t\u0011\tE%q\u0018a\u0001\u00037B\u0001Ba6\u0003@\u0002\u0007!\u0011\\\u0001\u000fM&,G\u000e\u001a(vY2\f'\r\\3t!\u00159#1\\AO\u0013\r\u0011i\u000e\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005O\u0002A\u0011\u0001Bq+\u0011\u0011\u0019O!<\u0015\u001b\u0019\u0012)Oa:\u0003p\nM(Q\u001fB|\u0011!\u0011iGa8A\u0002\u0005m\u0003\u0002\u0003B9\u0005?\u0004\rA!;\u0011\r\u0005E\"Q\u000fBv!\u0011\u0011)K!<\u0005\u0011\t%&q\u001cb\u0001\u0005WC\u0001Ba\u001f\u0003`\u0002\u0007!\u0011\u001f\t\u0007\u0005\u007f\u0012YIa;\t\u0011\tE%q\u001ca\u0001\u00037B\u0001Ba6\u0003`\u0002\u0007!\u0011\u001c\u0005\t\u0005s\u0014y\u000e1\u0001\u0003|\u0006I1\u000f^1uSN$\u0018n\u0019\t\u0005\u0005{\u001c9!\u0004\u0002\u0003\u0000*!1\u0011AB\u0002\u0003\u0015\u0019H/\u0019;t\u0015\r\u0019)AB\u0001\u0005a2\fg.\u0003\u0003\u0004\n\t}(A\u0004$mS:\\7\u000b^1uSN$\u0018n\u0019\u0005\b\u0007\u001b\u0001A\u0011AB\b\u0003}\u0011XmZ5ti\u0016\u0014H+Z7q_J\f'/_*zgR,WNR;oGRLwN\u001c\u000b\u0006M\rE1Q\u0003\u0005\t\u0007'\u0019Y\u00011\u0001\u0002\\\u0005!a.Y7f\u0011!\u00199ba\u0003A\u0002\re\u0011!\u00044v]\u000e$\u0018n\u001c8DY\u0006\u001c8\u000f\r\u0003\u0004\u001c\r\r\u0002CBA/\u0007;\u0019\t#\u0003\u0003\u0004 \u0005%$!B\"mCN\u001c\b\u0003\u0002BS\u0007G!Ab!\n\u0004\u0016\u0005\u0005\t\u0011!B\u0001\u0007O\u00111a\u0018\u00132#\u0011\u0011ik!\u000b\u0011\t\r-2\u0011G\u0007\u0003\u0007[Q1aa\f\t\u0003%1WO\\2uS>t7/\u0003\u0003\u00044\r5\"aE+tKJ$UMZ5oK\u00124UO\\2uS>t\u0007bBB\u001c\u0001\u0011\u00051\u0011H\u0001\u0011e\u0016<\u0017n\u001d;fe\u001a+hn\u0019;j_:$RAJB\u001e\u0007{A\u0001ba\u0005\u00046\u0001\u0007\u00111\f\u0005\t\u0007\u007f\u0019)\u00041\u0001\u0004B\u0005Aa-\u001e8di&|g\u000e\u0005\u0003\u0004,\r\r\u0013\u0002BB#\u0007[\u0011abU2bY\u0006\u0014h)\u001e8di&|g\u000e\u000b\u0005\u00046\r%3qJB2!\r931J\u0005\u0004\u0007\u001bB#A\u00033faJ,7-\u0019;fIFJ1%a\u0017\u0004R\re31K\u0005\u0005\u0007'\u001a)&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0007/B\u0013A\u00033faJ,7-\u0019;fIFJ1ea\u0017\u0004^\r}3q\u000b\b\u0004O\ru\u0013bAB,QE*!e\n\u0015\u0004b\t)1oY1mCFJ1%a\u0017\u0004f\r%4qM\u0005\u0005\u0007O\u001a)&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0019\nG\rm3QLB6\u0007/\nTAI\u0014)\u0007CBqaa\u000e\u0001\t\u0003\u0019y'\u0006\u0004\u0004r\ru4q\u0011\u000b\u0007\u0007g\u001aYi!$\u0015\u000b\u0019\u001a)ha \t\u0015\r]4QNA\u0001\u0002\b\u0019I(\u0001\u0006fm&$WM\\2fIE\u0002bAa \u0003\f\u000em\u0004\u0003\u0002BS\u0007{\"\u0001B!+\u0004n\t\u0007!1\u0016\u0005\u000b\u0007\u0003\u001bi'!AA\u0004\r\r\u0015AC3wS\u0012,gnY3%eA1!q\u0010BF\u0007\u000b\u0003BA!*\u0004\b\u0012A1\u0011RB7\u0005\u0004\u0011YKA\u0002B\u0007\u000eC\u0001ba\u0005\u0004n\u0001\u0007\u00111\f\u0005\t\u0007\u001f\u001bi\u00071\u0001\u0004\u0012\u0006\ta\r\u0005\u0005\u0004,\rM51PBC\u0013\u0011\u0019)j!\f\u0003#\u0005;wM]3hCR,g)\u001e8di&|g\u000e\u000b\u0005\u0004n\r%3\u0011TBPc%\u0019\u00131LB)\u00077\u001b\u0019&M\u0005$\u00077\u001aif!(\u0004XE*!e\n\u0015\u0004bEJ1%a\u0017\u0004f\r\u00056qM\u0019\nG\rm3QLBR\u0007/\nTAI\u0014)\u0007CBqaa\u000e\u0001\t\u0003\u00199+\u0006\u0003\u0004*\u000eUFCBBV\u0007o\u001bI\fF\u0002'\u0007[C!ba,\u0004&\u0006\u0005\t9ABY\u0003))g/\u001b3f]\u000e,Ge\r\t\u0007\u0005\u007f\u0012Yia-\u0011\t\t\u00156Q\u0017\u0003\t\u0005S\u001b)K1\u0001\u0003,\"A11CBS\u0001\u0004\tY\u0006\u0003\u0005\u0004<\u000e\u0015\u0006\u0019AB_\u0003\t!h\r\u0005\u0004\u0004,\r}61W\u0005\u0005\u0007\u0003\u001ciCA\u0007UC\ndWMR;oGRLwN\u001c\u0015\t\u0007K\u001bIe!2\u0004LFJ1%a\u0017\u0004R\r\u001d71K\u0019\nG\rm3QLBe\u0007/\nTAI\u0014)\u0007C\n\u0014bIA.\u0007K\u001aima\u001a2\u0013\r\u001aYf!\u0018\u0004P\u000e]\u0013'\u0002\u0012(Q\r\u0005\u0004bBBj\u0001\u0011\u00051Q[\u0001\u000ee\u0016<\u0017n\u001d;feJ\u000bgnZ3\u0015\u000b\u0019\u001a9n!7\t\u0011\rM1\u0011\u001ba\u0001\u00037B\u0001ba7\u0004R\u0002\u00071Q\\\u0001\u0004K:$\u0007cA\u0014\u0004`&\u00191\u0011\u001d\u0015\u0003\t1{gn\u001a\u0005\b\u0007'\u0004A\u0011ABs)\u001d13q]Bu\u0007[D\u0001ba\u0005\u0004d\u0002\u0007\u00111\f\u0005\t\u0007W\u001c\u0019\u000f1\u0001\u0004^\u0006)1\u000f^1si\"A11\\Br\u0001\u0004\u0019i\u000eC\u0004\u0004r\u0002!\taa=\u0002\u001d9,wOU1oO\u0016\u001cv.\u001e:dKR11Q\u001fC\u0006\t\u001b\u0001baa>\u0004~\u0012\u0005QBAB}\u0015\r\u0019YpX\u0001\u000bI\u0006$\u0018m\u001d;sK\u0006l\u0017\u0002BB\u0000\u0007s\u0014!\u0002R1uCN#(/Z1n!\u0011!\u0019\u0001b\u0002\u000e\u0005\u0011\u0015!b\u0001B9\u0011%!A\u0011\u0002C\u0003\u0005\u001d\u0011vn\u001e#bi\u0006D\u0001ba;\u0004p\u0002\u00071Q\u001c\u0005\t\u00077\u001cy\u000f1\u0001\u0004^\"9A\u0011\u0003\u0001\u0005\u0012\u0011M\u0011!\u0002:po>3G\u0003BAG\t+A\u0001\u0002b\u0006\u0005\u0010\u0001\u0007A\u0011D\u0001\u0005CJ<7\u000fE\u0003(\t7\u0011\u0019,C\u0002\u0005\u001e!\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0011%!\t\u0003AI\u0001\n\u0003!\u0019#A\u000bdQ\u0016\u001c7NU3tk2$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011\u0015\"\u0006BAO\tOY#\u0001\"\u000b\u0011\t\u0011-BQG\u0007\u0003\t[QA\u0001b\f\u00052\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\tgA\u0013AC1o]>$\u0018\r^5p]&!Aq\u0007C\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\tw\u0001\u0011\u0013!C\u0001\tG\t!d\u00195fG.$\u0016M\u00197f%\u0016\u001cX\u000f\u001c;%I\u00164\u0017-\u001e7uIMB\u0011\u0002b\u0010\u0001#\u0003%\t\u0001b\t\u0002'\rDWmY6TC6,G\u0005Z3gCVdG\u000fJ\u001a\b\u000f\u0011\r#\u0001#\u0001\u0005F\u0005i!)\u0019;dQR+7\u000f\u001e\"bg\u0016\u00042a\u0005C$\r\u0019\t!\u0001#\u0001\u0005JM!Aq\tC&!\r9CQJ\u0005\u0004\t\u001fB#AB!osJ+g\rC\u0004\u0018\t\u000f\"\t\u0001b\u0015\u0015\u0005\u0011\u0015\u0003\u0002\u0003C,\t\u000f\"\t\u0001\"\u0017\u0002\u0007I|w\u000f\u0006\u0003\u0002\u000e\u0012m\u0003\u0002\u0003C\f\t+\u0002\r\u0001\"\u0007\t\u0011\u0011}Cq\tC\u0001\tC\n\u0011BY5oCJL(k\\<\u0015\r\u0011\rDq\u000eCA!\u0011!)\u0007b\u001b\u000e\u0005\u0011\u001d$\u0002\u0002C5\t\u000b\taAY5oCJL\u0018\u0002\u0002C7\tO\u0012QBQ5oCJL(k\\<ECR\f\u0007\u0002CAJ\t;\u0002\r\u0001\"\u001d\u0011\u000b\u001d\u0012Y\u000eb\u001d\u0011\t\u0011UDQP\u0007\u0003\toRA\u0001\"\u001f\u0005|\u00059An\\4jG\u0006d'bAAJ\u0011%!Aq\u0010C<\u0005-aunZ5dC2$\u0016\u0010]3\t\u0011\tEEQ\fa\u0001\t3A\u0001\u0002\"\"\u0005H\u0011\u0005AqQ\u0001\u000eG>l\u0007/\u0019:f%\u0016\u001cX\u000f\u001c;\u0016\t\u0011%Eq\u0013\u000b\nM\u0011-E\u0011\u0013CM\t;C\u0001\u0002\"$\u0005\u0004\u0002\u0007AqR\u0001\u0010Kb\u0004Xm\u0019;fIN#(/\u001b8hgB)qEa7\u0002\\!A!q\bCB\u0001\u0004!\u0019\nE\u0003(\u00057$)\n\u0005\u0003\u0003&\u0012]E\u0001\u0003BU\t\u0007\u0013\rAa+\t\u0011\u0011mE1\u0011a\u0001\u0003;\u000bAa]8si\"QAq\u0014CB!\u0003\u0005\r!!(\u0002\u0011\u0005\u001cH+\u001e9mKND\u0001\u0002b)\u0005H\u0011\u0005AQU\u0001\u0015G>tg-[4G_Jl\u0015N\\5DYV\u001cH/\u001a:\u0015\u0007\u0019\"9\u000b\u0003\u0004l\tC\u0003\r!\u001c\u0005\u000b\tW#9%%A\u0005\u0002\u00115\u0016aF2p[B\f'/\u001a*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011!\u0019\u0003b,\u0005\u0011\t%F\u0011\u0016b\u0001\u0005W\u0003")
public class BatchTestBase
extends BatchAbstractTestBase {
    private EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
    private TestingTableEnvironment testingTableEnv = TestingTableEnvironment$.MODULE$.create(this.settings(), (Option<CatalogManager>)None$.MODULE$, TableConfig.getDefault());
    private TableEnvironment tEnv = this.testingTableEnv();
    private PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
    private StreamExecutionEnvironment env = this.planner().getExecEnv();
    private TableConfig tableConfig;
    private final Pattern LINE_COL_PATTERN;
    private final Pattern LINE_COL_TWICE_PATTERN;

    public static <T> boolean compareResult$default$4() {
        return BatchTestBase$.MODULE$.compareResult$default$4();
    }

    public static void configForMiniCluster(TableConfig tableConfig) {
        BatchTestBase$.MODULE$.configForMiniCluster(tableConfig);
    }

    public static <T> void compareResult(String[] stringArray, Object object, boolean bl, boolean bl2) {
        BatchTestBase$.MODULE$.compareResult(stringArray, object, bl, bl2);
    }

    public static BinaryRowData binaryRow(LogicalType[] logicalTypeArray, Seq<Object> seq) {
        return BatchTestBase$.MODULE$.binaryRow(logicalTypeArray, seq);
    }

    public static Row row(Seq<Object> seq) {
        return BatchTestBase$.MODULE$.row(seq);
    }

    public EnvironmentSettings settings() {
        return this.settings;
    }

    public void settings_$eq(EnvironmentSettings x$1) {
        this.settings = x$1;
    }

    public TestingTableEnvironment testingTableEnv() {
        return this.testingTableEnv;
    }

    public void testingTableEnv_$eq(TestingTableEnvironment x$1) {
        this.testingTableEnv = x$1;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    public PlannerBase planner() {
        return this.planner;
    }

    public void planner_$eq(PlannerBase x$1) {
        this.planner = x$1;
    }

    public StreamExecutionEnvironment env() {
        return this.env;
    }

    public void env_$eq(StreamExecutionEnvironment x$1) {
        this.env = x$1;
    }

    public TableConfig tableConfig() {
        return this.tableConfig;
    }

    public void tableConfig_$eq(TableConfig x$1) {
        this.tableConfig = x$1;
    }

    public Pattern LINE_COL_PATTERN() {
        return this.LINE_COL_PATTERN;
    }

    public Pattern LINE_COL_TWICE_PATTERN() {
        return this.LINE_COL_TWICE_PATTERN;
    }

    @Before
    public void before() throws Exception {
        BatchTestBase$.MODULE$.configForMiniCluster(this.tableConfig());
    }

    @After
    public void after() {
        TestValuesTableFactory.clearAllData();
    }

    public String explainLogical(Table table) {
        RelNode ast = TableTestUtil$.MODULE$.toRelNode(table);
        String logicalPlan = this.getPlan(ast);
        return new StringBuilder(54).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(FlinkRelOptUtil$.MODULE$.toString(ast, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()))).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(logicalPlan)).toString();
    }

    public void checkResult(String sqlQuery, Seq<Row> expectedResult, boolean isSorted) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkTableResult(Table table, Seq<Row> expectedResult, boolean isSorted) {
        this.checkTable(table, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> this.checkSame(expectedResult, (Seq<Row>)result, isSorted));
    }

    public void checkSize(String sqlQuery, int expectedSize) {
        this.check(sqlQuery, (Function1<Seq<Row>, Option<String>>)(Function1 & Serializable & scala.Serializable)result -> {
            None$ none$;
            if (result.size() != expectedSize) {
                String string = new StringBuilder(23).append("== Correct Result - ").append(expectedSize).append(" ==").toString();
                String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
                String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n               |Results\n               |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult((Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), false).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult((Seq<Row>)result, false).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
                none$ = new Some((Object)errorMessage);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private String getPlan(RelNode relNode) {
        PlannerBase planner = (PlannerBase)((TableEnvironmentImpl)this.tEnv()).getPlanner();
        RelNode optimized = planner.optimize(relNode);
        return FlinkRelOptUtil$.MODULE$.toString(optimized, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7());
    }

    public void check(String sqlQuery, Function1<Seq<Row>, Option<String>> checkFunc) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$check$1(this, sqlQuery, table, results);
            return BoxedUnit.UNIT;
        });
    }

    public boolean checkResult$default$3() {
        return false;
    }

    public void checkTable(Table table, Function1<Seq<Row>, Option<String>> checkFunc) {
        Seq<Row> result = this.executeQuery(table);
        ((Option)checkFunc.apply(result)).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$checkTable$1(this, table, results);
            return BoxedUnit.UNIT;
        });
    }

    public boolean checkTableResult$default$3() {
        return false;
    }

    public void checkFailed(String sqlQuery, String expectedMsgPattern) {
        block25: {
            try {
                Table table = this.parseQuery(sqlQuery);
                Seq<Row> _ = this.executeQuery(table);
                if (expectedMsgPattern != null) {
                    throw new AssertionError((Object)new StringBuilder(50).append("Expected query to throw exception, but it did not;").append(new StringBuilder(11).append(" query [").append(sqlQuery).append(" ];").toString()).append(new StringBuilder(12).append(" expected [").append(expectedMsgPattern).append("]").toString()).toString());
                }
            }
            catch (SqlParserException spe) {
                String errMsg = spe.getMessage();
                if (expectedMsgPattern == null) {
                    throw new RuntimeException(new StringBuilder(27).append("Error while parsing query: ").append(sqlQuery).toString(), spe);
                }
                if (errMsg == null || !errMsg.matches(expectedMsgPattern)) {
                    throw new RuntimeException(new StringBuilder(38).append("Error did not match expected [").append(expectedMsgPattern).append("] while ").append(new StringBuilder(16).append("parsing query [").append(sqlQuery).append("]").toString()).toString(), spe);
                }
            }
            catch (Throwable thrown) {
                Throwable actualExp = thrown;
                String actualMsg = actualExp.getMessage();
                int actualLine = -1;
                int actualColumn = -1;
                int actualEndLine = 100;
                int actualEndColumn = 99;
                CalciteContextException ece = null;
                SqlParseException spe = null;
                Throwable ex = actualExp;
                boolean found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    Throwable throwable = ex;
                    if (throwable instanceof CalciteContextException) {
                        CalciteContextException calciteContextException;
                        ece = calciteContextException = (CalciteContextException)throwable;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        Throwable throwable3 = throwable2.getCause();
                        Throwable throwable4 = ex;
                        if (!(throwable3 != null ? !throwable3.equals(throwable4) : throwable4 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                ex = actualExp;
                found = false;
                while (ex != null && !found) {
                    BoxedUnit boxedUnit;
                    SqlParseException sqlParseException;
                    Throwable throwable = ex;
                    if (throwable instanceof SqlParseException && (sqlParseException = (SqlParseException)throwable).getPos() != null) {
                        spe = sqlParseException;
                        found = true;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (throwable != null) {
                        Throwable throwable5 = throwable;
                        Throwable throwable6 = throwable5.getCause();
                        Throwable throwable7 = ex;
                        if (!(throwable6 != null ? !throwable6.equals(throwable7) : throwable7 != null)) {
                            found = true;
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                    }
                    ex = ex.getCause();
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (ece != null) {
                    actualLine = ece.getPosLine();
                    actualColumn = ece.getPosColumn();
                    actualEndLine = ece.getEndPosLine();
                    actualEndColumn = ece.getEndPosColumn();
                    if (ece.getCause() != null) {
                        actualExp = ece.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else if (spe != null) {
                    actualLine = spe.getPos().getLineNum();
                    actualColumn = spe.getPos().getColumnNum();
                    actualEndLine = spe.getPos().getEndLineNum();
                    actualEndColumn = spe.getPos().getEndColumnNum();
                    if (spe.getCause() != null) {
                        actualExp = spe.getCause();
                        actualMsg = actualExp.getMessage();
                    }
                } else {
                    String message = actualMsg;
                    if (message != null) {
                        Matcher matcher = this.LINE_COL_TWICE_PATTERN().matcher(message);
                        if (matcher.matches()) {
                            actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                            actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            actualEndLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(3))).toInt();
                            actualEndColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(4))).toInt();
                            actualMsg = matcher.group(5);
                        } else {
                            matcher = this.LINE_COL_PATTERN().matcher(message);
                            if (matcher.matches()) {
                                actualLine = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toInt();
                                actualColumn = new StringOps(Predef$.MODULE$.augmentString(matcher.group(2))).toInt();
                            }
                        }
                    }
                }
                if (expectedMsgPattern == null) {
                    actualExp.printStackTrace();
                    Assert.fail((String)new StringBuilder(47).append("Validator threw unexpected exception; query [").append(sqlQuery).append("];").append(new StringBuilder(33).append(" exception [").append(actualMsg).append("]; class [").append(actualExp).append(".getClass];").toString()).append(new StringBuilder(33).append(" pos [line ").append(actualLine).append(" col ").append(actualColumn).append(" thru line ").append(actualLine).append(" col ").append(actualColumn).append("]").toString()).toString());
                }
                if (actualMsg != null && actualMsg.matches(expectedMsgPattern)) break block25;
                actualExp.printStackTrace();
                Assert.fail((String)new StringBuilder(26).append("Validator threw different ").append(new StringBuilder(35).append("exception than expected; query [").append(sqlQuery).append("];\n").toString()).append(new StringBuilder(22).append(" expected pattern [").append(expectedMsgPattern).append("];\n").toString()).append(new StringBuilder(12).append(" actual [").append(actualMsg).append("];\n").toString()).append(new StringBuilder(6).append(" pos [").append(actualLine).toString()).append(new StringBuilder(5).append(" col ").append(actualColumn).toString()).append(new StringBuilder(11).append(" thru line ").append(actualEndLine).toString()).append(new StringBuilder(7).append(" col ").append(actualEndColumn).append("].").toString()).toString());
            }
        }
    }

    public void checkEmptyResult(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        Seq<Row> result = this.executeQuery(table);
        this.checkEmpty(result).foreach((Function1 & Serializable & scala.Serializable)results -> {
            BatchTestBase.$anonfun$checkEmptyResult$1(results);
            return BoxedUnit.UNIT;
        });
    }

    public Table parseQuery(String sqlQuery) {
        return this.tEnv().sqlQuery(sqlQuery);
    }

    public Seq<Row> executeQuery(Table table) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(CollectionUtil.iteratorToList((Iterator)table.execute().collect())).asScala();
    }

    public Seq<Row> executeQuery(String sqlQuery) {
        Table table = this.parseQuery(sqlQuery);
        return this.executeQuery(table);
    }

    private Seq<String> prepareResult(Seq<Row> seq, boolean isSorted) {
        return !isSorted ? (Seq)((SeqLike)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)s -> s, (Ordering)Ordering.String$.MODULE$) : (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> checkSame(Seq<Row> expectedResult, Seq<Row> result, boolean isSorted) {
        None$ none$;
        if (expectedResult.size() != result.size() || !this.prepareResult(expectedResult, isSorted).equals(this.prepareResult(result, isSorted))) {
            String string = new StringBuilder(23).append("== Correct Result - ").append(expectedResult.size()).append(" ==").toString();
            String string2 = new StringBuilder(22).append("== Actual Result - ").append(result.size()).append(" ==").toString();
            String errorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(42).append("\n           |Results\n           |").append(this.sideBySide((Seq<String>)((Seq)this.prepareResult(expectedResult, isSorted).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)this.prepareResult(result, isSorted).$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom()))).mkString("\n")).append("\n        ").toString())).stripMargin();
            none$ = new Some((Object)errorMessage);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean checkSame$default$3() {
        return false;
    }

    private Option<String> checkEmpty(Seq<Row> result) {
        Nil$ expectedResult = Nil$.MODULE$;
        return this.checkSame((Seq<Row>)expectedResult, result, true);
    }

    private Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)left.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.length()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        Seq rightPadded = (Seq)right.$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(scala.math.package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable & scala.Serializable)() -> ""), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)leftPadded.zip((GenIterable)rightPadded, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = l;
            String string2 = r;
            String string3 = new StringBuilder(0).append(!(string == null ? string2 != null : !string.equals(string2)) || l.startsWith("== Correct") ? " " : "!").append(l).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(maxLeftSize - l.length() + 3)).append(r).toString();
            return string3;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void registerCollection(String tableName, Iterable<Row> data, TypeInformation<Row> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields);
    }

    public <T> void registerJavaCollection(String tableName, java.lang.Iterable<T> data, TypeInformation<T> typeInfo, String fields) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala(), typeInfo, fields);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public <T> void registerCollection(String tableName, Iterable<T> data, TypeInformation<T> typeInfo, String fields, boolean[] fieldNullables, FlinkStatistic statistic) {
        BatchTableEnvUtil$.MODULE$.registerCollection(this.tEnv(), tableName, data, typeInfo, fields, fieldNullables, (Option<FlinkStatistic>)new Some((Object)statistic));
    }

    public void registerTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        this.testingTableEnv().createTemporarySystemFunction(name, functionClass);
    }

    public void registerFunction(String name, ScalarFunction function) {
        this.testingTableEnv().registerFunction(name, function);
    }

    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$1, TypeInformation<ACC> evidence$2) {
        this.testingTableEnv().registerFunction(name, f, evidence$1, evidence$2);
    }

    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        this.testingTableEnv().registerFunction(name, tf, evidence$3);
    }

    public void registerRange(String name, long end) {
        this.registerRange(name, 0L, end);
    }

    public void registerRange(String name, long start, long end) {
        BatchTableEnvUtil$.MODULE$.registerBoundedStreamInternal(this.tEnv(), name, this.newRangeSource(start, end), (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)}), (Option<boolean[]>)None$.MODULE$, (Option<FlinkStatistic>)None$.MODULE$);
    }

    public DataStream<RowData> newRangeSource(long start, long end) {
        InternalTypeInfo typeInfo = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new BigIntType()});
        DataStreamSource boundedStream = this.env().createInput((InputFormat)new RangeInputFormat(start, end), (TypeInformation)typeInfo);
        boundedStream.setParallelism(1);
        return boundedStream;
    }

    /*
     * WARNING - void declaration
     */
    public Row rowOf(Seq<Object> args) {
        void var2_2;
        Row row = new Row(args.length());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), args.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setField(i, args.apply(i)));
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$check$1(BatchTestBase $this, String sqlQuery$1, Table table$2, String results) {
        String plan = $this.explainLogical(table$2);
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(173).append("\n                       |Results do not match for query:\n                       |  ").append(sqlQuery$1).append("\n                       |").append(results).append("\n                       |Plan:\n                       |  ").append(plan).append("\n       ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$checkTable$1(BatchTestBase $this, Table table$1, String results) {
        String plan = $this.explainLogical(table$1);
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n                       |Results do not match:\n                       |").append(results).append("\n                       |Plan:\n                       |  ").append(plan).append("\n       ").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$checkEmptyResult$1(String results) {
        Assert.fail((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n                       |Results do not match for query:\n                       |").append(results).append("\n       ").toString())).stripMargin());
    }

    public BatchTestBase() {
        this.env().getConfig().enableObjectReuse();
        this.tableConfig = this.tEnv().getConfig();
        this.LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
        this.LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");
    }
}

