/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.util.Preconditions;

public class FilterUtils {
    public static boolean shouldPushDown(ResolvedExpression expr, Set<String> filterableFields) {
        if (expr instanceof CallExpression && expr.getChildren().size() == 2) {
            return FilterUtils.shouldPushDownUnaryExpression((ResolvedExpression)expr.getResolvedChildren().get(0), filterableFields) && FilterUtils.shouldPushDownUnaryExpression((ResolvedExpression)expr.getResolvedChildren().get(1), filterableFields);
        }
        return false;
    }

    public static boolean isRetainedAfterApplyingFilterPredicates(List<ResolvedExpression> predicates, Function<String, Comparable<?>> getter) {
        for (ResolvedExpression predicate : predicates) {
            if (predicate instanceof CallExpression) {
                FunctionDefinition definition = ((CallExpression)predicate).getFunctionDefinition();
                boolean result = false;
                if (definition.equals(BuiltInFunctionDefinitions.OR)) {
                    for (Expression expr : predicate.getChildren()) {
                        if (!(expr instanceof CallExpression) || expr.getChildren().size() != 2) {
                            throw new TableException(expr + " not supported!");
                        }
                        result = FilterUtils.binaryFilterApplies((CallExpression)expr, getter);
                        if (!result) continue;
                        break;
                    }
                } else if (predicate.getChildren().size() == 2) {
                    result = FilterUtils.binaryFilterApplies((CallExpression)predicate, getter);
                } else {
                    throw new UnsupportedOperationException(String.format("Unsupported expr: %s.", predicate));
                }
                if (result) continue;
                return false;
            }
            throw new UnsupportedOperationException(String.format("Unsupported expr: %s.", predicate));
        }
        return true;
    }

    private static boolean shouldPushDownUnaryExpression(ResolvedExpression expr, Set<String> filterableFields) {
        if (!FilterUtils.isComparable(expr.getOutputDataType().getConversionClass())) {
            return false;
        }
        if (expr instanceof FieldReferenceExpression && filterableFields.contains(((FieldReferenceExpression)expr).getName())) {
            return true;
        }
        if (expr instanceof ValueLiteralExpression) {
            return true;
        }
        if (expr instanceof CallExpression && expr.getChildren().size() == 1 && (((CallExpression)expr).getFunctionDefinition().equals(BuiltInFunctionDefinitions.UPPER) || ((CallExpression)expr).getFunctionDefinition().equals(BuiltInFunctionDefinitions.LOWER))) {
            return FilterUtils.shouldPushDownUnaryExpression((ResolvedExpression)expr.getResolvedChildren().get(0), filterableFields);
        }
        return false;
    }

    private static boolean binaryFilterApplies(CallExpression binExpr, Function<String, Comparable<?>> getter) {
        List children = binExpr.getChildren();
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0);
        Comparable<?> lhsValue = FilterUtils.getValue((Expression)children.get(0), getter);
        Comparable<?> rhsValue = FilterUtils.getValue((Expression)children.get(1), getter);
        FunctionDefinition functionDefinition = binExpr.getFunctionDefinition();
        if (BuiltInFunctionDefinitions.GREATER_THAN.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) > 0;
        }
        if (BuiltInFunctionDefinitions.LESS_THAN.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) < 0;
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) >= 0;
        }
        if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) <= 0;
        }
        if (BuiltInFunctionDefinitions.EQUALS.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) == 0;
        }
        if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(functionDefinition)) {
            return lhsValue.compareTo(rhsValue) != 0;
        }
        throw new UnsupportedOperationException("Unsupported operator: " + functionDefinition);
    }

    private static boolean isComparable(Class<?> clazz) {
        return Comparable.class.isAssignableFrom(clazz);
    }

    private static Comparable<?> getValue(Expression expr, Function<String, Comparable<?>> getter) {
        if (expr instanceof ValueLiteralExpression) {
            Optional value = ((ValueLiteralExpression)expr).getValueAs(((ValueLiteralExpression)expr).getOutputDataType().getConversionClass());
            return value.orElse(null);
        }
        if (expr instanceof FieldReferenceExpression) {
            return getter.apply(((FieldReferenceExpression)expr).getName());
        }
        if (expr instanceof CallExpression && expr.getChildren().size() == 1) {
            Comparable<?> child = FilterUtils.getValue((Expression)expr.getChildren().get(0), getter);
            FunctionDefinition functionDefinition = ((CallExpression)expr).getFunctionDefinition();
            if (functionDefinition.equals(BuiltInFunctionDefinitions.UPPER)) {
                return child.toString().toUpperCase();
            }
            if (functionDefinition.equals(BuiltInFunctionDefinitions.LOWER)) {
                return child.toString().toLowerCase();
            }
            throw new UnsupportedOperationException(String.format("Unrecognized function definition: %s.", functionDefinition));
        }
        throw new UnsupportedOperationException(expr + " not supported!");
    }
}

