/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;

public final class LogicalCorrelate
extends Correlate {
    public LogicalCorrelate(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        super(cluster, traitSet, hints, left, right, correlationId, requiredColumns, joinType);
        assert (!CalciteSystemProperty.DEBUG.value().booleanValue() || this.isValid(Litmus.THROW, null));
    }

    public LogicalCorrelate(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        this(cluster, traitSet, Collections.emptyList(), left, right, correlationId, requiredColumns, joinType);
    }

    public LogicalCorrelate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)input.get("correlation")), input.getBitSet("requiredColumns"), input.getEnum("joinType", JoinRelType.class));
    }

    public static LogicalCorrelate create(RelNode left, RelNode right, List<RelHint> hints, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalCorrelate(cluster, traitSet, hints, left, right, correlationId, requiredColumns, joinType);
    }

    public static LogicalCorrelate create(RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalCorrelate(cluster, traitSet, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public LogicalCorrelate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalCorrelate(this.getCluster(), traitSet, this.hints, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalCorrelate(this.getCluster(), this.traitSet, hintList, this.left, this.right, this.correlationId, this.requiredColumns, this.joinType);
    }
}

