/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlTimestampAddFunction
extends SqlFunction {
    private static final int MILLISECOND_PRECISION = 3;
    private static final int MICROSECOND_PRECISION = 6;
    private static final SqlReturnTypeInference RETURN_TYPE_INFERENCE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return SqlTimestampAddFunction.deduceType(typeFactory, opBinding.getOperandLiteralValue(0, TimeUnit.class), opBinding.getOperandType(1), opBinding.getOperandType(2));
    };

    public static RelDataType deduceType(RelDataTypeFactory typeFactory, TimeUnit timeUnit, RelDataType intervalType, RelDataType datetimeType) {
        RelDataType type;
        switch (timeUnit) {
            case MILLISECOND: {
                type = typeFactory.createSqlType(SqlTimestampAddFunction.timestampOrTimestampLtz(datetimeType), Math.max(3, datetimeType.getPrecision()));
                break;
            }
            case MICROSECOND: {
                type = typeFactory.createSqlType(SqlTimestampAddFunction.timestampOrTimestampLtz(datetimeType), Math.max(6, datetimeType.getPrecision()));
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                if (datetimeType.getFamily() == SqlTypeFamily.TIME) {
                    type = datetimeType;
                    break;
                }
                if (datetimeType.getFamily() == SqlTypeFamily.TIMESTAMP) {
                    type = typeFactory.createSqlType(SqlTimestampAddFunction.timestampOrTimestampLtz(datetimeType), datetimeType.getPrecision());
                    break;
                }
                type = typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            default: {
                type = datetimeType;
            }
        }
        return typeFactory.createTypeWithNullability(type, intervalType.isNullable() || datetimeType.isNullable());
    }

    private static SqlTypeName timestampOrTimestampLtz(RelDataType datetimeType) {
        return datetimeType.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE : SqlTypeName.TIMESTAMP;
    }

    SqlTimestampAddFunction() {
        super("TIMESTAMPADD", SqlKind.TIMESTAMP_ADD, RETURN_TYPE_INFERENCE, null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER, SqlTypeFamily.DATETIME), SqlFunctionCategory.TIMEDATE);
    }
}

