/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.ConstructedToConstructedCastRule;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class ArrayToArrayCastRule
extends AbstractNullAwareCodeGeneratorCastRule<ArrayData, ArrayData>
implements ConstructedToConstructedCastRule<ArrayData, ArrayData> {
    static final ArrayToArrayCastRule INSTANCE = new ArrayToArrayCastRule();

    private ArrayToArrayCastRule() {
        super(CastRulePredicate.builder().predicate((input, target) -> input.is(LogicalTypeRoot.ARRAY) && target.is(LogicalTypeRoot.ARRAY) && ArrayToArrayCastRule.isValidArrayCasting(((ArrayType)input).getElementType(), ((ArrayType)target).getElementType())).build());
    }

    private static boolean isValidArrayCasting(LogicalType innerInputType, LogicalType innerTargetType) {
        return CastRuleProvider.resolve(innerInputType, innerTargetType) != null;
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        LogicalType innerInputType = ((ArrayType)inputLogicalType).getElementType();
        LogicalType innerTargetType = ((ArrayType)targetLogicalType).getElementType();
        String innerTargetTypeTerm = ArrayToArrayCastRule.arrayElementType(innerTargetType);
        String arraySize = CastRuleUtils.methodCall(inputTerm, "size", new Object[0]);
        String objArrayTerm = CodeGenUtils.newName("objArray");
        return new CastRuleUtils.CodeWriter().declStmt(innerTargetTypeTerm + "[]", objArrayTerm, CastRuleUtils.newArray(innerTargetTypeTerm, arraySize)).forStmt(arraySize, (index, loopWriter) -> {
            CastCodeBlock codeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, CodeGenUtils.rowFieldReadAccess(index, inputTerm, innerInputType), innerInputType, innerTargetType);
            if (innerTargetType.isNullable()) {
                loopWriter.ifStmt("!" + CastRuleUtils.methodCall(inputTerm, "isNullAt", index), thenWriter -> thenWriter.append(codeBlock).assignArrayStmt(objArrayTerm, (String)index, codeBlock.getReturnTerm()));
            } else {
                loopWriter.append(codeBlock).assignArrayStmt(objArrayTerm, (String)index, codeBlock.getReturnTerm());
            }
        }).assignStmt(returnVariable, CastRuleUtils.constructorCall(GenericArrayData.class, objArrayTerm)).toString();
    }

    private static String arrayElementType(LogicalType t) {
        if (t.isNullable()) {
            return CodeGenUtils.boxedTypeTermForType(t);
        }
        return CodeGenUtils.primitiveTypeTermForType(t);
    }
}

