/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;

public abstract class FlinkHints {
    public static final String HINT_NAME_OPTIONS = "OPTIONS";
    public static final String HINT_ALIAS = "ALIAS";
    public static final String HINT_NAME_JSON_AGGREGATE_WRAPPED = "JSON_AGGREGATE_WRAPPED";

    public static Map<String, String> getHintedOptions(List<RelHint> tableHints) {
        return tableHints.stream().filter(hint -> hint.hintName.equalsIgnoreCase(HINT_NAME_OPTIONS)).findFirst().map(hint -> hint.kvOptions).orElse(Collections.emptyMap());
    }

    public static Map<String, String> mergeTableOptions(Map<String, String> hints, Map<String, String> props) {
        if (hints.size() == 0) {
            return props;
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.putAll(props);
        newProps.putAll(hints);
        return Collections.unmodifiableMap(newProps);
    }

    public static Optional<String> getTableAlias(RelNode node) {
        if (node instanceof Hintable) {
            Hintable aliasNode = (Hintable)((Object)node);
            List aliasNames = aliasNode.getHints().stream().filter(h -> h.hintName.equalsIgnoreCase(HINT_ALIAS)).flatMap(h -> h.listOptions.stream()).collect(Collectors.toList());
            if (aliasNames.size() > 0) {
                return Optional.of(aliasNames.get(0));
            }
            if (FlinkHints.canTransposeToTableScan(node)) {
                return FlinkHints.getTableAlias(node.getInput(0));
            }
        }
        return Optional.empty();
    }

    public static boolean canTransposeToTableScan(RelNode node) {
        return node instanceof LogicalProject || node instanceof LogicalFilter || node instanceof LogicalSnapshot;
    }

    public static Optional<String> getTableName(RelOptTable table) {
        if (table == null) {
            return Optional.empty();
        }
        if (!(table instanceof FlinkPreparingTableBase)) {
            throw new TableException(String.format("Could not get the table name with the unknown table class `%s`", table.getClass().getCanonicalName()));
        }
        String tableName = StringUtils.join(((FlinkPreparingTableBase)table).getNames(), (char)'.');
        return Optional.of(tableName);
    }

    public static String stringifyHints(List<RelHint> hints) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (RelHint h : hints) {
            if (h.hintName.equalsIgnoreCase(HINT_ALIAS)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(h.hintName);
            if (h.listOptions.size() > 0) {
                String listStr = h.listOptions.stream().collect(Collectors.joining(",", "(", ")"));
                sb.append(listStr);
            } else if (h.kvOptions.size() > 0) {
                String mapStr = h.kvOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "(", ")"));
                sb.append(mapStr);
            }
            first = false;
        }
        return sb.toString();
    }

    public static List<RelHint> getAllJoinHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName)).collect(Collectors.toList());
    }

    public static List<RelHint> getQueryBlockAliasHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> hint.hintName.equals(HINT_ALIAS)).collect(Collectors.toList());
    }

    public static RelNode capitalizeJoinHints(RelNode root) {
        return root.accept(new CapitalizeJoinHintShuttle());
    }

    private static class CapitalizeJoinHintShuttle
    extends RelShuttleImpl {
        private CapitalizeJoinHintShuttle() {
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            ImmutableList<RelHint> hints = join.getHints();
            AtomicBoolean changed = new AtomicBoolean(false);
            List<RelHint> hintsWithCapitalJoinHints = hints.stream().map(hint -> {
                String capitalHintName = hint.hintName.toUpperCase(Locale.ROOT);
                if (JoinStrategy.isJoinStrategy(capitalHintName)) {
                    changed.set(true);
                    return RelHint.builder(capitalHintName).hintOptions(hint.listOptions).inheritPath(hint.inheritPath).build();
                }
                return hint;
            }).collect(Collectors.toList());
            if (changed.get()) {
                return super.visit(join.withHints(hintsWithCapitalJoinHints));
            }
            return super.visit(join);
        }
    }
}

