/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.common;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.MatchRecognize;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import scala.Enumeration;
import scala.Function4;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.List;

public abstract class CommonPhysicalMatch
extends SingleRel
implements FlinkPhysicalRel {
    private final MatchRecognize logicalMatch;
    private final RelDataType outputRowType;

    public CommonPhysicalMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, MatchRecognize logicalMatch, RelDataType outputRowType) {
        super(cluster, traitSet, inputNode);
        if (logicalMatch.measures().values().stream().anyMatch(m -> PythonUtil.containsPythonCall(m, null)) || logicalMatch.patternDefinitions().values().stream().anyMatch(p -> PythonUtil.containsPythonCall(p, null))) {
            throw new TableException("Python Function can not be used in MATCH_RECOGNIZE for now.");
        }
        this.logicalMatch = logicalMatch;
        this.outputRowType = outputRowType;
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.outputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelDataType inputRowType = this.getInput().getRowType();
        Seq fieldNames = (Seq)JavaConverters.asScalaBufferConverter(inputRowType.getFieldNames()).asScala();
        return super.explainTerms(pw).itemIf("partitionBy", RelExplainUtil.fieldToString(this.logicalMatch.partitionKeys().toArray(), inputRowType), !this.logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", RelExplainUtil.collationToString(this.logicalMatch.orderKeys(), inputRowType), !this.logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", RelExplainUtil.measuresDefineToString(this.logicalMatch.measures(), (List<String>)fieldNames.toList(), (Function4<RexNode, List<String>, Option<List<RexNode>>, Enumeration.Value, String>)((Function4)this::getExpressionString), this.convertToExpressionDetail(pw.getDetailLevel())), !this.logicalMatch.measures().isEmpty()).item("rowsPerMatch", RelExplainUtil.rowsPerMatchToString(this.logicalMatch.allRows())).item("after", RelExplainUtil.afterMatchToString(this.logicalMatch.after(), (Seq<String>)fieldNames)).item("pattern", this.logicalMatch.pattern().toString()).itemIf("subset", RelExplainUtil.subsetToString(this.logicalMatch.subsets()), !this.logicalMatch.subsets().isEmpty()).item("define", this.logicalMatch.patternDefinitions());
    }

    public MatchRecognize getLogicalMatch() {
        return this.logicalMatch;
    }
}

