/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.time.DayOfWeek;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class FlinkTypeFactoryTest {
    FlinkTypeFactoryTest() {
    }

    static Stream<LogicalType> testInternalToRelType() {
        return Stream.of(new BooleanType(), new TinyIntType(), VarCharType.STRING_TYPE, new DoubleType(), new FloatType(), new IntType(), new BigIntType(), new SmallIntType(), new VarBinaryType(Integer.MAX_VALUE), new DateType(), new TimeType(), new TimestampType(3), new LocalZonedTimestampType(3), new ArrayType((LogicalType)new DoubleType()), new MapType((LogicalType)new DoubleType(), (LogicalType)VarCharType.STRING_TYPE), RowType.of((LogicalType[])new LogicalType[]{new DoubleType(), VarCharType.STRING_TYPE}), new RawType(DayOfWeek.class, (TypeSerializer)new KryoSerializer(DayOfWeek.class, new ExecutionConfig())));
    }

    @MethodSource(value={"testInternalToRelType"})
    @ParameterizedTest
    void testInternalToRelType(LogicalType logicalType) {
        FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(true)))).isEqualTo((Object)logicalType.copy(true));
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(false)))).isEqualTo((Object)logicalType.copy(false));
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(true)))).isEqualTo((Object)logicalType.copy(true));
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(false)))).isEqualTo((Object)logicalType.copy(false));
    }

    @Test
    void testInternalToRelTypeNull() {
        FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        NullType logicalType = new NullType();
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(true)))).isEqualTo((Object)logicalType.copy(true));
        Assertions.assertThat((Object)FlinkTypeFactory.toLogicalType((RelDataType)typeFactory.createFieldTypeFromLogicalType(logicalType.copy(true)))).isEqualTo((Object)logicalType.copy(true));
    }

    @Test
    void testDecimalInferType() {
        Assertions.assertThat((Object)LogicalTypeMerging.findSumAggType((LogicalType)new DecimalType(10, 5))).isEqualTo((Object)new DecimalType(38, 5));
        Assertions.assertThat((Object)LogicalTypeMerging.findAvgAggType((LogicalType)new DecimalType(10, 5))).isEqualTo((Object)new DecimalType(38, 6));
    }

    @Test
    void testCanonizeType() {
        FlinkTypeFactory typeFactory = new FlinkTypeFactory(Thread.currentThread().getContextClassLoader(), (RelDataTypeSystem)FlinkTypeSystem.INSTANCE);
        TypeInformation genericTypeInfo = Types.GENERIC(TestClass.class);
        TypeInformation genericTypeInfo2 = Types.GENERIC(TestClass2.class);
        RelDataType genericRelType = typeFactory.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(genericTypeInfo));
        RelDataType genericRelType2 = typeFactory.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(genericTypeInfo));
        RelDataType genericRelType3 = typeFactory.createFieldTypeFromLogicalType((LogicalType)new TypeInformationRawType(genericTypeInfo2));
        ((ObjectAssert)Assertions.assertThat((Object)genericRelType).as("The type expect to be canonized", new Object[0])).isEqualTo((Object)genericRelType2);
        ((ObjectAssert)Assertions.assertThat((Object)genericRelType).as("The type expect to be not canonized", new Object[0])).isNotEqualTo((Object)genericRelType3);
        ((ObjectAssert)Assertions.assertThat((Object)typeFactory.builder().add("f0", genericRelType).build()).as("The type expect to be not canonized", new Object[0])).isNotEqualTo((Object)typeFactory.builder().add("f0", genericRelType3).build());
    }

    public static class TestClass2 {
        public int f0;
        public String f1;
    }

    public static class TestClass {
        public int f0;
        public String f1;
    }
}

