/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.time.LocalDate;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;

class CollectionFunctionsITCase
extends BuiltInFunctionTestBase {
    CollectionFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.ARRAY_CONTAINS).onFieldsWithData(new Integer[]{1, 2, 3}, null, new String[]{"Hello", "World"}, new Row[]{Row.of((Object[])new Object[]{true, LocalDate.of(2022, 4, 20)}), Row.of((Object[])new Object[]{true, LocalDate.of(1990, 10, 14)}), null}, new Integer[]{1, null, 3}).andDataTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.INT()), DataTypes.ARRAY((DataType)DataTypes.STRING()).notNull(), DataTypes.ARRAY((DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.DATE()})), DataTypes.ARRAY((DataType)DataTypes.INT())}).testResult((Expression)Expressions.$((String)"f0").arrayContains((Object)2), "ARRAY_CONTAINS(f0, 2)", true, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f0").arrayContains((Object)42), "ARRAY_CONTAINS(f0, 42)", false, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f1").arrayContains((Object)12), "ARRAY_CONTAINS(f1, 12)", null, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f1").arrayContains(null), "ARRAY_CONTAINS(f1, NULL)", null, DataTypes.BOOLEAN().nullable()).testResult((Expression)Expressions.$((String)"f2").arrayContains((Object)"Hello"), "ARRAY_CONTAINS(f2, 'Hello')", true, DataTypes.BOOLEAN().notNull()).testResult((Expression)Expressions.$((String)"f3").arrayContains((Object)Expressions.row((Object)true, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_CONTAINS(f3, (TRUE, DATE '1990-10-14'))", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").arrayContains((Object)Expressions.row((Object)false, (Object[])new Object[]{LocalDate.of(1990, 10, 14)})), "ARRAY_CONTAINS(f3, (FALSE, DATE '1990-10-14'))", false, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f3").arrayContains(null), "ARRAY_CONTAINS(f3, null)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.$((String)"f4").arrayContains(null), "ARRAY_CONTAINS(f4, NULL)", true, DataTypes.BOOLEAN().nullable()).testSqlValidationError("ARRAY_CONTAINS(f0, TRUE)", "Invalid input arguments. Expected signatures are:\nARRAY_CONTAINS(haystack <ARRAY>, needle <ARRAY ELEMENT>)").testTableApiValidationError((Expression)Expressions.$((String)"f0").arrayContains((Object)true), "Invalid input arguments. Expected signatures are:\nARRAY_CONTAINS(haystack <ARRAY>, needle <ARRAY ELEMENT>)"));
    }
}

