/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInAggregateFunctionTestBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;

class JsonAggregationFunctionsITCase
extends BuiltInAggregateFunctionTestBase {
    JsonAggregationFunctionsITCase() {
    }

    @Override
    public Stream<BuiltInAggregateFunctionTestBase.TestSpec> getTestCaseSpecs() {
        return Stream.of(BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECTAGG_NULL_ON_NULL).withDescription("Basic Aggregation").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A", 1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C", 3}))).testResult(source -> "SELECT JSON_OBJECTAGG(f0 VALUE f1) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"{\"A\":1,\"B\":null,\"C\":3}"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECTAGG_ABSENT_ON_NULL).withDescription("Omits NULLs").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A", 1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C", 3}))).testResult(source -> "SELECT JSON_OBJECTAGG(f0 VALUE f1 ABSENT ON NULL) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.ABSENT, (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"{\"A\":1,\"C\":3}"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECTAGG_NULL_ON_NULL).withDescription("Retractions").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A", 1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"B", 2}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C", 3}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{"B", 2}))).testResult(source -> "SELECT JSON_OBJECTAGG(f0 VALUE f1) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"{\"A\":1,\"C\":3}"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_OBJECTAGG_NULL_ON_NULL).withDescription("Group Aggregation").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING(), DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, "A", 0}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, "B", 0}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2, "A", 0}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2, "C", 0}))).testResult(source -> "SELECT f0, JSON_OBJECTAGG(f1 VALUE f2) FROM " + source + " GROUP BY f0", source -> source.groupBy(new Expression[]{Expressions.$((String)"f0")}).select(new Expression[]{Expressions.$((String)"f0"), Expressions.jsonObjectAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"))}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), (DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), (DataType)DataTypes.STRING().notNull()}), Arrays.asList(Row.of((Object[])new Object[]{1, "{\"A\":0,\"B\":0}"}), Row.of((Object[])new Object[]{2, "{\"A\":0,\"C\":0}"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_ARRAYAGG_ABSENT_ON_NULL).withDescription("Basic Aggregation").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C"}))).testResult(source -> "SELECT JSON_ARRAYAGG(f0) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonArrayAgg((JsonOnNull)JsonOnNull.ABSENT, (Object)Expressions.$((String)"f0"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"[\"A\",\"C\"]"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_ARRAYAGG_NULL_ON_NULL).withDescription("Keeps NULLs").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.STRING()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"A"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{null}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"C"}))).testResult(source -> "SELECT JSON_ARRAYAGG(f0 NULL ON NULL) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonArrayAgg((JsonOnNull)JsonOnNull.NULL, (Object)Expressions.$((String)"f0"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"[\"A\",null,\"C\"]"}))), BuiltInAggregateFunctionTestBase.TestSpec.forFunction(BuiltInFunctionDefinitions.JSON_ARRAYAGG_ABSENT_ON_NULL).withDescription("Retractions").withSource(DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()}), Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{3}), Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2}))).testResult(source -> "SELECT JSON_ARRAYAGG(f0) FROM " + source, source -> source.select(new Expression[]{Expressions.jsonArrayAgg((JsonOnNull)JsonOnNull.ABSENT, (Object)Expressions.$((String)"f0"))}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.VARCHAR((int)2000).notNull()}), DataTypes.ROW((DataType[])new DataType[]{(DataType)DataTypes.STRING().notNull()}), Collections.singletonList(Row.of((Object[])new Object[]{"[1,3]"}))));
    }
}

