/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001M\u0011\u0011$T;mi&\u0004H.Z%oaV$8I]3bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0017MDWO\u001a4mK6{G-\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0011\r\u0003\r\t\u0007/[\u0005\u0003Gy\u0011\u0001CQ1uG\"\u001c\u0006.\u001e4gY\u0016lu\u000eZ3\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u001cI\u0001\u0007A\u0004C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\u0002\tU$\u0018\u000e\\\u000b\u0002[A\u0011QCL\u0005\u0003_Y\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1\u0011\u0007\u0001Q\u0001\n5\nQ!\u001e;jY\u0002BQa\r\u0001\u0005\u0002Q\naAY3g_J,G#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003eq\u0002\"!\u0010!\u000e\u0003yR!a\u0010\t\u0002\u000b),h.\u001b;\n\u0005\u0005s$A\u0002\"fM>\u0014X\rC\u0003D\u0001\u0011\u0005A'\u0001\fuKN$()Y:jG6+H\u000e^5qY\u0016Le\u000e];uQ\t\u0011U\t\u0005\u0002>\r&\u0011qI\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003J\u0001\u0011\u0005A'\u0001\fuKN$X*\u00198z\u001bVdG/\u001b9mK&s\u0007/\u001e;tQ\tAU\tC\u0003M\u0001\u0011\u0005A'\u0001\fuKN$(j\\5o/&$\b.Q4h\u0003N\u0004&o\u001c2fQ\tYU\tC\u0003P\u0001\u0011\u0005A'\u0001\u001buKN$8*Z3q\u001bVdG/\u001b9mK&s\u0007/\u001e;XSRDwJ\\3NK6\u0014WM\u001d$pe\u000eC\u0017-\u001b8bE2,7k\\;sG\u0016D#AT#\t\u000bI\u0003A\u0011\u0001\u001b\u0002IQ,7\u000f^!w_&$\u0017J\\2mk\u0012LgnZ+oS>tgI]8n\u0013:\u0004X\u000f^*jI\u0016D#!U#\t\u000bU\u0003A\u0011\u0001\u001b\u0002EQ,7\u000f^%oG2,H-Z+oS>tgi\u001c:DQ\u0006Lg.\u00192mKN{WO]2fQ\t!V\tC\u0003Y\u0001\u0011\u0005A'A\u0017uKN$\u0018I^8jI&s7\r\\;eS:<7)\u00197d\u0003\u001a$XM\u001d(p]\u000eC\u0017-\u001b8bE2,7k\\;sG\u0016D#aV#\t\u000bm\u0003A\u0011\u0001\u001b\u0002CQ,7\u000f^%oG2,H-Z\"bY\u000e4uN]\"iC&t\u0017M\u00197f'>,(oY3)\u0005i+\u0005\"\u00020\u0001\t\u0003!\u0014a\u0007;fgR\feo\\5e\u0013:\u001cG.\u001e3j]\u001e\u001c\u0016N\\4mKR|g\u000e\u000b\u0002^\u000b\")\u0011\r\u0001C\u0001i\u0005AB/Z:u\u001d>\u0004&/[8sSRL8i\u001c8tiJ\f\u0017N\u001c;)\u0005\u0001,\u0005\"\u00023\u0001\t\u0003!\u0014!\u0005;fgR\u0014V\r\\1uK\u0012Le\u000e];ug\"\u00121-\u0012\u0005\u0006O\u0002!\t\u0001N\u0001\u0019i\u0016\u001cHOU3mCR,G-\u00138qkR\u001cx+\u001b;i\u0003\u001e<\u0007F\u00014F\u0011\u0015Q\u0007\u0001\"\u00015\u0003a!Xm\u001d;SK6|g/\u001a*fIVtG-\u00198u+:LwN\u001c\u0015\u0003S\u0016CQ!\u001c\u0001\u0005\u0002Q\n!\u0005^3tiJ+Wn\u001c<f\u001f:,\u0017J\u001c9vi>\u0003XM]1u_J4%o\\7S_>$\bF\u00017F\u0011\u0015\u0001\b\u0001\"\u00015\u0003\u0015\"Xm\u001d;DY\u0016\fg.\u00169Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f^,ji\"|e.Z'f[\n,'\u000f\u000b\u0002p\u000b\")1\u000f\u0001C\u0001i\u0005\u0019B/Z:u\u0017\u0016,\u0007/V:fMVdWK\\5p]\"\u0012!/\u0012\u0005\u0006m\u0002!\t\u0001N\u0001'i\u0016\u001cH\u000fR3bI2|7m[\"bkN,GMQ=Fq\u000eD\u0017M\\4f\u0013:\fenY3ti>\u0014\bFA;F\u0011\u0015I\b\u0001\"\u00015\u0003i\u0019'/Z1uK\u000eC\u0017-\u001b8bE2,G+\u00192mKN{WO]2fQ\u0019\u000110a\u0001\u0002\u0006A\u0011Ap`\u0007\u0002{*\u0011aPP\u0001\u0007eVtg.\u001a:\n\u0007\u0005\u0005QPA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055a(A\u0004sk:tWM]:\n\t\u0005E\u00111\u0002\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005U!\u0001#\u0001\u0002\u0018\u0005IR*\u001e7uSBdW-\u00138qkR\u001c%/Z1uS>tG+Z:u!\rA\u0013\u0011\u0004\u0004\u0007\u0003\tA\t!a\u0007\u0014\t\u0005e\u0011Q\u0004\t\u0004m\u0005}\u0011bAA\u0011o\t1\u0011I\\=SK\u001aDq!JA\r\t\u0003\t)\u0003\u0006\u0002\u0002\u0018!A\u0011\u0011FA\r\t\u0003\tY#\u0001\u0006qCJ\fW.\u001a;feN,\"!!\f\u0011\tY\ny\u0003H\u0005\u0004\u0003c9$!B!se\u0006L\b\u0006CA\u0014\u0003k\t)&a\u0016\u0011\t\u0005]\u0012q\n\b\u0005\u0003s\tYE\u0004\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000frA!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\u0012\u0012A\u0002\u001fs_>$h(C\u0001\u0012\u0013\ty\u0004#C\u0002\u0002\u000eyJA!!\u0014\u0002\f\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!!\u0015\u0002T\tQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u00055\u00131B\u0001\u0005]\u0006lW-\t\u0002\u0002Z\u0005\u00012\u000f[;gM2,Wj\u001c3fu\u0001Z\b' ")
public class MultipleInputCreationTest
extends TableTestBase {
    private final BatchShuffleMode shuffleMode;
    private final BatchTableTestUtil util;

    @Parameterized.Parameters(name="shuffleMode: {0}")
    public static BatchShuffleMode[] parameters() {
        return MultipleInputCreationTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nx"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ny"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nz"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
    }

    @Test
    public void testBasicMultipleInput() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testManyMultipleInputs() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testKeepMultipleInputWithOneMemberForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = "SELECT * FROM chainable LEFT JOIN x ON chainable.a = x.a";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingUnionFromInputSide() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM x) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIncludeUnionForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM chainable) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingCalcAfterNonChainableSource() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  LEFT JOIN y ON x.a = y.d\n        |  LEFT JOIN t ON x.a = t.a\n        |  WHERE x.b > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIncludeCalcForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM chainable\n        |  LEFT JOIN y ON chainable.a = y.d\n        |  LEFT JOIN t ON chainable.a = t.a\n        |  WHERE chainable.a > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingSingleton() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,HashAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM z),\n        |  T2 AS (\n        |    SELECT a FROM\n        |      (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |      UNION ALL\n        |      (SELECT a FROM t FULL JOIN T1 ON t.a > T1.cnt))\n        |SELECT a FROM T2 LEFT JOIN z ON T2.a = z.g\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNoPriorityConstraint() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRelatedInputs() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveRedundantUnion() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM x GROUP BY a),\n        |  T2 AS (SELECT COUNT(*) AS cnt FROM y GROUP BY d),\n        |  T3 AS (SELECT a AS cnt FROM x INNER JOIN y ON x.a = y.d),\n        |  T4 AS (SELECT b AS cnt FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT cnt FROM\n        |  (SELECT cnt FROM (SELECT cnt FROM T1) UNION ALL (SELECT cnt FROM T2))\n        |  UNION ALL\n        |  (SELECT cnt FROM (SELECT cnt FROM T3) UNION ALL (SELECT cnt FROM T4))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveOneInputOperatorFromRoot() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d),\n        |  T2 AS (SELECT b FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT * FROM\n        |  (SELECT a, b FROM T1 LEFT JOIN T2 ON T1.a = T2.b)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCleanUpMultipleInputWithOneMember() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, a + 1 FROM T1)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testKeepUsefulUnion() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN x ON chainable.a = x.a),\n        |  T2 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN y ON chainable.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a FROM T1)\n        |  UNION ALL\n        |  (SELECT a FROM T2)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public void createChainableTableSource() {
        DataStreamSource dataStream = this.util().getStreamEnv().fromSource((Source)new MockSource(Boundedness.BOUNDED, 1), WatermarkStrategy.noWatermarks(), "chainable");
        TableTestUtil$.MODULE$.createTemporaryView(this.util().tableEnv(), "chainable", dataStream, (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
    }

    public MultipleInputCreationTest(BatchShuffleMode shuffleMode) {
        this.shuffleMode = shuffleMode;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

