/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor.utils;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.TestingBatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecDynamicFilteringDataCollector;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecExchange;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputPriorityConflictResolver;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class InputPriorityConflictResolverTest {
    @Test
    public void testDetectAndResolve() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[9];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        nodes[1].addInput((ExecNode<?>)nodes[0], InputProperty.builder().priority(0).build());
        nodes[2].addInput((ExecNode<?>)nodes[1], InputProperty.builder().priority(0).build());
        nodes[3].addInput((ExecNode<?>)nodes[0], InputProperty.builder().priority(0).build());
        nodes[4].addInput((ExecNode<?>)nodes[8], InputProperty.builder().priority(0).build());
        nodes[4].addInput((ExecNode<?>)nodes[0], InputProperty.builder().priority(0).build());
        nodes[5].addInput((ExecNode<?>)nodes[8], InputProperty.builder().priority(0).build());
        nodes[5].addInput((ExecNode<?>)nodes[0], InputProperty.builder().damBehavior(InputProperty.DamBehavior.END_INPUT).priority(0).build());
        nodes[7].addInput((ExecNode<?>)nodes[1], InputProperty.builder().priority(0).build());
        nodes[7].addInput((ExecNode<?>)nodes[2], InputProperty.builder().priority(0).build());
        nodes[7].addInput((ExecNode<?>)nodes[3], InputProperty.builder().priority(1).build());
        nodes[7].addInput((ExecNode<?>)nodes[4], InputProperty.builder().priority(10).build());
        nodes[7].addInput((ExecNode<?>)nodes[5], InputProperty.builder().priority(10).build());
        nodes[7].addInput((ExecNode<?>)nodes[6], InputProperty.builder().priority(100).build());
        InputPriorityConflictResolver resolver = new InputPriorityConflictResolver(Collections.singletonList(nodes[7]), InputProperty.DamBehavior.END_INPUT, StreamExchangeMode.BATCH, (ReadableConfig)new Configuration());
        resolver.detectAndResolve();
        Assertions.assertThat(nodes[7].getInputNodes().get(0)).isEqualTo((Object)nodes[1]);
        Assertions.assertThat(nodes[7].getInputNodes().get(1)).isEqualTo((Object)nodes[2]);
        Assertions.assertThat(nodes[7].getInputNodes().get(2)).isInstanceOf(BatchExecExchange.class);
        Assertions.assertThat((Optional)((BatchExecExchange)nodes[7].getInputNodes().get(2)).getRequiredExchangeMode()).isEqualTo(Optional.of(StreamExchangeMode.BATCH));
        Assertions.assertThat((Object)((ExecEdge)nodes[7].getInputNodes().get(2).getInputEdges().get(0)).getSource()).isEqualTo((Object)nodes[3]);
        Assertions.assertThat(nodes[7].getInputNodes().get(3)).isInstanceOf(BatchExecExchange.class);
        Assertions.assertThat((Optional)((BatchExecExchange)nodes[7].getInputNodes().get(3)).getRequiredExchangeMode()).isEqualTo(Optional.of(StreamExchangeMode.BATCH));
        Assertions.assertThat((Object)((ExecEdge)nodes[7].getInputNodes().get(3).getInputEdges().get(0)).getSource()).isEqualTo((Object)nodes[4]);
        Assertions.assertThat(nodes[7].getInputNodes().get(4)).isEqualTo((Object)nodes[5]);
        Assertions.assertThat(nodes[7].getInputNodes().get(5)).isEqualTo((Object)nodes[6]);
    }

    @Test
    public void testDeadlockCausedByExchange() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[2];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        BatchExecExchange exchange = new BatchExecExchange((ReadableConfig)new Configuration(), InputProperty.builder().requiredDistribution(InputProperty.ANY_DISTRIBUTION).build(), (RowType)nodes[0].getOutputType(), "Exchange");
        exchange.setRequiredExchangeMode(StreamExchangeMode.BATCH);
        ExecEdge execEdge = ExecEdge.builder().source((ExecNode)nodes[0]).target((ExecNode)exchange).build();
        exchange.setInputEdges(Collections.singletonList(execEdge));
        nodes[1].addInput((ExecNode<?>)exchange, InputProperty.builder().priority(0).build());
        nodes[1].addInput((ExecNode<?>)exchange, InputProperty.builder().priority(1).build());
        InputPriorityConflictResolver resolver = new InputPriorityConflictResolver(Collections.singletonList(nodes[1]), InputProperty.DamBehavior.END_INPUT, StreamExchangeMode.BATCH, (ReadableConfig)new Configuration());
        resolver.detectAndResolve();
        ExecNode<?> input0 = nodes[1].getInputNodes().get(0);
        ExecNode<?> input1 = nodes[1].getInputNodes().get(1);
        Assertions.assertThat(input1).isNotSameAs(input0);
        Consumer<ExecNode> checkExchange = execNode -> {
            Assertions.assertThat((Object)execNode).isInstanceOf(BatchExecExchange.class);
            BatchExecExchange e = (BatchExecExchange)execNode;
            Assertions.assertThat((Optional)e.getRequiredExchangeMode()).isEqualTo(Optional.of(StreamExchangeMode.BATCH));
            Assertions.assertThat((Object)((ExecEdge)e.getInputEdges().get(0)).getSource()).isEqualTo((Object)nodes[0]);
        };
        checkExchange.accept(input0);
        checkExchange.accept(input1);
    }

    @Test
    public void testWithDynamicFilteringPlan() {
        TestingBatchExecNode[] nodes = new TestingBatchExecNode[3];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new TestingBatchExecNode("TestingBatchExecNode" + i);
        }
        BatchExecTableSourceScan scan = new BatchExecTableSourceScan((ReadableConfig)new Configuration(), new DynamicTableSourceSpec(null, null), InputProperty.DEFAULT, RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType(), new IntType()}), "DynamicFilteringTableSourceScan");
        BatchExecDynamicFilteringDataCollector collector = new BatchExecDynamicFilteringDataCollector(Collections.singletonList(1), (ReadableConfig)new Configuration(), InputProperty.DEFAULT, RowType.of((LogicalType[])new LogicalType[]{new IntType()}), "DynamicFilteringDataCollector");
        nodes[0].addInput((ExecNode<?>)nodes[1], InputProperty.builder().priority(0).build());
        nodes[1].addInput((ExecNode<?>)nodes[2], InputProperty.builder().priority(1).build());
        nodes[1].addInput((ExecNode<?>)scan, InputProperty.builder().priority(0).build());
        ExecEdge collect2Scan = ExecEdge.builder().source((ExecNode)collector).target((ExecNode)scan).build();
        scan.setInputEdges(Collections.singletonList(collect2Scan));
        ExecEdge toCollector = ExecEdge.builder().source((ExecNode)nodes[2]).target((ExecNode)collector).build();
        collector.setInputEdges(Collections.singletonList(toCollector));
        InputPriorityConflictResolver resolver = new InputPriorityConflictResolver(Collections.singletonList(nodes[1]), InputProperty.DamBehavior.END_INPUT, StreamExchangeMode.BATCH, (ReadableConfig)new Configuration());
        resolver.detectAndResolve();
        ExecNode<?> input0 = nodes[1].getInputNodes().get(0);
        ExecNode<?> input1 = nodes[1].getInputNodes().get(1);
        Assertions.assertThat(input0).isSameAs((Object)nodes[2]);
        Assertions.assertThat(input1).isSameAs((Object)scan);
    }
}

