/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001'\tQb\t\\5oW\"+\u0007OU;mKN+G\u000f\u0015:pOJ\fW\u000eV3ti*\u00111\u0001B\u0001\baJ|wM]1n\u0015\t)a!\u0001\u0005paRLW.\u001b>f\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001aDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000b\u0001\u0002A\u0011A\u0011\u0002?Q,7\u000f\u001e\"vS2$g\t\\5oW\"+\u0007OU;mKN+G\u000f\u0015:pOJ\fW\u000eF\u0001#!\t)2%\u0003\u0002%-\t!QK\\5uQ\tyb\u0005\u0005\u0002(U5\t\u0001F\u0003\u0002*!\u0005)!.\u001e8ji&\u00111\u0006\u000b\u0002\u0005)\u0016\u001cH\u000fC\u0003.\u0001\u0011\u0005\u0011%A\fuKN$X*\u0019;dQ2KW.\u001b;MKN\u001cH\u000b[1oc!\"AFJ\u00181\u0003!)\u0007\u0010]3di\u0016$7%A\u0019\u0011\u0005IRdBA\u001a9\u001d\t!t'D\u00016\u0015\t1$#\u0001\u0004=e>|GOP\u0005\u0002/%\u0011\u0011HF\u0001\ba\u0006\u001c7.Y4f\u0013\tYDH\u0001\rJY2,w-\u00197Be\u001e,X.\u001a8u\u000bb\u001cW\r\u001d;j_:T!!\u000f\f\t\u000by\u0002A\u0011A\u0011\u0002+Q,7\u000f\u001e(vY2DU\r]'bi\u000eDwJ\u001d3fe\"\"QHJ\u0018AG\u0005\t\u0005C\u0001\u001aC\u0013\t\u0019EH\u0001\u000bOk2d\u0007k\\5oi\u0016\u0014X\t_2faRLwN\u001c\u0005\u0006\u000b\u0002!\t!I\u0001\u001ei\u0016\u001cHOT;mY\"+\u0007OU;mKN,\u00050Z2vi&|g\u000eV=qK\"\"AIJ\u0018A\u0011\u0015A\u0005\u0001\"\u0001\"\u0003I!Xm\u001d;Sk2,w\n]3sCRLwN\\:)\u0005\u001d3\u0003\"B&\u0001\t\u0003\t\u0013\u0001\u0005;fgRtU\u000f\u001c7Sk2,7+\u001a;tQ\u0011Qee\f!")
public class FlinkHepRuleSetProgramTest {
    @Test
    public void testBuildFlinkHepRuleSetProgram() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setMatchLimit(10).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMatchLimitLessThan1() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setMatchLimit(0);
    }

    @Test(expected=NullPointerException.class)
    public void testNullHepMatchOrder() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepMatchOrder(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullHepRulesExecutionType() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(null);
    }

    @Test
    public void testRuleOperations() {
        FlinkHepRuleSetProgram program = FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS, CoreRules.CALC_REDUCE_EXPRESSIONS, CoreRules.JOIN_REDUCE_EXPRESSIONS})).build();
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        Assert.assertFalse((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        program.remove(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.PROJECT_REDUCE_EXPRESSIONS}));
        Assert.assertFalse((boolean)program.contains((RelOptRule)CoreRules.FILTER_REDUCE_EXPRESSIONS));
        Assert.assertFalse((boolean)program.contains((RelOptRule)CoreRules.PROJECT_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        program.replaceAll(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.FILTER_SUB_QUERY_TO_CORRELATE}));
        Assert.assertFalse((boolean)program.contains((RelOptRule)CoreRules.CALC_REDUCE_EXPRESSIONS));
        Assert.assertFalse((boolean)program.contains((RelOptRule)CoreRules.JOIN_REDUCE_EXPRESSIONS));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        program.add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, CoreRules.JOIN_SUB_QUERY_TO_CORRELATE}));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.FILTER_SUB_QUERY_TO_CORRELATE));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE));
        Assert.assertTrue((boolean)program.contains((RelOptRule)CoreRules.JOIN_SUB_QUERY_TO_CORRELATE));
    }

    @Test(expected=NullPointerException.class)
    public void testNullRuleSets() {
        FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().add(null);
    }
}

