/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.plan.optimize.program.FlinkBatchProgram$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkHepRuleSetProgramBuilder$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.optimize.program.HEP_RULES_EXECUTION_TYPE$;
import org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRule$;
import org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t)#j\\5o\u0007>tG-\u001b;j_:,\u0015/^1mSRLHK]1og\u001a,'OU;mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0013\u0001B;uS2,\u0012A\t\t\u0003+\rJ!\u0001\n\f\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007M\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\u000bM,G/\u001e9\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\"\u0012q%\r\t\u0003eUj\u0011a\r\u0006\u0003iA\tQA[;oSRL!AN\u001a\u0003\r\t+gm\u001c:f\u0011\u0015A\u0004\u0001\"\u0001*\u00039!Xm\u001d;J]:,'OS8j]FB#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u0002\u001dQ,7\u000f^%o]\u0016\u0014(j\\5oe!\u0012QH\u000f\u0005\u0006\u0003\u0002!\t!K\u0001\u000fi\u0016\u001cH/\u00138oKJTu.\u001b84Q\t\u0001%\bC\u0003E\u0001\u0011\u0005\u0011&\u0001\buKN$\u0018J\u001c8fe*{\u0017N\u001c\u001b)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013A\t;fgRLeN\\3s\u0015>LgnV5uQ:{g.R9vS\u000e{g\u000eZ5uS>t\u0017\u0007\u000b\u0002Gu!)!\n\u0001C\u0001S\u0005\u0011C/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5D_:$\u0017\u000e^5p]JB#!\u0013\u001e\t\u000b5\u0003A\u0011A\u0015\u0002!Q,7\u000f^*f[&Tu.\u001b8`\u0013:\f\u0004F\u0001';\u0011\u0015\u0001\u0006\u0001\"\u0001*\u0003A!Xm\u001d;TK6L'j\\5o?&s'\u0007\u000b\u0002Pu!)1\u000b\u0001C\u0001S\u0005!C/Z:u'\u0016l\u0017NS8j]^KG\u000f\u001b(p]\u0016\u000bX/[\"p]\u0012LG/[8o?&s\u0017\u0007\u000b\u0002Su!)a\u000b\u0001C\u0001S\u0005!C/Z:u'\u0016l\u0017NS8j]^KG\u000f\u001b(p]\u0016\u000bX/[\"p]\u0012LG/[8o?&s'\u0007\u000b\u0002Vu!)\u0011\f\u0001C\u0001S\u0005\u0019B/Z:u'\u0016l\u0017NS8j]~+\u00050[:uc!\u0012\u0001L\u000f\u0005\u00069\u0002!\t!K\u0001\u0014i\u0016\u001cHoU3nS*{\u0017N\\0Fq&\u001cHO\r\u0015\u00037jBQa\u0018\u0001\u0005\u0002%\nq\u0005^3tiN+W.\u001b&pS:<\u0016\u000e\u001e5O_:,\u0015/^5D_:$\u0017\u000e^5p]~+\u00050[:uc!\u0012aL\u000f\u0005\u0006E\u0002!\t!K\u0001(i\u0016\u001cHoU3nS*{\u0017N\\,ji\"tuN\\#rk&\u001cuN\u001c3ji&|gnX#ySN$(\u0007\u000b\u0002bu\u0001")
public class JoinConditionEqualityTransferRuleTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().buildBatchProgram(FlinkBatchProgram$.MODULE$.DEFAULT_REWRITE());
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig((TableConfig)this.util().tableEnv().getConfig());
        ((FlinkChainedProgram)calciteConfig.getBatchProgram().get()).addLast("rules", (FlinkOptimizeProgram)FlinkHepRuleSetProgramBuilder$.MODULE$.newBuilder().setHepRulesExecutionType(HEP_RULES_EXECUTION_TYPE$.MODULE$.RULE_SEQUENCE()).setHepMatchOrder(HepMatchOrder.BOTTOM_UP).add(RuleSets.ofList((RelOptRule[])new RelOptRule[]{JoinConditionEqualityTransferRule$.MODULE$.INSTANCE()})).build());
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$3 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.rules.logical.JoinConditionEqualityTransferRuleTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testInnerJoin1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e");
    }

    @Test
    public void testInnerJoin2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b = d");
    }

    @Test
    public void testInnerJoin3() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND a = c");
    }

    @Test
    public void testInnerJoin4() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b + 1 = d");
    }

    @Test
    public void testInnerJoinWithNonEquiCondition1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a > e");
    }

    @Test
    public void testInnerJoinWithNonEquiCondition2() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 JOIN MyTable2 ON a = d AND a = e AND b > d");
    }

    @Test
    public void testSemiJoin_In1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a = e)");
    }

    @Test
    public void testSemiJoin_In2() {
        String sqlQuery = "SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a = e AND b = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_In1() {
        this.util().verifyRelPlan("SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a > e)");
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_In2() {
        String sqlQuery = "SELECT * FROM MyTable1 WHERE a IN (SELECT d FROM MyTable2 WHERE a > e AND b = d)";
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoin_Exist1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS (SELECT * FROM MyTable2 WHERE a = d AND a = e)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoin_Exist2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS\n        |    (SELECT * FROM MyTable2 WHERE a = d AND a = e AND b = d)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_Exist1() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS (SELECT * FROM MyTable2 WHERE a = d AND a > e)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }

    @Test
    public void testSemiJoinWithNonEquiCondition_Exist2() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable1 WHERE EXISTS\n        |    (SELECT * FROM MyTable2 WHERE a = d AND a = e AND b > d)\n      ")).stripMargin();
        this.util().verifyRelPlan(sqlQuery);
    }
}

