/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.HashSet;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.utils.UpsertKeyUtil;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UpsertKeyUtilTest {
    private final int[] emptyKey = new int[0];

    @Test
    public void testSmallestKey() {
        Assertions.assertThat((int[])UpsertKeyUtil.getSmallestKey(null)).isEqualTo((Object)this.emptyKey);
        Assertions.assertThat((int[])UpsertKeyUtil.getSmallestKey(new HashSet())).isEqualTo((Object)this.emptyKey);
        ImmutableBitSet smallestKey = ImmutableBitSet.of((int[])new int[]{0, 1});
        ImmutableBitSet middleKey = ImmutableBitSet.of((int[])new int[]{0, 2});
        ImmutableBitSet longKey = ImmutableBitSet.of((int[])new int[]{0, 1, 2});
        HashSet<ImmutableBitSet> upsertKeys = new HashSet<ImmutableBitSet>();
        upsertKeys.add(smallestKey);
        upsertKeys.add(middleKey);
        Assertions.assertThat((int[])UpsertKeyUtil.getSmallestKey(upsertKeys)).isEqualTo((Object)smallestKey.toArray());
        upsertKeys.clear();
        upsertKeys.add(smallestKey);
        upsertKeys.add(longKey);
        Assertions.assertThat((int[])UpsertKeyUtil.getSmallestKey(upsertKeys)).isEqualTo((Object)smallestKey.toArray());
    }
}

