/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.batch.table;

import java.util.TimeZone;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.runtime.utils.BatchTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData$;
import org.apache.flink.table.planner.runtime.utils.TestingRetractTableSink;
import org.apache.flink.table.planner.runtime.utils.TestingUpsertTableSink;
import org.apache.flink.table.planner.utils.MemoryTableSourceSinkUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001%\t)B*Z4bGf$\u0016M\u00197f'&t7.\u0013+DCN,'BA\u0002\u0005\u0003\u0015!\u0018M\u00197f\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!aA\u0006\u000b\u00051i\u0011!\u00024mS:\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\u0011aCB\u0001\u0006kRLGn]\u0005\u00031U\u0011QBQ1uG\"$Vm\u001d;CCN,\u0007\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u0003\u0011\u0015y\u0002\u0001\"\u0001!\u00039)8/Z:MK\u001e\f7-\u001f*poN,\u0012!\t\t\u0003E\u0011j\u0011a\t\u0006\u0003-)I!!J\u0012\u0003#1+w-Y2z%><(+Z:pkJ\u001cW\r\u000b\u0002\u001fOA\u0011\u0001fK\u0007\u0002S)\u0011!fD\u0001\u0006UVt\u0017\u000e^\u0005\u0003Y%\u0012AAU;mK\")a\u0006\u0001C\u0001_\u0005\u0001C/Z:u\t\u0016\u001c\u0017.\\1m\u001fV$\b/\u001e;G_Jl\u0017\r\u001e+bE2,7+\u001b8l)\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$\u0001B+oSRD#!L\u001c\u0011\u0005!B\u0014BA\u001d*\u0005\u0011!Vm\u001d;\t\u000bm\u0002A\u0011A\u0018\u0002AQ,7\u000f\u001e#fG&l\u0017\r\\!qa\u0016tGm\u0015;sK\u0006lG+\u00192mKNKgn\u001b\u0015\u0003u]BQA\u0010\u0001\u0005\u0002=\n\u0011\u0005^3ti\u0012+7-[7bY\u001a{'\u000fT3hC\u000eLH+\u001f9f)\u0006\u0014G.Z*j].D#!P\u001c)\u0005u\n\u0005C\u0001\u0015C\u0013\t\u0019\u0015F\u0001\u0004JO:|'/\u001a\u0005\u0006\u000b\u0002!IAR\u0001\u0015aJ,\u0007/\u0019:f\r>\u0014X\u000b]:feR\u001c\u0016N\\6\u0015\u0003\u001d\u0003\"\u0001\u0006%\n\u0005%+\"A\u0006+fgRLgnZ+qg\u0016\u0014H\u000fV1cY\u0016\u001c\u0016N\\6\t\u000b-\u0003A\u0011A\u0018\u0002\u001dQ,7\u000f^+qg\u0016\u0014HoU5oW\"\u0012!j\u000e\u0005\u0006\u001d\u0002!\taL\u0001\u0019i\u0016\u001cH/\u00169tKJ$8+\u001b8l/&$\b.\u00119qK:$\u0007FA'8\u0011\u0015\t\u0006\u0001\"\u0003S\u0003U\u0001(/\u001a9be\u00164uN\u001d*fiJ\f7\r^*j].$\u0012a\u0015\t\u0003)QK!!V\u000b\u0003/Q+7\u000f^5oOJ+GO]1diR\u000b'\r\\3TS:\\\u0007\"B,\u0001\t\u0003y\u0013a\u0004;fgR\u0014V\r\u001e:bGR\u001c\u0016N\\6)\u0005Y;\u0004")
public class LegacyTableSinkITCase
extends BatchTestBase {
    @Rule
    public LegacyRowResource usesLegacyRows() {
        return LegacyRowResource.INSTANCE;
    }

    @Test
    public void testDecimalOutputFormatTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeOutputFormatTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("Table3").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    @Test
    public void testDecimalAppendStreamTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("c", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).field("d", DataTypes.CHAR((int)5)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createDataTypeAppendStreamTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.data3(), TestData$.MODULE$.type3(), "a, b, c", TestData$.MODULE$.nullablesOfData3());
        Table table = this.tEnv().from("Table3").where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$greater(package$.MODULE$.int2Literal(20))).select(new Expression[]{package$.MODULE$.string2Literal("12345"), (Expression)package$.MODULE$.LiteralIntExpression(55).cast(DataTypes.DECIMAL((int)10, (int)0)), (Expression)package$.MODULE$.LiteralStringExpression("12345").cast(DataTypes.CHAR((int)5))});
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"12345,55,12345"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    @Test
    @Ignore
    public void testDecimalForLegacyTypeTableSink() {
        MemoryTableSourceSinkUtil$.MODULE$.clear();
        TableSchema schema = TableSchema.builder().field("a", DataTypes.VARCHAR((int)5)).field("b", DataTypes.DECIMAL((int)10, (int)0)).build();
        MemoryTableSourceSinkUtil$.MODULE$.createLegacyUnsafeMemoryAppendTable(this.tEnv(), schema, "testSink");
        this.registerCollection("Table3", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        Table table = this.tEnv().from("Table3").select(new Expression[]{(Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).cast(DataTypes.STRING()), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).cast(DataTypes.DECIMAL((int)10, (int)2))}).distinct();
        table.executeInsert("testSink").await();
        java.util.List results = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(MemoryTableSourceSinkUtil$.MODULE$.tableDataStrings()).asJava();
        String expected = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1,0.100000000000000000", "2,0.200000000000000000", "3,0.300000000000000000", "3,0.400000000000000000", "4,0.500000000000000000", "4,0.600000000000000000", "5,0.700000000000000000", "5,0.800000000000000000", "5,0.900000000000000000"}))).mkString("\n");
        TestBaseUtils.compareResultAsText((java.util.List)results, (String)expected);
    }

    /*
     * WARNING - void declaration
     */
    private TestingUpsertTableSink prepareForUpsertSink() {
        void var2_2;
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.DOUBLE()).build();
        TestingUpsertTableSink sink = new TestingUpsertTableSink(new int[]{0}, TimeZone.getDefault());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("testSink", (TableSink)sink.configure(schema.getFieldNames(), (TypeInformation<?>[])schema.getFieldTypes()));
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        return var2_2;
    }

    @Test
    public void testUpsertSink() {
        TestingUpsertTableSink sink = this.prepareForUpsertSink();
        sink.expectedKeys_$eq((Option<String[]>)new Some((Object)new String[]{"a"}));
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        List result = (List)sink.getUpsertResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"1,0.1", (List)new .colon.colon((Object)"2,0.4", (List)new .colon.colon((Object)"3,1.0", (List)new .colon.colon((Object)"4,2.2", (List)new .colon.colon((Object)"5,3.9", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testUpsertSinkWithAppend() {
        TestingUpsertTableSink sink = this.prepareForUpsertSink();
        sink.expectedKeys_$eq((Option<String[]>)None$.MODULE$);
        sink.expectedIsAppendOnly_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Table table = this.tEnv().from("MyTable").select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b"))}).where(package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")).$less(package$.MODULE$.int2Literal(3)));
        table.executeInsert("testSink").await();
        List result = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"(true,1,0.1)", (List)new .colon.colon((Object)"(true,2,0.2)", (List)new .colon.colon((Object)"(true,2,0.2)", (List)Nil$.MODULE$))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    private TestingRetractTableSink prepareForRetractSink() {
        void var2_2;
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).field("b", DataTypes.DOUBLE()).build();
        TestingRetractTableSink sink = new TestingRetractTableSink(TimeZone.getDefault());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSinkInternal("testSink", (TableSink)sink.configure(schema.getFieldNames(), (TypeInformation<?>[])schema.getFieldTypes()));
        this.registerCollection("MyTable", TestData$.MODULE$.simpleData2(), TestData$.MODULE$.simpleType2(), "a, b", TestData$.MODULE$.nullableOfSimpleData2());
        return var2_2;
    }

    @Test
    public void testRetractSink() {
        TestingRetractTableSink sink = this.prepareForRetractSink();
        Table table = this.tEnv().from("MyTable").groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), (Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")).sum()});
        table.executeInsert("testSink").await();
        List result = (List)sink.getRawResults().sorted((Ordering)Ordering.String$.MODULE$);
        List expected = (List)new .colon.colon((Object)"(true,1,0.1)", (List)new .colon.colon((Object)"(true,2,0.4)", (List)new .colon.colon((Object)"(true,3,1.0)", (List)new .colon.colon((Object)"(true,4,2.2)", (List)new .colon.colon((Object)"(true,5,3.9)", (List)Nil$.MODULE$))))).sorted((Ordering)Ordering.String$.MODULE$);
        Assert.assertEquals((Object)expected, (Object)result);
    }
}

