/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.runtime.stream.sql;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.table.planner.runtime.utils.StreamingTestBase;
import org.apache.flink.table.planner.runtime.utils.TestData;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AnalyzeTableITCase
extends StreamingTestBase {
    private TableEnvironment tEnv;

    @Override
    @BeforeEach
    public void before() throws Exception {
        super.before();
        this.tEnv = this.tEnv();
        String dataId1 = TestValuesTableFactory.registerData(TestData.smallData3());
        this.tEnv.executeSql(String.format("CREATE TABLE MyTable (\n  `a` INT,\n  `b` BIGINT,\n  `c` VARCHAR\n) WITH (\n  'connector' = 'values',\n  'data-id' = '%s',\n  'bounded' = 'true'\n)", dataId1));
    }

    @Test
    public void testAnalyzeTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("analyze table MyTable compute statistics")).isInstanceOf(TableException.class)).hasMessageContaining("ANALYZE TABLE is not supported for streaming mode now");
    }
}

