/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class NumericPrimitiveCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, Number> {
    static final NumericPrimitiveCastRule INSTANCE = new NumericPrimitiveCastRule();

    private NumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().predicate(NumericPrimitiveCastRule::matches).build());
    }

    private static boolean matches(LogicalType input, LogicalType target) {
        if (input.is(target.getTypeRoot())) {
            return false;
        }
        if ((input.is(LogicalTypeFamily.INTEGER_NUMERIC) || input.is(LogicalTypeFamily.APPROXIMATE_NUMERIC)) && (target.is(LogicalTypeFamily.INTEGER_NUMERIC) || target.is(LogicalTypeFamily.APPROXIMATE_NUMERIC))) {
            return true;
        }
        if (input.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH) && target.is(LogicalTypeRoot.BIGINT) || input.is(LogicalTypeRoot.BIGINT) && target.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH)) {
            return true;
        }
        if (input.is(LogicalTypeRoot.INTERVAL_DAY_TIME) && target.is(LogicalTypeRoot.INTEGER) || input.is(LogicalTypeRoot.INTEGER) && target.is(LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            return true;
        }
        if ((input.is(LogicalTypeRoot.TINYINT) || input.is(LogicalTypeRoot.SMALLINT)) && target.is(LogicalTypeRoot.INTERVAL_DAY_TIME)) {
            return true;
        }
        return (input.is(LogicalTypeRoot.TINYINT) || input.is(LogicalTypeRoot.SMALLINT)) && target.is(LogicalTypeRoot.INTERVAL_YEAR_MONTH);
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastRuleUtils.castToPrimitive(targetLogicalType, inputTerm);
    }
}

