/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.time.ZoneId;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.functions.casting.CastRule;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.print.RowDataToStringConverter;

@Internal
public final class RowDataToStringConverterImpl
implements RowDataToStringConverter {
    private final DataType dataType;
    private final CastRule.Context castRuleContext;
    private Function<RowData, String>[] columnConverters;

    public RowDataToStringConverterImpl(DataType dataType, ZoneId zoneId, ClassLoader classLoader, boolean legacyBehaviour) {
        this.dataType = dataType;
        this.castRuleContext = CastRule.Context.create(true, legacyBehaviour, zoneId, classLoader);
    }

    private void init() {
        List rowDataTypes = DataType.getFieldDataTypes((DataType)this.dataType);
        this.columnConverters = new Function[rowDataTypes.size()];
        int i = 0;
        while (i < rowDataTypes.size()) {
            int index = i++;
            LogicalType fieldType = ((DataType)rowDataTypes.get(index)).getLogicalType();
            RowData.FieldGetter getter = RowData.createFieldGetter((LogicalType)fieldType, (int)index);
            CastExecutor<?, ?> castExecutor = CastRuleProvider.create(this.castRuleContext, fieldType, (LogicalType)VarCharType.STRING_TYPE);
            if (castExecutor == null) {
                throw new IllegalStateException("Cannot create a cast executor for converting " + fieldType + " to string. This is a bug, please open an issue.");
            }
            this.columnConverters[index] = row -> {
                if (row.isNullAt(index)) {
                    return "<NULL>";
                }
                return ((StringData)castExecutor.cast(getter.getFieldOrNull(row))).toString();
            };
        }
    }

    public String[] convert(RowData rowData) {
        if (this.columnConverters == null) {
            this.init();
        }
        String[] result = new String[rowData.getArity()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.columnConverters[i].apply(rowData);
        }
        return result;
    }
}

