/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.Locale;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class ProjectionTransformer
extends GeometryTransformer {
    private final CoordinateTransform coordinateTransform;

    public ProjectionTransformer(int sourceSrid, int targetSrid) {
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem source = crsFactory.createFromName(String.format(Locale.ROOT, "epsg:%s", sourceSrid));
        CoordinateReferenceSystem target = crsFactory.createFromName(String.format(Locale.ROOT, "epsg:%s", targetSrid));
        CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
        this.coordinateTransform = ctFactory.createTransform(source, target);
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry parent) {
        Coordinate[] coordinateArray = (Coordinate[])Stream.of(coordinateSequence.toCoordinateArray()).map(this::transformCoordinate).toArray(Coordinate[]::new);
        return new CoordinateArraySequence(coordinateArray);
    }

    private Coordinate transformCoordinate(Coordinate coordinate) {
        ProjCoordinate c1 = new ProjCoordinate(coordinate.x, coordinate.y);
        ProjCoordinate c2 = this.coordinateTransform.transform(c1, new ProjCoordinate());
        return new Coordinate(c2.x, c2.y);
    }

    @Override
    protected Geometry transformPoint(Point geom, Geometry parent) {
        try {
            Geometry geometry = super.transformPoint(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformMultiPoint(MultiPoint geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiPoint(geom, parent);
            if (geometry instanceof Point) {
                geometry = this.factory.createMultiPoint(new Point[]{(Point)geometry});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformLinearRing(LinearRing geom, Geometry parent) {
        try {
            Geometry geometry = super.transformLinearRing(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformLineString(LineString geom, Geometry parent) {
        try {
            Geometry geometry = super.transformLineString(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformMultiLineString(MultiLineString geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiLineString(geom, parent);
            if (geometry instanceof LineString) {
                geometry = this.factory.createMultiLineString(new LineString[]{(LineString)geometry});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformPolygon(Polygon geom, Geometry parent) {
        try {
            Geometry geometry = super.transformPolygon(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        try {
            Geometry geometry = super.transformMultiPolygon(geom, parent);
            if (geometry instanceof Polygon) {
                geometry = this.factory.createMultiPolygon(new Polygon[]{(Polygon)geometry});
            }
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    @Override
    protected Geometry transformGeometryCollection(GeometryCollection geom, Geometry parent) {
        try {
            Geometry geometry = super.transformGeometryCollection(geom, parent);
            return this.withTargetSRID(geometry);
        }
        catch (Exception e) {
            return parent.getFactory().createEmpty(0);
        }
    }

    private Geometry withTargetSRID(Geometry outputGeom) {
        int srid = this.coordinateTransform.getTargetCRS().getProjection().getEPSGCode();
        outputGeom.setSRID(srid);
        return outputGeom;
    }
}

