/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.hint.JoinStrategy;

public class ClearJoinHintWithInvalidPropagationShuttle
extends RelShuttleImpl {
    @Override
    public RelNode visit(LogicalJoin join) {
        return this.visitBiRel(join);
    }

    @Override
    public RelNode visit(LogicalCorrelate correlate) {
        return this.visitBiRel(correlate);
    }

    private RelNode visitBiRel(BiRel biRel) {
        ImmutableList<RelHint> hints = ((Hintable)((Object)biRel)).getHints();
        Set allHintNames = hints.stream().map(hint -> hint.hintName).collect(Collectors.toSet());
        if (allHintNames.stream().noneMatch(JoinStrategy::isJoinStrategy)) {
            return super.visit(biRel);
        }
        Optional<RelHint> firstAliasHint = hints.stream().filter(hint -> "ALIAS".equals(hint.hintName)).findFirst();
        if (!firstAliasHint.isPresent()) {
            return super.visit(biRel);
        }
        List joinHintsFromOuterQueryBlock = hints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName) && hint.inheritPath.size() > ((RelHint)firstAliasHint.get()).inheritPath.size()).collect(Collectors.toList());
        if (joinHintsFromOuterQueryBlock.isEmpty()) {
            return super.visit(biRel);
        }
        RelNode newJoin = biRel;
        for (RelHint outerJoinHint : joinHintsFromOuterQueryBlock) {
            ClearOuterJoinHintShuttle clearOuterJoinHintShuttle = new ClearOuterJoinHintShuttle(outerJoinHint);
            newJoin = newJoin.accept(clearOuterJoinHintShuttle);
        }
        return super.visit(newJoin);
    }

    private static class ClearOuterJoinHintShuttle
    extends RelShuttleImpl {
        private final Deque<Integer> currentInheritPath;
        private final RelHint joinHintNeedRemove;

        public ClearOuterJoinHintShuttle(RelHint joinHintNeedRemove) {
            this.joinHintNeedRemove = joinHintNeedRemove;
            this.currentInheritPath = new ArrayDeque<Integer>();
            this.currentInheritPath.addAll(joinHintNeedRemove.inheritPath);
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            this.currentInheritPath.addLast(i);
            RelNode newNode = super.visitChild(parent, i, child);
            this.currentInheritPath.removeLast();
            return newNode;
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            return this.visitBiRel(correlate);
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return this.visitBiRel(join);
        }

        private RelNode visitBiRel(BiRel biRel) {
            Hintable hBiRel = (Hintable)((Object)biRel);
            ArrayList<RelHint> hints = new ArrayList<RelHint>(hBiRel.getHints());
            Optional<RelHint> invalidJoinHint = this.getInvalidJoinHint(hints);
            if (invalidJoinHint.isPresent()) {
                hints.remove(invalidJoinHint.get());
                return super.visit(hBiRel.withHints(hints));
            }
            return super.visit(biRel);
        }

        private Optional<RelHint> getInvalidJoinHint(List<RelHint> hints) {
            for (RelHint hint : hints) {
                if (!hint.hintName.equals(this.joinHintNeedRemove.hintName) || !this.isMatchInvalidInheritPath(new ArrayList<Integer>(this.currentInheritPath), hint.inheritPath)) continue;
                return Optional.of(hint);
            }
            return Optional.empty();
        }

        private boolean isMatchInvalidInheritPath(List<Integer> invalidInheritPath, List<Integer> checkedInheritPath) {
            if (invalidInheritPath.size() != checkedInheritPath.size()) {
                return false;
            }
            for (int i = 0; i < invalidInheritPath.size(); ++i) {
                if (Objects.equals(invalidInheritPath.get(i), checkedInheritPath.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

