/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class SumWithRetractAggFunction
extends DeclarativeAggregateFunction {
    private final UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef((String)"sum");
    private final UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef((String)"count");

    public int operandCount() {
        return 1;
    }

    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum, this.count};
    }

    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType(), DataTypes.BIGINT()};
    }

    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType()), ExpressionBuilder.literal(0L)};
    }

    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.operand(0), (Expression)this.adjustedPlus(this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.plus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.adjustedMinus(this.zeroLiteral(), this.operand(0)), (Expression)this.adjustedMinus((Expression)this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)this.count, (Expression)ExpressionBuilder.minus((Expression)this.count, (Expression)ExpressionBuilder.literal(1L)))};
    }

    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.mergeOperand(this.sum)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.mergeOperand(this.sum), (Expression)this.adjustedPlus(this.sum, this.mergeOperand(this.sum)))), ExpressionBuilder.plus((Expression)this.count, (Expression)this.mergeOperand(this.count))};
    }

    public Expression getValueExpression() {
        return ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.equalTo((Expression)this.count, (Expression)ExpressionBuilder.literal(0L)), (Expression)ExpressionBuilder.nullOf(this.getResultType()), (Expression)this.sum);
    }

    protected abstract Expression zeroLiteral();

    protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.plus((Expression)arg1, (Expression)arg2);
    }

    protected UnresolvedCallExpression adjustedMinus(Expression arg1, UnresolvedReferenceExpression arg2) {
        return ExpressionBuilder.minus(arg1, (Expression)arg2);
    }

    public static class DecimalSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        private final DataType resultType;

        public DecimalSumWithRetractAggFunction(DecimalType decimalType) {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)decimalType);
            this.resultType = DataTypes.DECIMAL((int)sumType.getPrecision(), (int)sumType.getScale());
        }

        public DataType getResultType() {
            return this.resultType;
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }

        @Override
        protected UnresolvedCallExpression adjustedPlus(UnresolvedReferenceExpression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalPlus((Expression)arg1, (Expression)arg2);
        }

        @Override
        protected UnresolvedCallExpression adjustedMinus(Expression arg1, UnresolvedReferenceExpression arg2) {
            return ExpressionBuilder.aggDecimalMinus(arg1, (Expression)arg2);
        }
    }

    public static class DoubleSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0.0);
        }
    }

    public static class FloatSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(Float.valueOf(0.0f));
        }
    }

    public static class LongSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0L);
        }
    }

    public static class ShortSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((short)0);
        }
    }

    public static class ByteSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((byte)0);
        }
    }

    public static class IntSumWithRetractAggFunction
    extends SumWithRetractAggFunction {
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }
}

