/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;

public abstract class FlinkHints {
    public static final String HINT_NAME_OPTIONS = "OPTIONS";
    public static final String HINT_ALIAS = "ALIAS";
    public static final String HINT_NAME_JSON_AGGREGATE_WRAPPED = "JSON_AGGREGATE_WRAPPED";

    public static Map<String, String> getHintedOptions(List<RelHint> tableHints) {
        return tableHints.stream().filter(hint -> hint.hintName.equalsIgnoreCase(HINT_NAME_OPTIONS)).findFirst().map(hint -> hint.kvOptions).orElse(Collections.emptyMap());
    }

    public static Map<String, String> mergeTableOptions(Map<String, String> hints, Map<String, String> props) {
        if (hints.size() == 0) {
            return props;
        }
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.putAll(props);
        newProps.putAll(hints);
        return Collections.unmodifiableMap(newProps);
    }

    public static Optional<String> getTableAlias(RelNode node) {
        if (node instanceof Hintable) {
            Hintable aliasNode = (Hintable)((Object)node);
            List aliasNames = aliasNode.getHints().stream().filter(h2 -> h2.hintName.equalsIgnoreCase(HINT_ALIAS)).flatMap(h2 -> h2.listOptions.stream()).collect(Collectors.toList());
            if (aliasNames.size() > 0) {
                return Optional.of(aliasNames.get(0));
            }
            if (FlinkHints.canTransposeToTableScan(node)) {
                return FlinkHints.getTableAlias(node.getInput(0));
            }
        }
        return Optional.empty();
    }

    public static boolean canTransposeToTableScan(RelNode node) {
        return node instanceof LogicalProject || node instanceof LogicalFilter || node instanceof LogicalSnapshot;
    }

    public static Optional<String> getTableName(RelOptTable table) {
        if (table == null) {
            return Optional.empty();
        }
        if (!(table instanceof FlinkPreparingTableBase)) {
            throw new TableException(String.format("Could not get the table name with the unknown table class `%s`", table.getClass().getCanonicalName()));
        }
        String tableName = StringUtils.join(((FlinkPreparingTableBase)table).getNames(), (char)'.');
        return Optional.of(tableName);
    }

    public static String stringifyHints(List<RelHint> hints) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (RelHint h2 : hints) {
            if (h2.hintName.equalsIgnoreCase(HINT_ALIAS)) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(h2.hintName);
            if (h2.listOptions.size() > 0) {
                String listStr = h2.listOptions.stream().collect(Collectors.joining(",", "(", ")"));
                sb.append(listStr);
            } else if (h2.kvOptions.size() > 0) {
                String mapStr = h2.kvOptions.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", "(", ")"));
                sb.append(mapStr);
            }
            first = false;
        }
        return sb.toString();
    }

    public static List<RelHint> getAllJoinHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> JoinStrategy.isJoinStrategy(hint.hintName)).collect(Collectors.toList());
    }

    public static List<RelHint> getQueryBlockAliasHints(List<RelHint> allHints) {
        return allHints.stream().filter(hint -> hint.hintName.equals(HINT_ALIAS)).collect(Collectors.toList());
    }

    public static RelNode capitalizeJoinHints(RelNode root) {
        return root.accept(new CapitalizeJoinHintShuttle());
    }

    private static class CapitalizeJoinHintShuttle
    extends RelShuttleImpl {
        private CapitalizeJoinHintShuttle() {
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            return this.visitBiRel(correlate);
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return this.visitBiRel(join);
        }

        private RelNode visitBiRel(BiRel biRel) {
            Hintable hBiRel = (Hintable)((Object)biRel);
            AtomicBoolean changed = new AtomicBoolean(false);
            List<RelHint> hintsWithCapitalJoinHints = hBiRel.getHints().stream().map(hint -> {
                String capitalHintName = hint.hintName.toUpperCase(Locale.ROOT);
                if (JoinStrategy.isJoinStrategy(capitalHintName)) {
                    changed.set(true);
                    if (JoinStrategy.isLookupHint(hint.hintName)) {
                        return RelHint.builder(capitalHintName).hintOptions(hint.kvOptions).inheritPath(hint.inheritPath).build();
                    }
                    return RelHint.builder(capitalHintName).hintOptions(hint.listOptions).inheritPath(hint.inheritPath).build();
                }
                return hint;
            }).collect(Collectors.toList());
            if (changed.get()) {
                return super.visit(hBiRel.withHints(hintsWithCapitalJoinHints));
            }
            return super.visit(biRel);
        }
    }
}

