/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlAlterView;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

class SqlNodeConvertUtils {
    SqlNodeConvertUtils() {
    }

    static PlannerQueryOperation toQueryOperation(SqlNode validated, SqlNodeConverter.ConvertContext context) {
        RelRoot relational = context.toRelRoot(validated);
        return new PlannerQueryOperation(relational.project());
    }

    static CatalogView toCatalogView(SqlNode query, List<SqlNode> viewFields, Map<String, String> viewOptions, String viewComment, SqlNodeConverter.ConvertContext context) {
        String originalQuery = context.toQuotedSqlString(query);
        SqlNode validateQuery = context.getSqlValidator().validate(query);
        String expandedQuery = context.expandSqlIdentifiers(originalQuery);
        PlannerQueryOperation operation = SqlNodeConvertUtils.toQueryOperation(validateQuery, context);
        ResolvedSchema schema = operation.getResolvedSchema();
        if (!viewFields.isEmpty()) {
            List inputFieldNames = schema.getColumnNames();
            List aliasFieldNames = viewFields.stream().map(SqlNode::toString).collect(Collectors.toList());
            if (inputFieldNames.size() != aliasFieldNames.size()) {
                throw new ValidationException(String.format("VIEW definition and input fields not match:\n\tDef fields: %s.\n\tInput fields: %s.", aliasFieldNames, inputFieldNames));
            }
            schema = ResolvedSchema.physical(aliasFieldNames, (List)schema.getColumnDataTypes());
        }
        return CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (String)viewComment, (String)originalQuery, (String)expandedQuery, viewOptions);
    }

    static CatalogView validateAlterView(SqlAlterView alterView, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])alterView.fullViewName());
        ObjectIdentifier viewIdentifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        Optional optionalCatalogTable = context.getCatalogManager().getTable(viewIdentifier);
        if (!optionalCatalogTable.isPresent() || ((ContextResolvedTable)optionalCatalogTable.get()).isTemporary()) {
            throw new ValidationException(String.format("View %s doesn't exist or is a temporary view.", viewIdentifier));
        }
        ResolvedCatalogBaseTable baseTable = ((ContextResolvedTable)optionalCatalogTable.get()).getResolvedTable();
        if (baseTable instanceof CatalogTable) {
            throw new ValidationException("ALTER VIEW for a table is not allowed");
        }
        return (CatalogView)baseTable;
    }
}

