/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.types.DataType;

public interface SqlNodeConverter<S extends SqlNode> {
    public Operation convertSqlNode(S var1, ConvertContext var2);

    default public Optional<EnumSet<SqlKind>> supportedSqlKinds() {
        return Optional.empty();
    }

    public static interface ConvertContext {
        public SqlValidator getSqlValidator();

        public CatalogManager getCatalogManager();

        public RelRoot toRelRoot(SqlNode var1);

        public RexNode toRexNode(SqlNode var1, RelDataType var2, @Nullable DataType var3);

        public List<RexNode> reduceRexNodes(List<RexNode> var1);

        public String toQuotedSqlString(SqlNode var1);

        public String expandSqlIdentifiers(String var1);
    }
}

