/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SqlAlterTableAddPartitionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterTableDropPartitionConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewAsConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewPropertiesConverter;
import org.apache.flink.table.planner.operations.converters.SqlAlterViewRenameConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateCatalogConverter;
import org.apache.flink.table.planner.operations.converters.SqlCreateViewConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.SqlProcedureCallConverter;
import org.apache.flink.table.planner.operations.converters.SqlQueryConverter;
import org.apache.flink.table.planner.operations.converters.SqlReplaceTableAsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowFunctionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowPartitionsConverter;
import org.apache.flink.table.planner.operations.converters.SqlShowProcedureConverter;
import org.apache.flink.table.planner.operations.converters.SqlTruncateTableConverter;

public class SqlNodeConverters {
    private static final Map<Class<?>, SqlNodeConverter<?>> CLASS_CONVERTERS = new HashMap();
    private static final Map<SqlKind, SqlNodeConverter<?>> SQLKIND_CONVERTERS = new HashMap();

    public static Optional<Operation> convertSqlNode(SqlNode validatedSqlNode, SqlNodeConverter.ConvertContext context) {
        SqlNodeConverter<?> classConverter = CLASS_CONVERTERS.get(validatedSqlNode.getClass());
        if (classConverter != null) {
            return Optional.of(classConverter.convertSqlNode(validatedSqlNode, context));
        }
        SqlNodeConverter<?> sqlKindConverter = SQLKIND_CONVERTERS.get((Object)validatedSqlNode.getKind());
        if (sqlKindConverter != null) {
            return Optional.of(sqlKindConverter.convertSqlNode(validatedSqlNode, context));
        }
        return Optional.empty();
    }

    private static void register(SqlNodeConverter<?> converter) {
        if (converter.supportedSqlKinds().isPresent()) {
            for (SqlKind sqlKind : converter.supportedSqlKinds().get()) {
                if (SQLKIND_CONVERTERS.containsKey((Object)sqlKind)) {
                    throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlKind '%s'", new Object[]{converter.getClass().getCanonicalName(), sqlKind}));
                }
                SQLKIND_CONVERTERS.put(sqlKind, converter);
            }
            return;
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(converter, SqlNodeConverter.class, converter.getClass(), (int)0);
        Class nodeClass = typeInfo.getTypeClass();
        if (CLASS_CONVERTERS.containsKey(nodeClass)) {
            throw new IllegalArgumentException(String.format("Failed to register converter for '%s', because there is a registered converter for the SqlNode '%s'", converter.getClass().getCanonicalName(), nodeClass.getCanonicalName()));
        }
        CLASS_CONVERTERS.put(nodeClass, converter);
    }

    static {
        SqlNodeConverters.register(new SqlCreateCatalogConverter());
        SqlNodeConverters.register(new SqlCreateViewConverter());
        SqlNodeConverters.register(new SqlAlterViewRenameConverter());
        SqlNodeConverters.register(new SqlAlterViewPropertiesConverter());
        SqlNodeConverters.register(new SqlAlterViewAsConverter());
        SqlNodeConverters.register(new SqlAlterTableAddPartitionConverter());
        SqlNodeConverters.register(new SqlAlterTableDropPartitionConverter());
        SqlNodeConverters.register(new SqlQueryConverter());
        SqlNodeConverters.register(new SqlShowPartitionsConverter());
        SqlNodeConverters.register(new SqlTruncateTableConverter());
        SqlNodeConverters.register(new SqlShowFunctionsConverter());
        SqlNodeConverters.register(new SqlShowProcedureConverter());
        SqlNodeConverters.register(new SqlReplaceTableAsConverter());
        SqlNodeConverters.register(new SqlProcedureCallConverter());
    }
}

