/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch.runtimefilter;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.runtimefilter.BatchExecGlobalRuntimeFilterBuilder;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;

public class BatchPhysicalGlobalRuntimeFilterBuilder
extends SingleRel
implements BatchPhysicalRel {
    private final int estimatedRowCount;
    private final int maxRowCount;
    private final String[] buildFieldNames;

    public BatchPhysicalGlobalRuntimeFilterBuilder(RelOptCluster cluster, RelTraitSet traits, RelNode input, String[] buildFiledNames, int estimatedRowCount, int maxRowCount) {
        super(cluster, traits, input);
        this.buildFieldNames = buildFiledNames;
        this.estimatedRowCount = estimatedRowCount;
        this.maxRowCount = maxRowCount;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new BatchPhysicalGlobalRuntimeFilterBuilder(this.getCluster(), traitSet, inputs.get(0), this.buildFieldNames, this.estimatedRowCount, this.maxRowCount);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.getInput().getRowType();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("select", String.join((CharSequence)", ", this.buildFieldNames)).item("estimatedRowCount", this.estimatedRowCount).item("maxRowCount", this.maxRowCount);
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        InputProperty inputProperty = InputProperty.builder().requiredDistribution(InputProperty.SINGLETON_DISTRIBUTION).damBehavior(InputProperty.DamBehavior.END_INPUT).build();
        return new BatchExecGlobalRuntimeFilterBuilder((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), Collections.singletonList(inputProperty), (LogicalType)FlinkTypeFactory.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription(), this.maxRowCount);
    }
}

