/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Internal
class PseudoRandomValueSelector {
    private static final Logger LOG = LoggerFactory.getLogger(PseudoRandomValueSelector.class);
    private final Function<Integer, Integer> randomValueSupplier;
    private static final long GLOBAL_SEED = (long)PseudoRandomValueSelector.getGlobalSeed().hashCode() << 32;

    private PseudoRandomValueSelector(Function<Integer, Integer> randomValueSupplier) {
        this.randomValueSupplier = randomValueSupplier;
    }

    public <T> void select(Configuration configuration, ConfigOption<T> option, T ... alternatives) {
        if (configuration.contains(option)) {
            return;
        }
        int choice = this.randomValueSupplier.apply(alternatives.length);
        T value = alternatives[choice];
        LOG.info("Randomly selected {} for {}", value, (Object)option.key());
        configuration.set(option, value);
    }

    public static PseudoRandomValueSelector create(Object entryPointSeed) {
        long combinedSeed = GLOBAL_SEED | (long)entryPointSeed.hashCode();
        Random random = new Random(combinedSeed);
        return new PseudoRandomValueSelector(random::nextInt);
    }

    private static String getGlobalSeed() {
        String seed = System.getProperty("test.randomization.seed");
        if (seed != null && !seed.isEmpty()) {
            return seed;
        }
        Optional<String> gitCommitId = PseudoRandomValueSelector.getGitCommitId();
        if (gitCommitId.isPresent()) {
            return gitCommitId.get();
        }
        String commitId = EnvironmentInformation.getGitCommitId();
        if (!commitId.equals("DecafC0ffeeD0d0F00d")) {
            return commitId;
        }
        LOG.warn("Test randomization was enabled but neither test.randomization.seed was configured nor could the commit hash be retrieved from git or the EnvironmentInformation. Please set the test.randomization.seed property manually to make the build reproducible.");
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    static Optional<String> getGitCommitId() {
        try {
            Process process = new ProcessBuilder("git", "rev-parse", "HEAD").start();
            try (InputStream input = process.getInputStream();){
                String commit = IOUtils.toString((InputStream)input, (Charset)Charset.defaultCharset()).trim();
                if (commit.matches("[a-f0-9]{40}")) {
                    Optional<String> optional = Optional.of(commit);
                    return optional;
                }
                LOG.debug("Cannot parse {}", (Object)commit);
                return Optional.empty();
            }
        }
        catch (IOException e) {
            LOG.debug("Could not invoke git", (Throwable)e);
        }
        return Optional.empty();
    }
}

