/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.util.PseudoRandomValueSelector;
import org.apache.flink.test.util.MiniClusterPipelineExecutorServiceLoader;
import org.apache.flink.util.TestNameProvider;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    private static final boolean RANDOMIZE_CHECKPOINTING_CONFIG = Boolean.parseBoolean(System.getProperty("checkpointing.randomization", "false"));

    public TestStreamEnvironment(MiniCluster miniCluster, Configuration config, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        super((PipelineExecutorServiceLoader)new MiniClusterPipelineExecutorServiceLoader(miniCluster), MiniClusterPipelineExecutorServiceLoader.updateConfigurationForMiniCluster(config, jarFiles, classPaths), null);
        this.setParallelism(parallelism);
    }

    public TestStreamEnvironment(MiniCluster miniCluster, int parallelism) {
        this(miniCluster, new Configuration(), parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classpaths) {
        StreamExecutionEnvironmentFactory factory = conf -> {
            TestStreamEnvironment env = new TestStreamEnvironment(miniCluster, conf, parallelism, jarFiles, classpaths);
            TestStreamEnvironment.randomize(conf);
            env.configure((ReadableConfig)conf, env.getUserClassloader());
            return env;
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    private static void randomize(Configuration conf) {
        if (RANDOMIZE_CHECKPOINTING_CONFIG) {
            String testName = TestNameProvider.getCurrentTestName();
            PseudoRandomValueSelector valueSelector = PseudoRandomValueSelector.create(testName != null ? testName : "unknown");
            valueSelector.select(conf, ExecutionCheckpointingOptions.ENABLE_UNALIGNED, true, false);
            valueSelector.select(conf, ExecutionCheckpointingOptions.ALIGNMENT_TIMEOUT, Duration.ofSeconds(0L), Duration.ofMillis(100L), Duration.ofSeconds(2L));
        }
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism) {
        TestStreamEnvironment.setAsContext(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

