/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.NettyHBaseSaslRpcClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Log LOG = LogFactory.getLog(NettyHBaseSaslRpcClientHandler.class);
    private final Promise<Boolean> saslPromise;
    private final UserGroupInformation ugi;
    private final NettyHBaseSaslRpcClient saslRpcClient;

    public NettyHBaseSaslRpcClientHandler(Promise<Boolean> saslPromise, UserGroupInformation ugi, AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, String rpcProtection) throws IOException {
        this.saslPromise = saslPromise;
        this.ugi = ugi;
        this.saslRpcClient = new NettyHBaseSaslRpcClient(method, token, serverPrincipal, fallbackAllowed, rpcProtection);
    }

    private void writeResponse(ChannelHandlerContext ctx, byte[] response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will send token of size " + response.length + " from initSASLContext."));
        }
        ctx.writeAndFlush((Object)ctx.alloc().buffer(4 + response.length).writeInt(response.length).writeBytes(response));
    }

    private void tryComplete(ChannelHandlerContext ctx) {
        if (!this.saslRpcClient.isComplete()) {
            return;
        }
        this.saslRpcClient.setupSaslHandler(ctx.pipeline());
        this.saslPromise.setSuccess((Object)true);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            byte[] initialResponse = (byte[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws Exception {
                    return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.getInitialResponse();
                }
            });
            if (initialResponse != null) {
                this.writeResponse(ctx, initialResponse);
            }
            this.tryComplete(ctx);
        }
        catch (Exception e) {
            this.exceptionCaught(ctx, e);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        int len = msg.readInt();
        if (len == -88) {
            this.saslRpcClient.dispose();
            if (this.saslRpcClient.fallbackAllowed) {
                this.saslPromise.trySuccess((Object)false);
            } else {
                this.saslPromise.tryFailure((Throwable)((Object)new FallbackDisallowedException()));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Will read input token of size " + len + " for processing by initSASLContext"));
        }
        final byte[] challenge = new byte[len];
        msg.readBytes(challenge);
        byte[] response = (byte[])this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return NettyHBaseSaslRpcClientHandler.this.saslRpcClient.evaluateChallenge(challenge);
            }
        });
        if (response != null) {
            this.writeResponse(ctx, response);
        }
        this.tryComplete(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure((Throwable)new IOException("Connection closed"));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.saslRpcClient.dispose();
        this.saslPromise.tryFailure(cause);
    }
}

