/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public interface Tag {
    public static final int TYPE_LENGTH_SIZE = 1;
    public static final int TAG_LENGTH_SIZE = 2;
    public static final int INFRASTRUCTURE_SIZE = 3;
    public static final int MAX_TAG_LENGTH = 65533;
    public static final byte CUSTOM_TAG_TYPE_RANGE = 64;

    public byte getType();

    public int getValueOffset();

    public int getValueLength();

    public boolean hasArray();

    public byte[] getValueArray();

    public ByteBuffer getValueByteBuffer();

    public static byte[] cloneValue(Tag tag) {
        int tagLength = tag.getValueLength();
        byte[] tagArr = new byte[tagLength];
        if (tag.hasArray()) {
            Bytes.putBytes(tagArr, 0, tag.getValueArray(), tag.getValueOffset(), tagLength);
        } else {
            ByteBufferUtils.copyFromBufferToArray(tagArr, tag.getValueByteBuffer(), tag.getValueOffset(), 0, tagLength);
        }
        return tagArr;
    }

    public static String getValueAsString(Tag tag) {
        if (tag.hasArray()) {
            return Bytes.toString(tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        }
        return Bytes.toString(Tag.cloneValue(tag));
    }

    public static boolean matchingValue(Tag t1, Tag t2) {
        if (t1.hasArray() && t2.hasArray()) {
            return Bytes.equals(t1.getValueArray(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        if (t1.hasArray()) {
            return ByteBufferUtils.equals(t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength(), t1.getValueArray(), t1.getValueOffset(), t1.getValueLength());
        }
        if (t2.hasArray()) {
            return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueArray(), t2.getValueOffset(), t2.getValueLength());
        }
        return ByteBufferUtils.equals(t1.getValueByteBuffer(), t1.getValueOffset(), t1.getValueLength(), t2.getValueByteBuffer(), t2.getValueOffset(), t2.getValueLength());
    }

    public static void copyValueTo(Tag tag, byte[] out, int offset) {
        if (tag.hasArray()) {
            Bytes.putBytes(out, offset, tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        } else {
            ByteBufferUtils.copyFromBufferToArray(out, tag.getValueByteBuffer(), tag.getValueOffset(), offset, tag.getValueLength());
        }
    }

    public static long getValueAsLong(Tag tag) {
        if (tag.hasArray()) {
            return Bytes.toLong(tag.getValueArray(), tag.getValueOffset(), tag.getValueLength());
        }
        return ByteBufferUtils.toLong(tag.getValueByteBuffer(), tag.getValueOffset());
    }

    public static byte getValueAsByte(Tag tag) {
        if (tag.hasArray()) {
            return tag.getValueArray()[tag.getValueOffset()];
        }
        return ByteBufferUtils.toByte(tag.getValueByteBuffer(), tag.getValueOffset());
    }
}

