/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.LoadTestDataGeneratorWithVisibilityLabels;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithVisibilityLabels
extends IntegrationTestIngest {
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final String[] LABELS = new String[]{"secret", "topsecret", "confidential", "public", "private"};
    private static final String[] VISIBILITY_EXPS = new String[]{"secret & confidential & !private", "topsecret | confidential", "confidential & private", "public", "topsecret & private", "!public | private", "(secret | topsecret) & private"};
    private static final List<List<String>> AUTHS = new ArrayList<List<String>>();

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        conf.set("hbase.superuser", "admin," + User.getCurrent().getName());
        super.setUpCluster();
        this.addLabels();
    }

    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        String[] args = super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys);
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(args));
        tmp.add("-generator");
        StringBuilder sb = new StringBuilder(LoadTestDataGeneratorWithVisibilityLabels.class.getName());
        sb.append(':');
        sb.append(IntegrationTestIngestWithVisibilityLabels.asCommaSeperatedString(VISIBILITY_EXPS));
        sb.append(':');
        String authorizationsStr = AUTHS.toString();
        sb.append(authorizationsStr.substring(1, authorizationsStr.length() - 1));
        tmp.add(sb.toString());
        return tmp.toArray(new String[tmp.size()]);
    }

    private static String asCommaSeperatedString(String[] list) {
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            sb.append(item);
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void addLabels() throws Exception {
        try {
            VisibilityClient.addLabels((Connection)this.util.getConnection(), (String[])LABELS);
            VisibilityClient.setAuths((Connection)this.util.getConnection(), (String[])LABELS, (String)User.getCurrent().getName());
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("secret");
        tmp.add("confidential");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("topsecret");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("confidential");
        tmp.add("private");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("public");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("topsecret");
        tmp.add("private");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("confidential");
        AUTHS.add(tmp);
        tmp = new ArrayList();
        tmp.add("topsecret");
        tmp.add("private");
        AUTHS.add(tmp);
    }
}

