/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestManyRegions {
    private static final String CLASS_NAME = IntegrationTestManyRegions.class.getSimpleName();
    protected static final Log LOG = LogFactory.getLog(IntegrationTestManyRegions.class);
    protected static final TableName TABLE_NAME = TableName.valueOf((String)CLASS_NAME);
    protected static final String COLUMN_NAME = "f";
    protected static final String REGION_COUNT_KEY = String.format("hbase.%s.regions", CLASS_NAME);
    protected static final String REGIONSERVER_COUNT_KEY = String.format("hbase.%s.regionServers", CLASS_NAME);
    protected static final String TIMEOUT_MINUTES_KEY = String.format("hbase.%s.timeoutMinutes", CLASS_NAME);
    protected static final int DEFAULT_REGION_COUNT = 1000;
    protected static final int DEFAULT_REGIONSERVER_COUNT = 1;
    protected static final int DEFAULT_TIMEOUT_MINUTES = 4;
    protected static final IntegrationTestingUtility util = new IntegrationTestingUtility();
    protected static final int REGION_COUNT = util.getConfiguration().getInt(REGION_COUNT_KEY, 1000);
    protected static final int REGION_SERVER_COUNT = util.getConfiguration().getInt(REGIONSERVER_COUNT_KEY, 1);
    protected static final int TIMEOUT_MINUTES = util.getConfiguration().getInt(TIMEOUT_MINUTES_KEY, 4);

    @Before
    public void setUp() throws Exception {
        LOG.info((Object)String.format("Initializing cluster with %d region servers.", REGION_SERVER_COUNT));
        util.initializeCluster(REGION_SERVER_COUNT);
        LOG.info((Object)"Cluster initialized");
        HBaseAdmin admin = util.getHBaseAdmin();
        if (admin.tableExists(TABLE_NAME)) {
            LOG.info((Object)String.format("Deleting existing table %s.", TABLE_NAME));
            if (admin.isTableEnabled(TABLE_NAME)) {
                admin.disableTable(TABLE_NAME);
            }
            admin.deleteTable(TABLE_NAME);
            LOG.info((Object)String.format("Existing table %s deleted.", TABLE_NAME));
        }
        LOG.info((Object)"Cluster ready");
    }

    @After
    public void tearDown() throws IOException {
        LOG.info((Object)"Cleaning up after test.");
        HBaseAdmin admin = util.getHBaseAdmin();
        if (admin.tableExists(TABLE_NAME)) {
            if (admin.isTableEnabled(TABLE_NAME)) {
                admin.disableTable(TABLE_NAME);
            }
            admin.deleteTable(TABLE_NAME);
        }
        LOG.info((Object)"Restoring cluster.");
        util.restoreCluster();
        LOG.info((Object)"Cluster restored.");
    }

    @Test
    public void testCreateTableWithRegions() throws Exception {
        CountDownLatch doneSignal = new CountDownLatch(1);
        Worker worker = new Worker(doneSignal, (Admin)util.getHBaseAdmin());
        Thread t = new Thread(worker);
        LOG.info((Object)"Launching worker thread to create the table.");
        t.start();
        boolean workerComplete = false;
        workerComplete = doneSignal.await(TIMEOUT_MINUTES, TimeUnit.MINUTES);
        if (!workerComplete) {
            t.interrupt();
            Assert.fail((String)"Timeout limit expired.");
        }
        Assert.assertTrue((String)"Table creation failed.", (boolean)worker.isSuccess());
    }

    private static class Worker
    implements Runnable {
        private final CountDownLatch doneSignal;
        private final Admin admin;
        private boolean success = false;

        public Worker(CountDownLatch doneSignal, Admin admin) {
            this.doneSignal = doneSignal;
            this.admin = admin;
        }

        public boolean isSuccess() {
            return this.success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
            desc.addFamily(new HColumnDescriptor(IntegrationTestManyRegions.COLUMN_NAME));
            RegionSplitter.HexStringSplit algo = new RegionSplitter.HexStringSplit();
            byte[][] splits = algo.split(REGION_COUNT);
            LOG.info((Object)String.format("Creating table %s with %d splits.", TABLE_NAME, REGION_COUNT));
            long startTime = System.currentTimeMillis();
            try {
                this.admin.createTable(desc, splits);
                long endTime = System.currentTimeMillis();
                this.success = true;
                LOG.info((Object)String.format("Pre-split table created successfully in %dms.", endTime - startTime));
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to create table", (Throwable)e);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

