/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class CompactTableAction
extends Action {
    private final TableName tableName;
    private final int majorRatio;
    private final long sleepTime;

    public CompactTableAction(TableName tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactTableAction(int sleepTime, TableName tableName, float majorRatio) {
        this.tableName = tableName;
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        boolean major = RandomUtils.nextInt((int)100) < this.majorRatio;
        LOG.info((Object)("Performing action: Compact table " + this.tableName + ", major=" + major));
        try {
            if (major) {
                admin.majorCompact(this.tableName);
            } else {
                admin.compact(this.tableName);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Compaction failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

