/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.Bytes;

public class RemoveColumnAction
extends Action {
    private final TableName tableName;
    private final Set<String> protectedColumns;
    private Admin admin;
    private Random random;

    public RemoveColumnAction(TableName tableName, Set<String> protectedColumns) {
        this.tableName = tableName;
        this.protectedColumns = protectedColumns;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors.length <= (this.protectedColumns == null ? 1 : this.protectedColumns.size())) {
            return;
        }
        int index = this.random.nextInt(columnDescriptors.length);
        while (this.protectedColumns != null && this.protectedColumns.contains(columnDescriptors[index].getNameAsString())) {
            index = this.random.nextInt(columnDescriptors.length);
        }
        byte[] colDescName = columnDescriptors[index].getName();
        LOG.debug((Object)("Performing action: Removing " + Bytes.toString((byte[])colDescName) + " from " + this.tableName.getNameAsString()));
        tableDescriptor.removeFamily(colDescName);
        if (this.context.isStopping()) {
            return;
        }
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

