/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class SplitAllRegionOfTableAction
extends Action {
    private static final int DEFAULT_MAX_SPLITS = 3;
    private static final String MAX_SPLIT_KEY = "hbase.chaosmonkey.action.maxFullTableSplits";
    private final TableName tableName;
    private int maxFullTableSplits = 3;
    private int splits = 0;

    public SplitAllRegionOfTableAction(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.maxFullTableSplits = this.getConf().getInt(MAX_SPLIT_KEY, 3);
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        if (this.context.isStopping()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() < (double)this.splits / (double)this.maxFullTableSplits / 2.0) {
            ++this.splits;
            LOG.info((Object)("Performing action: Split all regions of  " + this.tableName));
            admin.split(this.tableName);
        } else {
            LOG.info((Object)"Skipping split of all regions.");
        }
    }
}

