/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;

class ContainerFactory {
    final ApplicationAttemptId customAppAttemptId;
    AtomicLong nextId = new AtomicLong(1L);
    private static final int GUARANTEED_WIDTH = 1;
    private static final long GUARANTEED_BIT_MASK = 1L;

    public static boolean isContainerInitializedAsGuaranteed(ContainerId containerId) {
        return (containerId.getContainerId() & 1L) == 0L;
    }

    public ContainerFactory(ApplicationAttemptId appAttemptId, long appIdLong) {
        ApplicationId appId = ApplicationId.newInstance((long)appIdLong, (int)appAttemptId.getApplicationId().getId());
        this.customAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)appAttemptId.getAttemptId());
    }

    public Container createContainer(Resource capability, Priority priority, String hostname, int port, String nodeHttpAddress, boolean isGuaranteed) {
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)this.customAppAttemptId, (long)this.nextContainerId(isGuaranteed));
        NodeId nodeId = NodeId.newInstance((String)hostname, (int)port);
        Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)nodeHttpAddress, (Resource)capability, (Priority)priority, null);
        return container;
    }

    private long nextContainerId(boolean isInitialGuaranteed) {
        long candidate = this.nextId.getAndIncrement();
        candidate <<= 1;
        if (!isInitialGuaranteed) {
            candidate |= 1L;
        }
        return candidate;
    }
}

