/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.write.UnknownColumnTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class StatisticsV2 {
    private StatisticsV2() {
    }

    public static Statistics deserialize(InputStream inputStream, TSDataType dataType) throws IOException {
        Statistics statistics = Statistics.getStatsByType(dataType);
        statistics.setCount((int)ReadWriteIOUtils.readLong(inputStream));
        statistics.setStartTime(ReadWriteIOUtils.readLong(inputStream));
        statistics.setEndTime(ReadWriteIOUtils.readLong(inputStream));
        switch (dataType) {
            case BOOLEAN: {
                boolean firstBool = ReadWriteIOUtils.readBool(inputStream);
                boolean lastBool = ReadWriteIOUtils.readBool(inputStream);
                ((BooleanStatistics)statistics).initializeStats(firstBool, lastBool, 0L);
                break;
            }
            case INT32: {
                int minValue = ReadWriteIOUtils.readInt(inputStream);
                int maxValue = ReadWriteIOUtils.readInt(inputStream);
                int firstValue = ReadWriteIOUtils.readInt(inputStream);
                int lastValue = ReadWriteIOUtils.readInt(inputStream);
                long sumValue = (long)ReadWriteIOUtils.readDouble(inputStream);
                ((IntegerStatistics)statistics).initializeStats(minValue, maxValue, firstValue, lastValue, sumValue);
                break;
            }
            case INT64: 
            case TEXT: 
            case DOUBLE: 
            case FLOAT: {
                statistics.deserialize(inputStream);
                break;
            }
            default: {
                throw new UnknownColumnTypeException(dataType.toString());
            }
        }
        statistics.setEmpty(false);
        return statistics;
    }

    public static Statistics deserialize(ByteBuffer buffer, TSDataType dataType) {
        Statistics statistics = Statistics.getStatsByType(dataType);
        statistics.setCount((int)ReadWriteIOUtils.readLong(buffer));
        statistics.setStartTime(ReadWriteIOUtils.readLong(buffer));
        statistics.setEndTime(ReadWriteIOUtils.readLong(buffer));
        switch (dataType) {
            case BOOLEAN: {
                boolean firstBool = ReadWriteIOUtils.readBool(buffer);
                boolean lastBool = ReadWriteIOUtils.readBool(buffer);
                ((BooleanStatistics)statistics).initializeStats(firstBool, lastBool, 0L);
                break;
            }
            case INT32: {
                int minValue = ReadWriteIOUtils.readInt(buffer);
                int maxValue = ReadWriteIOUtils.readInt(buffer);
                int firstValue = ReadWriteIOUtils.readInt(buffer);
                int lastValue = ReadWriteIOUtils.readInt(buffer);
                long sumValue = (long)ReadWriteIOUtils.readDouble(buffer);
                ((IntegerStatistics)statistics).initializeStats(minValue, maxValue, firstValue, lastValue, sumValue);
                break;
            }
            case INT64: 
            case TEXT: 
            case DOUBLE: 
            case FLOAT: {
                statistics.deserialize(buffer);
                break;
            }
            default: {
                throw new UnknownColumnTypeException(dataType.toString());
            }
        }
        statistics.setEmpty(false);
        return statistics;
    }
}

