/*
 * Decompiled with CFR 0.152.
 */
package jena;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.RDFWriterFImpl;
import org.apache.jena.shared.NoWriterForLangException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.system.JenaSystem;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

@Deprecated
public class rdfcat {
    protected Model m_model = ModelFactory.createDefaultModel();
    protected String m_outputFormat = "RDF/XML-ABBREV";
    protected String m_inputFormat = "RDF/XML";
    protected boolean m_include = false;
    protected Set<String> m_seen = new HashSet<String>();
    protected boolean m_removeIncludeStatements = true;
    protected List<RCAction> m_actionQ = new ArrayList<RCAction>();
    public static boolean suppressDeprecationBanner;
    public final ArgDecl IN_N3 = new ArgDecl(true, "n", "n3", "ttl", "N3", (arg, val) -> this.m_actionQ.add(new ReadAction((String)val, "N3")));
    public final ArgDecl IN_RDF_XML = new ArgDecl(true, "x", "xml", "rdfxml", "rdf", (arg, val) -> this.m_actionQ.add(new ReadAction((String)val, "RDF/XML")));
    public final ArgDecl IN_NTRIPLE = new ArgDecl(true, "t", "ntriples", "ntriple", "n-triple", "n-triples", (arg, val) -> this.m_actionQ.add(new ReadAction((String)val, "N-TRIPLE")));
    public final ArgDecl OUT_LANG = new ArgDecl(true, "out", (arg, val) -> this.setOutput((String)val));
    public final ArgDecl IN_LANG = new ArgDecl(true, "in", (arg, val) -> this.expectInput((String)val));
    public final ArgDecl INCLUDE = new ArgDecl(false, "include", (arg, val) -> this.setInclude(true));
    public final ArgDecl NOINCLUDE = new ArgDecl(false, "noinclude", (arg, val) -> this.setInclude(false));
    public final ArgDecl NOFILTER = new ArgDecl(false, "nofilter", (arg, val) -> this.setRemoveIncludeStatements(false));
    public final ArgDecl HELP = new ArgDecl(false, "help", (arg, val) -> this.usage());
    public final ArgDecl USAGE = new ArgDecl(false, "usage", (arg, val) -> this.usage());
    protected CommandLine m_cmdLine = new RCCommandLine().add(this.IN_N3).add(this.IN_NTRIPLE).add(this.IN_RDF_XML).add(this.OUT_LANG).add(this.IN_LANG).add(this.INCLUDE).add(this.NOINCLUDE).add(this.NOFILTER).add(this.HELP).add(this.USAGE);
    public static Map<String, String> unabbreviate;

    public static void main(String ... args) {
        new rdfcat().go(args);
    }

    protected void go(String[] args) {
        JenaSystem.init();
        if (!suppressDeprecationBanner) {
            System.err.println("------------------------------------------------------------------");
            System.err.println("   DEPRECATED: Please use 'riot' instead.");
            System.err.println("     http://jena.apache.org/documentation/io/#command-line-tools");
            System.err.println("------------------------------------------------------------------");
            System.err.println();
        }
        this.m_cmdLine.process(args);
        for (int i = 0; i < this.m_cmdLine.numItems(); ++i) {
            this.m_actionQ.add(new ReadAction(this.m_cmdLine.getItem(i), this.getExpectedInput()));
        }
        for (RCAction aM_actionQ : this.m_actionQ) {
            aM_actionQ.run(this);
        }
        this.m_model.write(this.getOutputStream(), this.m_outputFormat);
    }

    protected void expectInput(String lang) {
        this.m_inputFormat = lang;
    }

    protected String getExpectedInput() {
        return this.m_inputFormat;
    }

    protected void setOutput(String lang) {
        this.m_outputFormat = rdfcat.getCheckedLanguage(lang);
    }

    public static String getCheckedLanguage(String shortLang) {
        String fullLang = unabbreviate.get(shortLang);
        String tryLang = fullLang == null ? shortLang : fullLang;
        try {
            new RDFWriterFImpl().getWriter(tryLang);
        }
        catch (NoWriterForLangException e) {
            throw new IllegalArgumentException("'" + shortLang + "' is not recognised as a legal output format");
        }
        return tryLang;
    }

    protected static Map<String, String> makeUnabbreviateMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("x", "RDF/XML");
        result.put("rdf", "RDF/XML");
        result.put("rdfxml", "RDF/XML");
        result.put("xml", "RDF/XML");
        result.put("n3", "N3");
        result.put("n", "N3");
        result.put("ttl", "N3");
        result.put("ntriples", "N-TRIPLE");
        result.put("ntriple", "N-TRIPLE");
        result.put("t", "N-TRIPLE");
        result.put("owl", "RDF/XML-ABBREV");
        result.put("abbrev", "RDF/XML-ABBREV");
        return result;
    }

    protected void setInclude(boolean incl) {
        this.m_include = incl;
    }

    protected void setRemoveIncludeStatements(boolean f) {
        this.m_removeIncludeStatements = f;
    }

    protected void readInput(String inputName) {
        ArrayList<IncludeQueueEntry> queue = new ArrayList<IncludeQueueEntry>();
        queue.add(new IncludeQueueEntry(inputName, null));
        while (!queue.isEmpty()) {
            IncludeQueueEntry entry = (IncludeQueueEntry)queue.remove(0);
            String in = entry.m_includeURI;
            if (this.m_seen.contains(in)) continue;
            this.m_seen.add(in);
            Model inModel = ModelFactory.createDefaultModel();
            if (in.equals("-")) {
                inModel.read(System.in, null, this.m_inputFormat);
            } else {
                String lang = FileUtils.guessLang((String)in, (String)this.m_inputFormat);
                FileManager.get().readModel(inModel, in, lang);
            }
            if (this.m_include) {
                this.addIncludes(inModel, queue);
            }
            this.m_model.add(inModel);
            this.m_model.setNsPrefixes((PrefixMapping)inModel);
            if (!this.m_removeIncludeStatements || entry.m_includeStmt == null) continue;
            this.m_model.remove(entry.m_includeStmt);
        }
    }

    protected OutputStream getOutputStream() {
        return System.out;
    }

    protected void addIncludes(Model inModel, List<IncludeQueueEntry> queue) {
        Statement s;
        StmtIterator i = inModel.listStatements(null, RDFS.seeAlso, (RDFNode)null);
        while (i.hasNext()) {
            s = i.nextStatement();
            queue.add(new IncludeQueueEntry(this.getURL(s.getObject()), s));
        }
        i = inModel.listStatements(null, OWL.imports, (RDFNode)null);
        while (i.hasNext()) {
            s = i.nextStatement();
            queue.add(new IncludeQueueEntry(this.getURL((RDFNode)s.getResource()), s));
        }
    }

    protected void usage() {
        System.err.println("------------------------------------");
        System.err.println("DEPRECATED: Please use riot instead.");
        System.err.println("------------------------------------\n");
        System.err.println("Usage: java jena.rdfcat (option|input)*");
        System.err.println("Concatenates the contents of zero or more input RDF documents.");
        System.err.println("Options: -out N3 | N-TRIPLE | RDF/XML | RDF/XML-ABBREV");
        System.err.println("         -n  expect subsequent inputs in N3 syntax");
        System.err.println("         -x  expect subsequent inputs in RDF/XML syntax");
        System.err.println("         -t  expect subsequent inputs in N-TRIPLE syntax");
        System.err.println("         -[no]include  include rdfs:seeAlso and owl:imports");
        System.err.println("input can be filename, URL, or - for stdin");
        System.err.println("Recognised aliases for -n are: -n3 -ttl or -N3");
        System.err.println("Recognised aliases for -x are: -xml -rdf or -rdfxml");
        System.err.println("Recognised aliases for -t are: -ntriple");
        System.err.println("Output format aliases: x, xml or rdf for RDF/XML, n, n3 or ttl for N3, t or ntriple for N-TRIPLE");
        System.err.println("See the Javadoc for jena.rdfcat for additional details.");
        System.exit(0);
    }

    protected String getURL(RDFNode n) {
        return n.isLiteral() ? ((Literal)n).getLexicalForm() : ((Resource)n).getURI();
    }

    static {
        LogCtl.setCmdLogging((String)"jena-log4j.properties");
        suppressDeprecationBanner = false;
        unabbreviate = rdfcat.makeUnabbreviateMap();
    }

    static class ArgDecl {
        boolean takesValue;
        Set<String> names = new HashSet<String>();
        boolean takesArg = false;
        List<BiConsumer<String, String>> argHooks = new ArrayList<BiConsumer<String, String>>();
        public static final boolean HasValue = true;
        public static final boolean NoValue = false;

        public ArgDecl(boolean hasValue) {
            this.takesValue = hasValue;
        }

        public ArgDecl(boolean hasValue, String name) {
            this(hasValue);
            this.addName(name);
        }

        public ArgDecl(boolean hasValue, String name, BiConsumer<String, String> handler) {
            this(hasValue);
            this.addName(name);
            this.addHook(handler);
        }

        public ArgDecl(boolean hasValue, String name1, String name2) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, BiConsumer<String, String> handler) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addHook(handler);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, String name3) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addName(name3);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, String name3, BiConsumer<String, String> handler) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addName(name3);
            this.addHook(handler);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addName(name3);
            this.addName(name4);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4, BiConsumer<String, String> handler) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addName(name3);
            this.addName(name4);
            this.addHook(handler);
        }

        public ArgDecl(boolean hasValue, String name1, String name2, String name3, String name4, String name5, BiConsumer<String, String> handler) {
            this(hasValue);
            this.addName(name1);
            this.addName(name2);
            this.addName(name3);
            this.addName(name4);
            this.addName(name5);
            this.addHook(handler);
        }

        public void addName(String name) {
            name = ArgDecl.canonicalForm(name);
            this.names.add(name);
        }

        public Set<String> getNames() {
            return this.names;
        }

        public Iterator<String> names() {
            return this.names.iterator();
        }

        public void addHook(BiConsumer<String, String> argHandler) {
            this.argHooks.add(argHandler);
        }

        protected void trigger(Arg arg) {
            this.argHooks.forEach(action -> action.accept(arg.getName(), arg.getValue()));
        }

        public boolean takesValue() {
            return this.takesValue;
        }

        public boolean matches(Arg a) {
            for (String n : this.names) {
                if (!a.getName().equals(n)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(String arg) {
            arg = ArgDecl.canonicalForm(arg);
            return this.names.contains(arg);
        }

        static String canonicalForm(String str) {
            if (str.startsWith("--")) {
                return str.substring(2);
            }
            if (str.startsWith("-")) {
                return str.substring(1);
            }
            return str;
        }
    }

    static class Arg {
        String name = null;
        String value = null;
        List<String> values = new ArrayList<String>();

        Arg() {
        }

        Arg(String _name) {
            this();
            this.setName(_name);
        }

        Arg(String _name, String _value) {
            this();
            this.setName(_name);
            this.setValue(_value);
        }

        void setName(String n) {
            this.name = n;
        }

        void setValue(String v) {
            this.value = v;
        }

        void addValue(String v) {
            this.values.add(v);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public boolean matches(ArgDecl decl) {
            return decl.getNames().contains(this.name);
        }
    }

    static class CommandLine {
        protected BiConsumer<String, String> argHook = null;
        protected String usage = null;
        protected Map<String, ArgDecl> argMap = new HashMap<String, ArgDecl>();
        protected Map<String, Arg> args = new HashMap<String, Arg>();
        String indirectionMarker = "@";
        protected boolean allowItemIndirect = false;
        boolean ignoreIndirectionMarker = false;
        protected List<String> items = new ArrayList<String>();

        public void setHook(BiConsumer<String, String> argHandler) {
            this.argHook = argHandler;
        }

        public void setUsage(String usageMessage) {
            this.usage = usageMessage;
        }

        public boolean hasArgs() {
            return this.args.size() > 0;
        }

        public boolean hasItems() {
            return this.items.size() > 0;
        }

        public Iterator<Arg> args() {
            return this.args.values().iterator();
        }

        public int numArgs() {
            return this.args.size();
        }

        public int numItems() {
            return this.items.size();
        }

        public void pushItem(String s) {
            this.items.add(s);
        }

        public boolean isIndirectItem(int i) {
            return this.allowItemIndirect && this.items.get(i).startsWith(this.indirectionMarker);
        }

        public String getItem(int i) {
            return this.getItem(i, this.allowItemIndirect);
        }

        public String getItem(int i, boolean withIndirect) {
            if (i < 0 || i >= this.items.size()) {
                return null;
            }
            String item = this.items.get(i);
            if (withIndirect && item.startsWith(this.indirectionMarker)) {
                item = item.substring(1);
                try {
                    item = FileUtils.readWholeFileAsUTF8((String)item);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Failed to read '" + item + "': " + ex.getMessage());
                }
            }
            return item;
        }

        public void process(String[] argv) throws IllegalArgumentException {
            String argStr;
            int i;
            ArrayList<String> argList = new ArrayList<String>();
            argList.addAll(Arrays.asList(argv));
            for (i = 0; i < argList.size() && !this.endProcessing(argStr = (String)argList.get(i)); ++i) {
                if (this.ignoreArgument(argStr)) continue;
                int j1 = argStr.indexOf(61);
                int j2 = argStr.indexOf(58);
                int j = Integer.MAX_VALUE;
                if (j1 > 0 && j1 < j) {
                    j = j1;
                }
                if (j2 > 0 && j2 < j) {
                    j = j2;
                }
                if (j != Integer.MAX_VALUE) {
                    String a2 = argStr.substring(j + 1);
                    argList.add(i + 1, a2);
                    argStr = argStr.substring(0, j);
                }
                argStr = ArgDecl.canonicalForm(argStr);
                String val = null;
                if (this.argMap.containsKey(argStr)) {
                    if (!this.args.containsKey(argStr)) {
                        this.args.put(argStr, new Arg(argStr));
                    }
                    Arg arg = this.args.get(argStr);
                    ArgDecl argDecl = this.argMap.get(argStr);
                    if (argDecl.takesValue()) {
                        if (i == argList.size() - 1) {
                            throw new IllegalArgumentException("No value for argument: " + arg.getName());
                        }
                        val = (String)argList.get(++i);
                        arg.setValue(val);
                        arg.addValue(val);
                    }
                    if (this.argHook != null) {
                        this.argHook.accept(argStr, val);
                    }
                    argDecl.trigger(arg);
                    continue;
                }
                this.handleUnrecognizedArg((String)argList.get(i));
            }
            if (i < argList.size()) {
                if (((String)argList.get(i)).equals("-") || ((String)argList.get(i)).equals("--")) {
                    ++i;
                }
                while (i < argList.size()) {
                    String item = (String)argList.get(i);
                    this.items.add(item);
                    ++i;
                }
            }
        }

        public boolean ignoreArgument(String argStr) {
            return false;
        }

        public boolean endProcessing(String argStr) {
            return !argStr.startsWith("-") || argStr.equals("--") || argStr.equals("-");
        }

        public void handleUnrecognizedArg(String argStr) {
            throw new IllegalArgumentException("Unknown argument: " + argStr);
        }

        public boolean contains(ArgDecl argDecl) {
            return this.getArg(argDecl) != null;
        }

        public boolean contains(String s) {
            return this.getArg(s) != null;
        }

        public boolean hasArg(String argName) {
            return this.getArg(argName) != null;
        }

        public boolean hasArg(ArgDecl argDecl) {
            return this.getArg(argDecl) != null;
        }

        public Arg getArg(ArgDecl argDecl) {
            Arg arg = null;
            for (Arg a : this.args.values()) {
                if (!argDecl.matches(a)) continue;
                arg = a;
            }
            return arg;
        }

        public Arg getArg(String arg) {
            arg = ArgDecl.canonicalForm(arg);
            return this.args.get(arg);
        }

        public String getValue(ArgDecl argDecl) {
            Arg arg = this.getArg(argDecl);
            if (arg == null) {
                return null;
            }
            if (arg.hasValue()) {
                return arg.getValue();
            }
            return null;
        }

        public String getValue(String argName) {
            Arg arg = this.getArg(argName);
            if (arg == null) {
                return null;
            }
            return arg.getValue();
        }

        public List<String> getValues(ArgDecl argDecl) {
            Arg arg = this.getArg(argDecl);
            if (arg == null) {
                return null;
            }
            return arg.getValues();
        }

        public List<String> getValues(String argName) {
            Arg arg = this.getArg(argName);
            if (arg == null) {
                return null;
            }
            return arg.getValues();
        }

        public CommandLine add(String argName, boolean hasValue) {
            return this.add(new ArgDecl(hasValue, argName));
        }

        public CommandLine add(boolean hasValue, String argName) {
            return this.add(new ArgDecl(hasValue, argName));
        }

        public CommandLine add(ArgDecl arg) {
            Iterator<String> iter = arg.names();
            while (iter.hasNext()) {
                this.argMap.put(iter.next(), arg);
            }
            return this;
        }

        public boolean allowItemIndirect() {
            return this.allowItemIndirect;
        }

        public void setAllowItemIndirect(boolean allowItemIndirect) {
            this.allowItemIndirect = allowItemIndirect;
        }

        public boolean isIgnoreIndirectionMarker() {
            return this.ignoreIndirectionMarker;
        }

        public String getIndirectionMarker() {
            return this.indirectionMarker;
        }

        public void setIndirectionMarker(String indirectionMarker) {
            this.indirectionMarker = indirectionMarker;
        }

        public void setIgnoreIndirectionMarker(boolean ignoreIndirectionMarker) {
            this.ignoreIndirectionMarker = ignoreIndirectionMarker;
        }

        public BiConsumer<String, String> trace() {
            return (arg, val) -> System.err.println("Seen: " + arg + (val != null ? " = " + val : ""));
        }
    }

    protected class ReadAction
    implements RCAction {
        private String m_lang;
        private String m_uri;

        protected ReadAction(String uri, String lang) {
            this.m_lang = lang;
            this.m_uri = uri;
        }

        @Override
        public void run(rdfcat rc) {
            String l = rc.getExpectedInput();
            if (this.m_lang != null) {
                rc.expectInput(this.m_lang);
            }
            rc.readInput(this.m_uri);
            rc.expectInput(l);
        }
    }

    protected static interface RCAction {
        public void run(rdfcat var1);
    }

    protected class IncludeQueueEntry {
        protected String m_includeURI;
        protected Statement m_includeStmt;

        protected IncludeQueueEntry(String includeURI, Statement includeStmt) {
            this.m_includeURI = includeURI;
            this.m_includeStmt = includeStmt;
        }
    }

    protected class RCCommandLine
    extends CommandLine {
        protected RCCommandLine() {
        }

        public boolean xendProcessing(String argStr) {
            return false;
        }

        @Override
        public void handleUnrecognizedArg(String argStr) {
            if (argStr.equals("-") || !argStr.startsWith("-")) {
                rdfcat.this.m_actionQ.add(new ReadAction(argStr, rdfcat.this.getExpectedInput()));
            } else {
                System.err.println("Unrecognised argument: " + argStr);
                rdfcat.this.usage();
            }
        }

        @Override
        public boolean ignoreArgument(String argStr) {
            return !argStr.startsWith("-") || argStr.length() == 1;
        }

        public Iterator<String> getItems() {
            return this.items.iterator();
        }
    }
}

